/************************************************************************************************/
/*																								*/
/* FILE NAME   : Fonts.cpp									VERSION : 							*/
/*																								*/
/* DESCRIPTION : ﾌｫﾝﾄ ｿｰｽﾌｧｲﾙ																	*/
/*																								*/
/* HISTORY     :																				*/
/*																								*/
/************************************************************************************************/

/************************************************************************************************/
/*	《１》取込みファイル定義																	*/
/************************************************************************************************/
#include "fonts.h"

/************************************************************************************************/
/*	《２》ファイル内でのみ使用する定数定義														*/
/************************************************************************************************/
#define _C_DAT_NUM_CHAR			( 0x7e - 0x20 + 1 )										// ' '～'~'
#define _C_DAT_SCALE_24_48		2
#define _C_DAT_WIDTHBYTE_24		3
#define _C_DAT_WIDTHBYTE_48		5
#define _C_DAT_WIDTH_24			17
#define _C_DAT_HEIGHT_24		24
#define _C_DAT_WIDTH_48			( _C_DAT_WIDTH_24  * _C_DAT_SCALE_24_48 )
#define _C_DAT_HEIGHT_48		( _C_DAT_HEIGHT_24 * _C_DAT_SCALE_24_48 )

/************************************************************************************************/
/*	《３》ファイル内でのみ使用するマクロ定義													*/
/************************************************************************************************/

/************************************************************************************************/
/*	《４》ファイル内でのみ使用するTypedef定義(型定義)											*/
/************************************************************************************************/

/************************************************************************************************/
/*	《５》ファイル内でのみ使用する構造体/共用体定義												*/
/************************************************************************************************/

/************************************************************************************************/
/*	《６》ファイル内で共有する変数定義															*/
/************************************************************************************************/
const uint8_t _gFont8_Table[] = 
{
	// @0 ' ' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @8 '!' (5 pixels wide)
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x00, //      
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @16 '"' (5 pixels wide)
	0x50, //  # # 
	0x50, //  # # 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @24 '#' (5 pixels wide)
	0x28, //   # #
	0x50, //  # # 
	0xF8, // #####
	0x50, //  # # 
	0xF8, // #####
	0x50, //  # # 
	0xA0, // # #  
	0x00, //      

	// @32 '$' (5 pixels wide)
	0x20, //   #  
	0x30, //   ## 
	0x60, //  ##  
	0x30, //   ## 
	0x10, //    # 
	0x60, //  ##  
	0x20, //   #  
	0x00, //      

	// @40 '%' (5 pixels wide)
	0x20, //   #  
	0x20, //   #  
	0x18, //    ##
	0x60, //  ##  
	0x10, //    # 
	0x10, //    # 
	0x00, //      
	0x00, //      

	// @48 '&' (5 pixels wide)
	0x00, //      
	0x38, //   ###
	0x20, //   #  
	0x60, //  ##  
	0x50, //  # # 
	0x78, //  ####
	0x00, //      
	0x00, //      

	// @56 ''' (5 pixels wide)
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @64 '(' (5 pixels wide)
	0x10, //    # 
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x10, //    # 
	0x00, //      

	// @72 ')' (5 pixels wide)
	0x40, //  #   
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x40, //  #   
	0x00, //      

	// @80 '*' (5 pixels wide)
	0x20, //   #  
	0x70, //  ### 
	0x20, //   #  
	0x50, //  # # 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @88 '+' (5 pixels wide)
	0x00, //      
	0x20, //   #  
	0x20, //   #  
	0xF8, // #####
	0x20, //   #  
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @96 ',' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x10, //    # 
	0x20, //   #  
	0x20, //   #  
	0x00, //      

	// @104 '-' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x70, //  ### 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @112 '.' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @120 '/' (5 pixels wide)
	0x10, //    # 
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x40, //  #   
	0x40, //  #   
	0x80, // #    
	0x00, //      

	// @128 '0' (5 pixels wide)
	0x20, //   #  
	0x50, //  # # 
	0x50, //  # # 
	0x50, //  # # 
	0x50, //  # # 
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @136 '1' (5 pixels wide)
	0x60, //  ##  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0xF8, // #####
	0x00, //      
	0x00, //      

	// @144 '2' (5 pixels wide)
	0x20, //   #  
	0x50, //  # # 
	0x20, //   #  
	0x20, //   #  
	0x40, //  #   
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @152 '3' (5 pixels wide)
	0x20, //   #  
	0x50, //  # # 
	0x10, //    # 
	0x20, //   #  
	0x10, //    # 
	0x60, //  ##  
	0x00, //      
	0x00, //      

	// @160 '4' (5 pixels wide)
	0x10, //    # 
	0x30, //   ## 
	0x50, //  # # 
	0x78, //  ####
	0x10, //    # 
	0x38, //   ###
	0x00, //      
	0x00, //      

	// @168 '5' (5 pixels wide)
	0x70, //  ### 
	0x40, //  #   
	0x60, //  ##  
	0x10, //    # 
	0x50, //  # # 
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @176 '6' (5 pixels wide)
	0x30, //   ## 
	0x40, //  #   
	0x60, //  ##  
	0x50, //  # # 
	0x50, //  # # 
	0x60, //  ##  
	0x00, //      
	0x00, //      

	// @184 '7' (5 pixels wide)
	0x70, //  ### 
	0x50, //  # # 
	0x10, //    # 
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @192 '8' (5 pixels wide)
	0x20, //   #  
	0x50, //  # # 
	0x20, //   #  
	0x50, //  # # 
	0x50, //  # # 
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @200 '9' (5 pixels wide)
	0x30, //   ## 
	0x50, //  # # 
	0x50, //  # # 
	0x30, //   ## 
	0x10, //    # 
	0x60, //  ##  
	0x00, //      
	0x00, //      

	// @208 ':' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x20, //   #  
	0x00, //      
	0x00, //      
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @216 ';' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x10, //    # 
	0x00, //      
	0x10, //    # 
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @224 '<' (5 pixels wide)
	0x00, //      
	0x10, //    # 
	0x20, //   #  
	0xC0, // ##   
	0x20, //   #  
	0x10, //    # 
	0x00, //      
	0x00, //      

	// @232 '=' (5 pixels wide)
	0x00, //      
	0x70, //  ### 
	0x00, //      
	0x70, //  ### 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @240 '>' (5 pixels wide)
	0x00, //      
	0x40, //  #   
	0x20, //   #  
	0x18, //    ##
	0x20, //   #  
	0x40, //  #   
	0x00, //      
	0x00, //      

	// @248 '?' (5 pixels wide)
	0x20, //   #  
	0x50, //  # # 
	0x10, //    # 
	0x20, //   #  
	0x00, //      
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @256 '@' (5 pixels wide)
	0x30, //   ## 
	0x48, //  #  #
	0x48, //  #  #
	0x58, //  # ##
	0x48, //  #  #
	0x40, //  #   
	0x38, //   ###
	0x00, //      

	// @264 'A' (5 pixels wide)
	0x60, //  ##  
	0x20, //   #  
	0x50, //  # # 
	0x70, //  ### 
	0x88, // #   #
	0xD8, // ## ##
	0x00, //      
	0x00, //      

	// @272 'B' (5 pixels wide)
	0xF0, // #### 
	0x48, //  #  #
	0x70, //  ### 
	0x48, //  #  #
	0x48, //  #  #
	0xF0, // #### 
	0x00, //      
	0x00, //      

	// @280 'C' (5 pixels wide)
	0x70, //  ### 
	0x50, //  # # 
	0x40, //  #   
	0x40, //  #   
	0x40, //  #   
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @288 'D' (5 pixels wide)
	0xF0, // #### 
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0xF0, // #### 
	0x00, //      
	0x00, //      

	// @296 'E' (5 pixels wide)
	0xF8, // #####
	0x48, //  #  #
	0x60, //  ##  
	0x40, //  #   
	0x48, //  #  #
	0xF8, // #####
	0x00, //      
	0x00, //      

	// @304 'F' (5 pixels wide)
	0xF8, // #####
	0x48, //  #  #
	0x60, //  ##  
	0x40, //  #   
	0x40, //  #   
	0xE0, // ###  
	0x00, //      
	0x00, //      

	// @312 'G' (5 pixels wide)
	0x70, //  ### 
	0x40, //  #   
	0x40, //  #   
	0x58, //  # ##
	0x50, //  # # 
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @320 'H' (5 pixels wide)
	0xE8, // ### #
	0x48, //  #  #
	0x78, //  ####
	0x48, //  #  #
	0x48, //  #  #
	0xE8, // ### #
	0x00, //      
	0x00, //      

	// @328 'I' (5 pixels wide)
	0x70, //  ### 
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @336 'J' (5 pixels wide)
	0x38, //   ###
	0x10, //    # 
	0x10, //    # 
	0x50, //  # # 
	0x50, //  # # 
	0x20, //   #  
	0x00, //      
	0x00, //      

	// @344 'K' (5 pixels wide)
	0xD8, // ## ##
	0x50, //  # # 
	0x60, //  ##  
	0x70, //  ### 
	0x50, //  # # 
	0xD8, // ## ##
	0x00, //      
	0x00, //      

	// @352 'L' (5 pixels wide)
	0xE0, // ###  
	0x40, //  #   
	0x40, //  #   
	0x40, //  #   
	0x48, //  #  #
	0xF8, // #####
	0x00, //      
	0x00, //      

	// @360 'M' (5 pixels wide)
	0xD8, // ## ##
	0xD8, // ## ##
	0xD8, // ## ##
	0xA8, // # # #
	0x88, // #   #
	0xD8, // ## ##
	0x00, //      
	0x00, //      

	// @368 'N' (5 pixels wide)
	0xD8, // ## ##
	0x68, //  ## #
	0x68, //  ## #
	0x58, //  # ##
	0x58, //  # ##
	0xE8, // ### #
	0x00, //      
	0x00, //      

	// @376 'O' (5 pixels wide)
	0x30, //   ## 
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @384 'P' (5 pixels wide)
	0xF0, // #### 
	0x48, //  #  #
	0x48, //  #  #
	0x70, //  ### 
	0x40, //  #   
	0xE0, // ###  
	0x00, //      
	0x00, //      

	// @392 'Q' (5 pixels wide)
	0x30, //   ## 
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x30, //   ## 
	0x18, //    ##
	0x00, //      

	// @400 'R' (5 pixels wide)
	0xF0, // #### 
	0x48, //  #  #
	0x48, //  #  #
	0x70, //  ### 
	0x48, //  #  #
	0xE8, // ### #
	0x00, //      
	0x00, //      

	// @408 'S' (5 pixels wide)
	0x70, //  ### 
	0x50, //  # # 
	0x20, //   #  
	0x10, //    # 
	0x50, //  # # 
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @416 'T' (5 pixels wide)
	0xF8, // #####
	0xA8, // # # #
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @424 'U' (5 pixels wide)
	0xD8, // ## ##
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x48, //  #  #
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @432 'V' (5 pixels wide)
	0xD8, // ## ##
	0x88, // #   #
	0x48, //  #  #
	0x50, //  # # 
	0x50, //  # # 
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @440 'W' (5 pixels wide)
	0xD8, // ## ##
	0x88, // #   #
	0xA8, // # # #
	0xA8, // # # #
	0xA8, // # # #
	0x50, //  # # 
	0x00, //      
	0x00, //      

	// @448 'X' (5 pixels wide)
	0xD8, // ## ##
	0x50, //  # # 
	0x20, //   #  
	0x20, //   #  
	0x50, //  # # 
	0xD8, // ## ##
	0x00, //      
	0x00, //      

	// @456 'Y' (5 pixels wide)
	0xD8, // ## ##
	0x88, // #   #
	0x50, //  # # 
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @464 'Z' (5 pixels wide)
	0x78, //  ####
	0x48, //  #  #
	0x10, //    # 
	0x20, //   #  
	0x48, //  #  #
	0x78, //  ####
	0x00, //      
	0x00, //      

	// @472 '[' (5 pixels wide)
	0x30, //   ## 
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x30, //   ## 
	0x00, //      

	// @480 '\' (5 pixels wide)
	0x80, // #    
	0x40, //  #   
	0x40, //  #   
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x10, //    # 
	0x00, //      

	// @488 ']' (5 pixels wide)
	0x60, //  ##  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x60, //  ##  
	0x00, //      

	// @496 '^' (5 pixels wide)
	0x20, //   #  
	0x20, //   #  
	0x50, //  # # 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @504 '_' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0xF8, // #####

	// @512 '`' (5 pixels wide)
	0x20, //   #  
	0x10, //    # 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @520 'a' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x30, //   ## 
	0x10, //    # 
	0x70, //  ### 
	0x78, //  ####
	0x00, //      
	0x00, //      

	// @528 'b' (5 pixels wide)
	0xC0, // ##   
	0x40, //  #   
	0x70, //  ### 
	0x48, //  #  #
	0x48, //  #  #
	0xF0, // #### 
	0x00, //      
	0x00, //      

	// @536 'c' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x70, //  ### 
	0x40, //  #   
	0x40, //  #   
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @544 'd' (5 pixels wide)
	0x18, //    ##
	0x08, //     #
	0x38, //   ###
	0x48, //  #  #
	0x48, //  #  #
	0x38, //   ###
	0x00, //      
	0x00, //      

	// @552 'e' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x70, //  ### 
	0x70, //  ### 
	0x40, //  #   
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @560 'f' (5 pixels wide)
	0x10, //    # 
	0x20, //   #  
	0x70, //  ### 
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @568 'g' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x38, //   ###
	0x48, //  #  #
	0x48, //  #  #
	0x38, //   ###
	0x08, //     #
	0x30, //   ## 

	// @576 'h' (5 pixels wide)
	0xC0, // ##   
	0x40, //  #   
	0x70, //  ### 
	0x48, //  #  #
	0x48, //  #  #
	0xE8, // ### #
	0x00, //      
	0x00, //      

	// @584 'i' (5 pixels wide)
	0x20, //   #  
	0x00, //      
	0x60, //  ##  
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @592 'j' (5 pixels wide)
	0x20, //   #  
	0x00, //      
	0x70, //  ### 
	0x10, //    # 
	0x10, //    # 
	0x10, //    # 
	0x10, //    # 
	0x70, //  ### 

	// @600 'k' (5 pixels wide)
	0xC0, // ##   
	0x40, //  #   
	0x58, //  # ##
	0x70, //  ### 
	0x50, //  # # 
	0xD8, // ## ##
	0x00, //      
	0x00, //      

	// @608 'l' (5 pixels wide)
	0x60, //  ##  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @616 'm' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xD0, // ## # 
	0xA8, // # # #
	0xA8, // # # #
	0xA8, // # # #
	0x00, //      
	0x00, //      

	// @624 'n' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xF0, // #### 
	0x48, //  #  #
	0x48, //  #  #
	0xC8, // ##  #
	0x00, //      
	0x00, //      

	// @632 'o' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x30, //   ## 
	0x48, //  #  #
	0x48, //  #  #
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @640 'p' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xF0, // #### 
	0x48, //  #  #
	0x48, //  #  #
	0x70, //  ### 
	0x40, //  #   
	0xE0, // ###  

	// @648 'q' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x38, //   ###
	0x48, //  #  #
	0x48, //  #  #
	0x38, //   ###
	0x08, //     #
	0x18, //    ##

	// @656 'r' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x78, //  ####
	0x20, //   #  
	0x20, //   #  
	0x70, //  ### 
	0x00, //      
	0x00, //      

	// @664 's' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x30, //   ## 
	0x20, //   #  
	0x10, //    # 
	0x60, //  ##  
	0x00, //      
	0x00, //      

	// @672 't' (5 pixels wide)
	0x00, //      
	0x40, //  #   
	0xF0, // #### 
	0x40, //  #   
	0x48, //  #  #
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @680 'u' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xD8, // ## ##
	0x48, //  #  #
	0x48, //  #  #
	0x38, //   ###
	0x00, //      
	0x00, //      

	// @688 'v' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xC8, // ##  #
	0x48, //  #  #
	0x30, //   ## 
	0x30, //   ## 
	0x00, //      
	0x00, //      

	// @696 'w' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xD8, // ## ##
	0xA8, // # # #
	0xA8, // # # #
	0x50, //  # # 
	0x00, //      
	0x00, //      

	// @704 'x' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x48, //  #  #
	0x30, //   ## 
	0x30, //   ## 
	0x48, //  #  #
	0x00, //      
	0x00, //      

	// @712 'y' (5 pixels wide)
	0x00, //      
	0x00, //      
	0xD8, // ## ##
	0x50, //  # # 
	0x50, //  # # 
	0x20, //   #  
	0x20, //   #  
	0x60, //  ##  

	// @720 'z' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x78, //  ####
	0x50, //  # # 
	0x28, //   # #
	0x78, //  ####
	0x00, //      
	0x00, //      

	// @728 '{' (5 pixels wide)
	0x10, //    # 
	0x20, //   #  
	0x20, //   #  
	0x60, //  ##  
	0x20, //   #  
	0x20, //   #  
	0x10, //    # 
	0x00, //      

	// @736 '|' (5 pixels wide)
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x20, //   #  
	0x00, //      

	// @744 '}' (5 pixels wide)
	0x40, //  #   
	0x20, //   #  
	0x20, //   #  
	0x30, //   ## 
	0x20, //   #  
	0x20, //   #  
	0x40, //  #   
	0x00, //      

	// @752 '~' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x28, //   # #
	0x50, //  # # 
	0x00, //      
	0x00, //      
	0x00, //      
};
const uint8_t _gFont12_Table[] = 
{
	// @0 ' ' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @12 '!' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x00, //        

	// @24 '"' (7 pixels wide)
	0x00, //        
	0x6C, //  ## ## 
	0x48, //  #  #  
	0x48, //  #  #  
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @36 '#' (7 pixels wide)
	0x00, //        
	0x14, //    # # 
	0x14, //    # # 
	0x28, //   # #  
	0x7C, //  ##### 
	0x28, //   # #  
	0x7C, //  ##### 
	0x28, //   # #  
	0x50, //  # #   
	0x50, //  # #   
	0x00, //        
	0x00, //        

	// @48 '$' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x38, //   ###  
	0x40, //  #     
	0x40, //  #     
	0x38, //   ###  
	0x48, //  #  #  
	0x70, //  ###   
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        

	// @60 '%' (7 pixels wide)
	0x00, //        
	0x20, //   #    
	0x50, //  # #   
	0x20, //   #    
	0x0C, //     ## 
	0x70, //  ###   
	0x08, //     #  
	0x14, //    # # 
	0x08, //     #  
	0x00, //        
	0x00, //        
	0x00, //        

	// @72 '&' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x18, //    ##  
	0x20, //   #    
	0x20, //   #    
	0x54, //  # # # 
	0x48, //  #  #  
	0x34, //   ## # 
	0x00, //        
	0x00, //        
	0x00, //        

	// @84 ''' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @96 '(' (7 pixels wide)
	0x00, //        
	0x08, //     #  
	0x08, //     #  
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x08, //     #  
	0x08, //     #  
	0x00, //        

	// @108 ')' (7 pixels wide)
	0x00, //        
	0x20, //   #    
	0x20, //   #    
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x20, //   #    
	0x20, //   #    
	0x00, //        

	// @120 '*' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x7C, //  ##### 
	0x10, //    #   
	0x28, //   # #  
	0x28, //   # #  
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @132 '+' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0xFE, // #######
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x00, //        

	// @144 ',' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x18, //    ##  
	0x10, //    #   
	0x30, //   ##   
	0x20, //   #    
	0x00, //        

	// @156 '-' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @168 '.' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x30, //   ##   
	0x30, //   ##   
	0x00, //        
	0x00, //        
	0x00, //        

	// @180 '/' (7 pixels wide)
	0x00, //        
	0x04, //      # 
	0x04, //      # 
	0x08, //     #  
	0x08, //     #  
	0x10, //    #   
	0x10, //    #   
	0x20, //   #    
	0x20, //   #    
	0x40, //  #     
	0x00, //        
	0x00, //        

	// @192 '0' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @204 '1' (7 pixels wide)
	0x00, //        
	0x30, //   ##   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @216 '2' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x04, //      # 
	0x08, //     #  
	0x10, //    #   
	0x20, //   #    
	0x44, //  #   # 
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @228 '3' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x04, //      # 
	0x18, //    ##  
	0x04, //      # 
	0x04, //      # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @240 '4' (7 pixels wide)
	0x00, //        
	0x0C, //     ## 
	0x14, //    # # 
	0x14, //    # # 
	0x24, //   #  # 
	0x44, //  #   # 
	0x7E, //  ######
	0x04, //      # 
	0x0E, //     ###
	0x00, //        
	0x00, //        
	0x00, //        

	// @252 '5' (7 pixels wide)
	0x00, //        
	0x3C, //   #### 
	0x20, //   #    
	0x20, //   #    
	0x38, //   ###  
	0x04, //      # 
	0x04, //      # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @264 '6' (7 pixels wide)
	0x00, //        
	0x1C, //    ### 
	0x20, //   #    
	0x40, //  #     
	0x78, //  ####  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @276 '7' (7 pixels wide)
	0x00, //        
	0x7C, //  ##### 
	0x44, //  #   # 
	0x04, //      # 
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x00, //        

	// @288 '8' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @300 '9' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x3C, //   #### 
	0x04, //      # 
	0x08, //     #  
	0x70, //  ###   
	0x00, //        
	0x00, //        
	0x00, //        

	// @312 ':' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x30, //   ##   
	0x30, //   ##   
	0x00, //        
	0x00, //        
	0x30, //   ##   
	0x30, //   ##   
	0x00, //        
	0x00, //        
	0x00, //        

	// @324 ';' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x18, //    ##  
	0x18, //    ##  
	0x00, //        
	0x00, //        
	0x18, //    ##  
	0x30, //   ##   
	0x20, //   #    
	0x00, //        
	0x00, //        

	// @336 '<' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x0C, //     ## 
	0x10, //    #   
	0x60, //  ##    
	0x80, // #      
	0x60, //  ##    
	0x10, //    #   
	0x0C, //     ## 
	0x00, //        
	0x00, //        
	0x00, //        

	// @348 '=' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x7C, //  ##### 
	0x00, //        
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @360 '>' (7 pixels wide)
	0x00, //        
	0x00, //        
	0xC0, // ##     
	0x20, //   #    
	0x18, //    ##  
	0x04, //      # 
	0x18, //    ##  
	0x20, //   #    
	0xC0, // ##     
	0x00, //        
	0x00, //        
	0x00, //        

	// @372 '?' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x18, //    ##  
	0x24, //   #  # 
	0x04, //      # 
	0x08, //     #  
	0x10, //    #   
	0x00, //        
	0x30, //   ##   
	0x00, //        
	0x00, //        
	0x00, //        

	// @384 '@' (7 pixels wide)
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x4C, //  #  ## 
	0x54, //  # # # 
	0x54, //  # # # 
	0x4C, //  #  ## 
	0x40, //  #     
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        

	// @396 'A' (7 pixels wide)
	0x00, //        
	0x30, //   ##   
	0x10, //    #   
	0x28, //   # #  
	0x28, //   # #  
	0x28, //   # #  
	0x7C, //  ##### 
	0x44, //  #   # 
	0xEE, // ### ###
	0x00, //        
	0x00, //        
	0x00, //        

	// @408 'B' (7 pixels wide)
	0x00, //        
	0xF8, // #####  
	0x44, //  #   # 
	0x44, //  #   # 
	0x78, //  ####  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0xF8, // #####  
	0x00, //        
	0x00, //        
	0x00, //        

	// @420 'C' (7 pixels wide)
	0x00, //        
	0x3C, //   #### 
	0x44, //  #   # 
	0x40, //  #     
	0x40, //  #     
	0x40, //  #     
	0x40, //  #     
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @432 'D' (7 pixels wide)
	0x00, //        
	0xF0, // ####   
	0x48, //  #  #  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x48, //  #  #  
	0xF0, // ####   
	0x00, //        
	0x00, //        
	0x00, //        

	// @444 'E' (7 pixels wide)
	0x00, //        
	0xFC, // ###### 
	0x44, //  #   # 
	0x50, //  # #   
	0x70, //  ###   
	0x50, //  # #   
	0x40, //  #     
	0x44, //  #   # 
	0xFC, // ###### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @456 'F' (7 pixels wide)
	0x00, //        
	0x7E, //  ######
	0x22, //   #   #
	0x28, //   # #  
	0x38, //   ###  
	0x28, //   # #  
	0x20, //   #    
	0x20, //   #    
	0x70, //  ###   
	0x00, //        
	0x00, //        
	0x00, //        

	// @468 'G' (7 pixels wide)
	0x00, //        
	0x3C, //   #### 
	0x44, //  #   # 
	0x40, //  #     
	0x40, //  #     
	0x4E, //  #  ###
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @480 'H' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x44, //  #   # 
	0x7C, //  ##### 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0xEE, // ### ###
	0x00, //        
	0x00, //        
	0x00, //        

	// @492 'I' (7 pixels wide)
	0x00, //        
	0x7C, //  ##### 
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @504 'J' (7 pixels wide)
	0x00, //        
	0x3C, //   #### 
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x48, //  #  #  
	0x48, //  #  #  
	0x48, //  #  #  
	0x30, //   ##   
	0x00, //        
	0x00, //        
	0x00, //        

	// @516 'K' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x48, //  #  #  
	0x50, //  # #   
	0x70, //  ###   
	0x48, //  #  #  
	0x44, //  #   # 
	0xE6, // ###  ##
	0x00, //        
	0x00, //        
	0x00, //        

	// @528 'L' (7 pixels wide)
	0x00, //        
	0x70, //  ###   
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x24, //   #  # 
	0x24, //   #  # 
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @540 'M' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x6C, //  ## ## 
	0x6C, //  ## ## 
	0x54, //  # # # 
	0x54, //  # # # 
	0x44, //  #   # 
	0x44, //  #   # 
	0xEE, // ### ###
	0x00, //        
	0x00, //        
	0x00, //        

	// @552 'N' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x64, //  ##  # 
	0x64, //  ##  # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x4C, //  #  ## 
	0xEC, // ### ## 
	0x00, //        
	0x00, //        
	0x00, //        

	// @564 'O' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @576 'P' (7 pixels wide)
	0x00, //        
	0x78, //  ####  
	0x24, //   #  # 
	0x24, //   #  # 
	0x24, //   #  # 
	0x38, //   ###  
	0x20, //   #    
	0x20, //   #    
	0x70, //  ###   
	0x00, //        
	0x00, //        
	0x00, //        

	// @588 'Q' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x1C, //    ### 
	0x00, //        
	0x00, //        

	// @600 'R' (7 pixels wide)
	0x00, //        
	0xF8, // #####  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x78, //  ####  
	0x48, //  #  #  
	0x44, //  #   # 
	0xE2, // ###   #
	0x00, //        
	0x00, //        
	0x00, //        

	// @612 'S' (7 pixels wide)
	0x00, //        
	0x34, //   ## # 
	0x4C, //  #  ## 
	0x40, //  #     
	0x38, //   ###  
	0x04, //      # 
	0x04, //      # 
	0x64, //  ##  # 
	0x58, //  # ##  
	0x00, //        
	0x00, //        
	0x00, //        

	// @624 'T' (7 pixels wide)
	0x00, //        
	0xFE, // #######
	0x92, // #  #  #
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @636 'U' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @648 'V' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x44, //  #   # 
	0x28, //   # #  
	0x28, //   # #  
	0x28, //   # #  
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x00, //        

	// @660 'W' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x44, //  #   # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x28, //   # #  
	0x00, //        
	0x00, //        
	0x00, //        

	// @672 'X' (7 pixels wide)
	0x00, //        
	0xC6, // ##   ##
	0x44, //  #   # 
	0x28, //   # #  
	0x10, //    #   
	0x10, //    #   
	0x28, //   # #  
	0x44, //  #   # 
	0xC6, // ##   ##
	0x00, //        
	0x00, //        
	0x00, //        

	// @684 'Y' (7 pixels wide)
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x28, //   # #  
	0x28, //   # #  
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @696 'Z' (7 pixels wide)
	0x00, //        
	0x7C, //  ##### 
	0x44, //  #   # 
	0x08, //     #  
	0x10, //    #   
	0x10, //    #   
	0x20, //   #    
	0x44, //  #   # 
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @708 '[' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x38, //   ###  
	0x00, //        

	// @720 '\' (7 pixels wide)
	0x00, //        
	0x40, //  #     
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x10, //    #   
	0x10, //    #   
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x00, //        
	0x00, //        

	// @732 ']' (7 pixels wide)
	0x00, //        
	0x38, //   ###  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x38, //   ###  
	0x00, //        

	// @744 '^' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x10, //    #   
	0x28, //   # #  
	0x44, //  #   # 
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @756 '_' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0xFE, // #######

	// @768 '`' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x08, //     #  
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @780 'a' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x3C, //   #### 
	0x44, //  #   # 
	0x44, //  #   # 
	0x3E, //   #####
	0x00, //        
	0x00, //        
	0x00, //        

	// @792 'b' (7 pixels wide)
	0x00, //        
	0xC0, // ##     
	0x40, //  #     
	0x58, //  # ##  
	0x64, //  ##  # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0xF8, // #####  
	0x00, //        
	0x00, //        
	0x00, //        

	// @804 'c' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x3C, //   #### 
	0x44, //  #   # 
	0x40, //  #     
	0x40, //  #     
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @816 'd' (7 pixels wide)
	0x00, //        
	0x0C, //     ## 
	0x04, //      # 
	0x34, //   ## # 
	0x4C, //  #  ## 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x3E, //   #####
	0x00, //        
	0x00, //        
	0x00, //        

	// @828 'e' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x7C, //  ##### 
	0x40, //  #     
	0x40, //  #     
	0x3C, //   #### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @840 'f' (7 pixels wide)
	0x00, //        
	0x1C, //    ### 
	0x20, //   #    
	0x7C, //  ##### 
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @852 'g' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x36, //   ## ##
	0x4C, //  #  ## 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x3C, //   #### 
	0x04, //      # 
	0x38, //   ###  
	0x00, //        

	// @864 'h' (7 pixels wide)
	0x00, //        
	0xC0, // ##     
	0x40, //  #     
	0x58, //  # ##  
	0x64, //  ##  # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0xEE, // ### ###
	0x00, //        
	0x00, //        
	0x00, //        

	// @876 'i' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x00, //        
	0x70, //  ###   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @888 'j' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x00, //        
	0x78, //  ####  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x08, //     #  
	0x70, //  ###   
	0x00, //        

	// @900 'k' (7 pixels wide)
	0x00, //        
	0xC0, // ##     
	0x40, //  #     
	0x5C, //  # ### 
	0x48, //  #  #  
	0x70, //  ###   
	0x50, //  # #   
	0x48, //  #  #  
	0xDC, // ## ### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @912 'l' (7 pixels wide)
	0x00, //        
	0x30, //   ##   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @924 'm' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xE8, // ### #  
	0x54, //  # # # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x54, //  # # # 
	0xFE, // #######
	0x00, //        
	0x00, //        
	0x00, //        

	// @936 'n' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xD8, // ## ##  
	0x64, //  ##  # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0xEE, // ### ###
	0x00, //        
	0x00, //        
	0x00, //        

	// @948 'o' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x38, //   ###  
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x38, //   ###  
	0x00, //        
	0x00, //        
	0x00, //        

	// @960 'p' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xD8, // ## ##  
	0x64, //  ##  # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x78, //  ####  
	0x40, //  #     
	0xE0, // ###    
	0x00, //        

	// @972 'q' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x36, //   ## ##
	0x4C, //  #  ## 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x3C, //   #### 
	0x04, //      # 
	0x0E, //     ###
	0x00, //        

	// @984 'r' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x6C, //  ## ## 
	0x30, //   ##   
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @996 's' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x3C, //   #### 
	0x44, //  #   # 
	0x38, //   ###  
	0x04, //      # 
	0x44, //  #   # 
	0x78, //  ####  
	0x00, //        
	0x00, //        
	0x00, //        

	// @1008 't' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x20, //   #    
	0x7C, //  ##### 
	0x20, //   #    
	0x20, //   #    
	0x20, //   #    
	0x22, //   #   #
	0x1C, //    ### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @1020 'u' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xCC, // ##  ## 
	0x44, //  #   # 
	0x44, //  #   # 
	0x44, //  #   # 
	0x4C, //  #  ## 
	0x36, //   ## ##
	0x00, //        
	0x00, //        
	0x00, //        

	// @1032 'v' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x44, //  #   # 
	0x28, //   # #  
	0x28, //   # #  
	0x10, //    #   
	0x00, //        
	0x00, //        
	0x00, //        

	// @1044 'w' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x54, //  # # # 
	0x28, //   # #  
	0x00, //        
	0x00, //        
	0x00, //        

	// @1056 'x' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xCC, // ##  ## 
	0x48, //  #  #  
	0x30, //   ##   
	0x30, //   ##   
	0x48, //  #  #  
	0xCC, // ##  ## 
	0x00, //        
	0x00, //        
	0x00, //        

	// @1068 'y' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0xEE, // ### ###
	0x44, //  #   # 
	0x24, //   #  # 
	0x28, //   # #  
	0x18, //    ##  
	0x10, //    #   
	0x10, //    #   
	0x78, //  ####  
	0x00, //        

	// @1080 'z' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x7C, //  ##### 
	0x48, //  #  #  
	0x10, //    #   
	0x20, //   #    
	0x44, //  #   # 
	0x7C, //  ##### 
	0x00, //        
	0x00, //        
	0x00, //        

	// @1092 '{' (7 pixels wide)
	0x00, //        
	0x08, //     #  
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x20, //   #    
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x08, //     #  
	0x00, //        

	// @1104 '|' (7 pixels wide)
	0x00, //        
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x00, //        
	0x00, //        

	// @1116 '}' (7 pixels wide)
	0x00, //        
	0x20, //   #    
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x08, //     #  
	0x10, //    #   
	0x10, //    #   
	0x10, //    #   
	0x20, //   #    
	0x00, //        

	// @1128 '~' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x24, //   #  # 
	0x58, //  # ##  
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
};
const uint8_t _gFont16_Table[] = 
{
	// @0 ' ' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @32 '!' (11 pixels wide)
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @64 '"' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1D, 0xC0, //    ### ### 
	0x1D, 0xC0, //    ### ### 
	0x08, 0x80, //     #   #  
	0x08, 0x80, //     #   #  
	0x08, 0x80, //     #   #  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @96 '#' (11 pixels wide)
	0x00, 0x00, //            
	0x0D, 0x80, //     ## ##  
	0x0D, 0x80, //     ## ##  
	0x0D, 0x80, //     ## ##  
	0x0D, 0x80, //     ## ##  
	0x3F, 0xC0, //   ######## 
	0x1B, 0x00, //    ## ##   
	0x3F, 0xC0, //   ######## 
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @128 '$' (11 pixels wide)
	0x04, 0x00, //      #     
	0x1F, 0x80, //    ######  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x38, 0x00, //   ###      
	0x1E, 0x00, //    ####    
	0x0F, 0x00, //     ####   
	0x03, 0x80, //       ###  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x00, //   ######   
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @160 '%' (11 pixels wide)
	0x00, 0x00, //            
	0x18, 0x00, //    ##      
	0x24, 0x00, //   #  #     
	0x24, 0x00, //   #  #     
	0x18, 0xC0, //    ##   ## 
	0x07, 0x80, //      ####  
	0x1E, 0x00, //    ####    
	0x31, 0x80, //   ##   ##  
	0x02, 0x40, //       #  # 
	0x02, 0x40, //       #  # 
	0x01, 0x80, //        ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @192 '&' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0F, 0x00, //     ####   
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x0C, 0x00, //     ##     
	0x1D, 0x80, //    ### ##  
	0x37, 0x00, //   ## ###   
	0x33, 0x00, //   ##  ##   
	0x1D, 0x80, //    ### ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @224 ''' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x07, 0x00, //      ###   
	0x07, 0x00, //      ###   
	0x02, 0x00, //       #    
	0x02, 0x00, //       #    
	0x02, 0x00, //       #    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @256 '(' (11 pixels wide)
	0x00, 0x00, //            
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x0E, 0x00, //     ###    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0E, 0x00, //     ###    
	0x06, 0x00, //      ##    
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @288 ')' (11 pixels wide)
	0x00, 0x00, //            
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x1C, 0x00, //    ###     
	0x18, 0x00, //    ##      
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @320 '*' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x3F, 0xC0, //   ######## 
	0x3F, 0xC0, //   ######## 
	0x0F, 0x00, //     ####   
	0x1F, 0x80, //    ######  
	0x19, 0x80, //    ##  ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @352 '+' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x3F, 0x80, //   #######  
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @384 ',' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x04, 0x00, //      #     
	0x0C, 0x00, //     ##     
	0x08, 0x00, //     #      
	0x08, 0x00, //     #      
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @416 '-' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x80, //   #######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @448 '.' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @480 '/' (11 pixels wide)
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @512 '0' (11 pixels wide)
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x1B, 0x00, //    ## ##   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1B, 0x00, //    ## ##   
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @544 '1' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x3E, 0x00, //   #####    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @576 '2' (11 pixels wide)
	0x00, 0x00, //            
	0x0F, 0x00, //     ####   
	0x19, 0x80, //    ##  ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x3F, 0x80, //   #######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @608 '3' (11 pixels wide)
	0x00, 0x00, //            
	0x3F, 0x00, //   ######   
	0x61, 0x80, //  ##    ##  
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x1F, 0x00, //    #####   
	0x03, 0x80, //       ###  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x61, 0x80, //  ##    ##  
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @640 '4' (11 pixels wide)
	0x00, 0x00, //            
	0x07, 0x00, //      ###   
	0x07, 0x00, //      ###   
	0x0F, 0x00, //     ####   
	0x0B, 0x00, //     # ##   
	0x1B, 0x00, //    ## ##   
	0x13, 0x00, //    #  ##   
	0x33, 0x00, //   ##  ##   
	0x3F, 0x80, //   #######  
	0x03, 0x00, //       ##   
	0x0F, 0x80, //     #####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @672 '5' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x80, //    ######  
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x1F, 0x00, //    #####   
	0x11, 0x80, //    #   ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x21, 0x80, //   #    ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @704 '6' (11 pixels wide)
	0x00, 0x00, //            
	0x07, 0x80, //      ####  
	0x1C, 0x00, //    ###     
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x37, 0x00, //   ## ###   
	0x39, 0x80, //   ###  ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x19, 0x80, //    ##  ##  
	0x0F, 0x00, //     ####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @736 '7' (11 pixels wide)
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x43, 0x00, //  #    ##   
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @768 '8' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @800 '9' (11 pixels wide)
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x33, 0x00, //   ##  ##   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x33, 0x80, //   ##  ###  
	0x1D, 0x80, //    ### ##  
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x07, 0x00, //      ###   
	0x3C, 0x00, //   ####     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @832 ':' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @864 ';' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x04, 0x00, //      #     
	0x08, 0x00, //     #      
	0x08, 0x00, //     #      
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @896 '<' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0xC0, //         ## 
	0x03, 0x00, //       ##   
	0x04, 0x00, //      #     
	0x18, 0x00, //    ##      
	0x60, 0x00, //  ##        
	0x18, 0x00, //    ##      
	0x04, 0x00, //      #     
	0x03, 0x00, //       ##   
	0x00, 0xC0, //         ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @928 '=' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0xC0, //  ######### 
	0x00, 0x00, //            
	0x7F, 0xC0, //  ######### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @960 '>' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0x00, //  ##        
	0x18, 0x00, //    ##      
	0x04, 0x00, //      #     
	0x03, 0x00, //       ##   
	0x00, 0xC0, //         ## 
	0x03, 0x00, //       ##   
	0x04, 0x00, //      #     
	0x18, 0x00, //    ##      
	0x60, 0x00, //  ##        
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @992 '?' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x01, 0x80, //        ##  
	0x07, 0x00, //      ###   
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1024 '@' (11 pixels wide)
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x11, 0x00, //    #   #   
	0x21, 0x00, //   #    #   
	0x21, 0x00, //   #    #   
	0x27, 0x00, //   #  ###   
	0x29, 0x00, //   # #  #   
	0x29, 0x00, //   # #  #   
	0x27, 0x00, //   #  ###   
	0x20, 0x00, //   #        
	0x11, 0x00, //    #   #   
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1056 'A' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x00, //   ######   
	0x0F, 0x00, //     ####   
	0x09, 0x00, //     #  #   
	0x19, 0x80, //    ##  ##  
	0x19, 0x80, //    ##  ##  
	0x1F, 0x80, //    ######  
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x79, 0xE0, //  ####  ####
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1088 'B' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x00, //   ######   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x7F, 0x00, //  #######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1120 'C' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x40, //    ##### # 
	0x30, 0xC0, //   ##    ## 
	0x60, 0x40, //  ##      # 
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x40, //  ##      # 
	0x30, 0x80, //   ##    #  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1152 'D' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x31, 0x80, //   ##   ##  
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x31, 0x80, //   ##   ##  
	0x7F, 0x00, //  #######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1184 'E' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x80, //  ########  
	0x30, 0x80, //   ##    #  
	0x30, 0x80, //   ##    #  
	0x32, 0x00, //   ##  #    
	0x3E, 0x00, //   #####    
	0x32, 0x00, //   ##  #    
	0x30, 0x80, //   ##    #  
	0x30, 0x80, //   ##    #  
	0x7F, 0x80, //  ########  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1216 'F' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0xC0, //  ######### 
	0x30, 0x40, //   ##     # 
	0x30, 0x40, //   ##     # 
	0x32, 0x00, //   ##  #    
	0x3E, 0x00, //   #####    
	0x32, 0x00, //   ##  #    
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x7C, 0x00, //  #####     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1248 'G' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0x80, //    #### #  
	0x31, 0x80, //   ##   ##  
	0x60, 0x80, //  ##     #  
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x67, 0xC0, //  ##  ##### 
	0x61, 0x80, //  ##    ##  
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1280 'H' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x80, //   #######  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x7B, 0xC0, //  #### #### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1312 'I' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0xC0, //   ######## 
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1344 'J' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0xC0, //    ####### 
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x63, 0x00, //  ##   ##   
	0x63, 0x00, //  ##   ##   
	0x63, 0x00, //  ##   ##   
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1376 'K' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x31, 0x80, //   ##   ##  
	0x33, 0x00, //   ##  ##   
	0x36, 0x00, //   ## ##    
	0x3C, 0x00, //   ####     
	0x3E, 0x00, //   #####    
	0x33, 0x00, //   ##  ##   
	0x31, 0x80, //   ##   ##  
	0x79, 0xC0, //  ####  ### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1408 'L' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7E, 0x00, //  ######    
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x40, //    ##    # 
	0x18, 0x40, //    ##    # 
	0x18, 0x40, //    ##    # 
	0x7F, 0xC0, //  ######### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1440 'M' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xE0, 0xE0, // ###     ###
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x7B, 0xC0, //  #### #### 
	0x6A, 0xC0, //  ## # # ## 
	0x6E, 0xC0, //  ## ### ## 
	0x64, 0xC0, //  ##  #  ## 
	0x60, 0xC0, //  ##     ## 
	0xFB, 0xE0, // ##### #####
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1472 'N' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x73, 0xC0, //  ###  #### 
	0x31, 0x80, //   ##   ##  
	0x39, 0x80, //   ###  ##  
	0x3D, 0x80, //   #### ##  
	0x35, 0x80, //   ## # ##  
	0x37, 0x80, //   ## ####  
	0x33, 0x80, //   ##  ###  
	0x31, 0x80, //   ##   ##  
	0x79, 0x80, //  ####  ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1504 'O' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1536 'P' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x00, //   ######   
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x7E, 0x00, //  ######    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1568 'Q' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x0C, 0xC0, //     ##  ## 
	0x1F, 0x80, //    ######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1600 'R' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3E, 0x00, //   #####    
	0x33, 0x00, //   ##  ##   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x7C, 0xE0, //  #####  ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1632 'S' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x80, //    ######  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x38, 0x00, //   ###      
	0x1F, 0x00, //    #####   
	0x03, 0x80, //       ###  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1664 'T' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x80, //  ########  
	0x4C, 0x80, //  #  ##  #  
	0x4C, 0x80, //  #  ##  #  
	0x4C, 0x80, //  #  ##  #  
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1696 'U' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1728 'V' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x0A, 0x00, //     # #    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1760 'W' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xFB, 0xE0, // ##### #####
	0x60, 0xC0, //  ##     ## 
	0x64, 0xC0, //  ##  #  ## 
	0x6E, 0xC0, //  ## ### ## 
	0x6E, 0xC0, //  ## ### ## 
	0x2A, 0x80, //   # # # #  
	0x3B, 0x80, //   ### ###  
	0x3B, 0x80, //   ### ###  
	0x31, 0x80, //   ##   ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1792 'X' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x31, 0x80, //   ##   ##  
	0x1B, 0x00, //    ## ##   
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x1B, 0x00, //    ## ##   
	0x31, 0x80, //   ##   ##  
	0x7B, 0xC0, //  #### #### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1824 'Y' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x79, 0xE0, //  ####  ####
	0x30, 0xC0, //   ##    ## 
	0x19, 0x80, //    ##  ##  
	0x0F, 0x00, //     ####   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x1F, 0x80, //    ######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1856 'Z' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x80, //   #######  
	0x21, 0x80, //   #    ##  
	0x23, 0x00, //   #   ##   
	0x06, 0x00, //      ##    
	0x04, 0x00, //      #     
	0x0C, 0x00, //     ##     
	0x18, 0x80, //    ##   #  
	0x30, 0x80, //   ##    #  
	0x3F, 0x80, //   #######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1888 '[' (11 pixels wide)
	0x00, 0x00, //            
	0x07, 0x80, //      ####  
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x07, 0x80, //      ####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1920 '\' (11 pixels wide)
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1952 ']' (11 pixels wide)
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x1E, 0x00, //    ####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1984 '^' (11 pixels wide)
	0x04, 0x00, //      #     
	0x0A, 0x00, //     # #    
	0x0A, 0x00, //     # #    
	0x11, 0x00, //    #   #   
	0x20, 0x80, //   #     #  
	0x20, 0x80, //   #     #  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2016 '_' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xFF, 0xE0, // ###########

	// @2048 '`' (11 pixels wide)
	0x08, 0x00, //     #      
	0x04, 0x00, //      #     
	0x02, 0x00, //       #    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2080 'a' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x1F, 0x80, //    ######  
	0x31, 0x80, //   ##   ##  
	0x33, 0x80, //   ##  ###  
	0x1D, 0xC0, //    ### ### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2112 'b' (11 pixels wide)
	0x00, 0x00, //            
	0x70, 0x00, //  ###       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x37, 0x00, //   ## ###   
	0x39, 0x80, //   ###  ##  
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x39, 0x80, //   ###  ##  
	0x77, 0x00, //  ### ###   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2144 'c' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0x80, //    #### #  
	0x31, 0x80, //   ##   ##  
	0x60, 0x80, //  ##     #  
	0x60, 0x00, //  ##        
	0x60, 0x80, //  ##     #  
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2176 'd' (11 pixels wide)
	0x00, 0x00, //            
	0x03, 0x80, //       ###  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x1D, 0x80, //    ### ##  
	0x33, 0x80, //   ##  ###  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x33, 0x80, //   ##  ###  
	0x1D, 0xC0, //    ### ### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2208 'e' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x60, 0xC0, //  ##     ## 
	0x7F, 0xC0, //  ######### 
	0x60, 0x00, //  ##        
	0x30, 0xC0, //   ##    ## 
	0x1F, 0x80, //    ######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2240 'f' (11 pixels wide)
	0x00, 0x00, //            
	0x07, 0xE0, //      ######
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x3F, 0x80, //   #######  
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x3F, 0x80, //   #######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2272 'g' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1D, 0xC0, //    ### ### 
	0x33, 0x80, //   ##  ###  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x33, 0x80, //   ##  ###  
	0x1D, 0x80, //    ### ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2304 'h' (11 pixels wide)
	0x00, 0x00, //            
	0x70, 0x00, //  ###       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x37, 0x00, //   ## ###   
	0x39, 0x80, //   ###  ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x7B, 0xC0, //  #### #### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2336 'i' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2368 'j' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x3F, 0x00, //   ######   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2400 'k' (11 pixels wide)
	0x00, 0x00, //            
	0x70, 0x00, //  ###       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x37, 0x80, //   ## ####  
	0x36, 0x00, //   ## ##    
	0x3C, 0x00, //   ####     
	0x3C, 0x00, //   ####     
	0x36, 0x00, //   ## ##    
	0x33, 0x00, //   ##  ##   
	0x77, 0xC0, //  ### ##### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2432 'l' (11 pixels wide)
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2464 'm' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x80, //  ########  
	0x36, 0xC0, //   ## ## ## 
	0x36, 0xC0, //   ## ## ## 
	0x36, 0xC0, //   ## ## ## 
	0x36, 0xC0, //   ## ## ## 
	0x36, 0xC0, //   ## ## ## 
	0x76, 0xE0, //  ### ## ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2496 'n' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x77, 0x00, //  ### ###   
	0x39, 0x80, //   ###  ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x7B, 0xC0, //  #### #### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2528 'o' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x31, 0x80, //   ##   ##  
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2560 'p' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x77, 0x00, //  ### ###   
	0x39, 0x80, //   ###  ##  
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x30, 0xC0, //   ##    ## 
	0x39, 0x80, //   ###  ##  
	0x37, 0x00, //   ## ###   
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x7C, 0x00, //  #####     
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2592 'q' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1D, 0xC0, //    ### ### 
	0x33, 0x80, //   ##  ###  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x33, 0x80, //   ##  ###  
	0x1D, 0x80, //    ### ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x07, 0xC0, //      ##### 
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2624 'r' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0x80, //  #### ###  
	0x1C, 0xC0, //    ###  ## 
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x7F, 0x00, //  #######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2656 's' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x80, //    ######  
	0x31, 0x80, //   ##   ##  
	0x3C, 0x00, //   ####     
	0x1F, 0x00, //    #####   
	0x03, 0x80, //       ###  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2688 't' (11 pixels wide)
	0x00, 0x00, //            
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x7F, 0x00, //  #######   
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x80, //    ##   #  
	0x0F, 0x00, //     ####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2720 'u' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x73, 0x80, //  ###  ###  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x33, 0x80, //   ##  ###  
	0x1D, 0xC0, //    ### ### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2752 'v' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2784 'w' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xF1, 0xE0, // ####   ####
	0x60, 0xC0, //  ##     ## 
	0x64, 0xC0, //  ##  #  ## 
	0x6E, 0xC0, //  ## ### ## 
	0x3B, 0x80, //   ### ###  
	0x3B, 0x80, //   ### ###  
	0x31, 0x80, //   ##   ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2816 'x' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7B, 0xC0, //  #### #### 
	0x1B, 0x00, //    ## ##   
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x1B, 0x00, //    ## ##   
	0x7B, 0xC0, //  #### #### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2848 'y' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x79, 0xE0, //  ####  ####
	0x30, 0xC0, //   ##    ## 
	0x19, 0x80, //    ##  ##  
	0x19, 0x80, //    ##  ##  
	0x0B, 0x00, //     # ##   
	0x0F, 0x00, //     ####   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2880 'z' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x80, //   #######  
	0x21, 0x80, //   #    ##  
	0x03, 0x00, //       ##   
	0x0E, 0x00, //     ###    
	0x18, 0x00, //    ##      
	0x30, 0x80, //   ##    #  
	0x3F, 0x80, //   #######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2912 '{' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2944 '|' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2976 '}' (11 pixels wide)
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3008 '~' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x18, 0x00, //    ##      
	0x24, 0x80, //   #  #  #  
	0x03, 0x00, //       ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
};
const uint8_t _gFont20_Table[] = 
{
	// @0 ' ' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @40 '!' (14 pixels wide)
	0x00, 0x00, //               
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x02, 0x00, //       #       
	0x02, 0x00, //       #       
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @80 '"' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1C, 0xE0, //    ###  ###   
	0x1C, 0xE0, //    ###  ###   
	0x1C, 0xE0, //    ###  ###   
	0x08, 0x40, //     #    #    
	0x08, 0x40, //     #    #    
	0x08, 0x40, //     #    #    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @120 '#' (14 pixels wide)
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @160 '$' (14 pixels wide)
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x07, 0xE0, //      ######   
	0x0F, 0xE0, //     #######   
	0x18, 0x60, //    ##    ##   
	0x18, 0x00, //    ##         
	0x1F, 0x00, //    #####      
	0x0F, 0xC0, //     ######    
	0x00, 0xE0, //         ###   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x1F, 0xC0, //    #######    
	0x1F, 0x80, //    ######     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @200 '%' (14 pixels wide)
	0x00, 0x00, //               
	0x1C, 0x00, //    ###        
	0x22, 0x00, //   #   #       
	0x22, 0x00, //   #   #       
	0x22, 0x00, //   #   #       
	0x1C, 0x60, //    ###   ##   
	0x01, 0xE0, //        ####   
	0x0F, 0x80, //     #####     
	0x3C, 0x00, //   ####        
	0x31, 0xC0, //   ##   ###    
	0x02, 0x20, //       #   #   
	0x02, 0x20, //       #   #   
	0x02, 0x20, //       #   #   
	0x01, 0xC0, //        ###    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @240 '&' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0xE0, //       #####   
	0x0F, 0xE0, //     #######   
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x06, 0x00, //      ##       
	0x0F, 0x30, //     ####  ##  
	0x1F, 0xF0, //    #########  
	0x19, 0xE0, //    ##  ####   
	0x18, 0xC0, //    ##   ##    
	0x1F, 0xF0, //    #########  
	0x07, 0xB0, //      #### ##  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @280 ''' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x01, 0x00, //        #      
	0x01, 0x00, //        #      
	0x01, 0x00, //        #      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @320 '(' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @360 ')' (14 pixels wide)
	0x00, 0x00, //               
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @400 '*' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x1B, 0x60, //    ## ## ##   
	0x1F, 0xE0, //    ########   
	0x07, 0x80, //      ####     
	0x07, 0x80, //      ####     
	0x0F, 0xC0, //     ######    
	0x0C, 0xC0, //     ##  ##    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @440 '+' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @480 ',' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x04, 0x00, //      #        
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @520 '-' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0xE0, //   #########   
	0x3F, 0xE0, //   #########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @560 '.' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @600 '/' (14 pixels wide)
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @640 '0' (14 pixels wide)
	0x00, 0x00, //               
	0x0F, 0x80, //     #####     
	0x1F, 0xC0, //    #######    
	0x18, 0xC0, //    ##   ##    
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x18, 0xC0, //    ##   ##    
	0x1F, 0xC0, //    #######    
	0x0F, 0x80, //     #####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @680 '1' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x1F, 0x00, //    #####      
	0x1F, 0x00, //    #####      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @720 '2' (14 pixels wide)
	0x00, 0x00, //               
	0x0F, 0x80, //     #####     
	0x1F, 0xC0, //    #######    
	0x38, 0xE0, //   ###   ###   
	0x30, 0x60, //   ##     ##   
	0x00, 0x60, //          ##   
	0x00, 0xC0, //         ##    
	0x01, 0x80, //        ##     
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x0C, 0x00, //     ##        
	0x18, 0x00, //    ##         
	0x3F, 0xE0, //   #########   
	0x3F, 0xE0, //   #########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @760 '3' (14 pixels wide)
	0x00, 0x00, //               
	0x0F, 0x80, //     #####     
	0x3F, 0xC0, //   ########    
	0x30, 0xE0, //   ##    ###   
	0x00, 0x60, //          ##   
	0x00, 0xE0, //         ###   
	0x07, 0xC0, //      #####    
	0x07, 0xC0, //      #####    
	0x00, 0xE0, //         ###   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x60, 0xE0, //  ##     ###   
	0x7F, 0xC0, //  #########    
	0x3F, 0x80, //   #######     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @800 '4' (14 pixels wide)
	0x00, 0x00, //               
	0x01, 0xC0, //        ###    
	0x03, 0xC0, //       ####    
	0x03, 0xC0, //       ####    
	0x06, 0xC0, //      ## ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xC0, //     ##  ##    
	0x18, 0xC0, //    ##   ##    
	0x30, 0xC0, //   ##    ##    
	0x3F, 0xE0, //   #########   
	0x3F, 0xE0, //   #########   
	0x00, 0xC0, //         ##    
	0x03, 0xE0, //       #####   
	0x03, 0xE0, //       #####   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @840 '5' (14 pixels wide)
	0x00, 0x00, //               
	0x1F, 0xC0, //    #######    
	0x1F, 0xC0, //    #######    
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x1F, 0x80, //    ######     
	0x1F, 0xC0, //    #######    
	0x18, 0xE0, //    ##   ###   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x30, 0xE0, //   ##    ###   
	0x3F, 0xC0, //   ########    
	0x1F, 0x80, //    ######     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @880 '6' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0xE0, //       #####   
	0x0F, 0xE0, //     #######   
	0x1E, 0x00, //    ####       
	0x18, 0x00, //    ##         
	0x38, 0x00, //   ###         
	0x37, 0x80, //   ## ####     
	0x3F, 0xC0, //   ########    
	0x38, 0xE0, //   ###   ###   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x18, 0xE0, //    ##   ###   
	0x1F, 0xC0, //    #######    
	0x07, 0x80, //      ####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @920 '7' (14 pixels wide)
	0x00, 0x00, //               
	0x3F, 0xE0, //   #########   
	0x3F, 0xE0, //   #########   
	0x30, 0x60, //   ##     ##   
	0x00, 0x60, //          ##   
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @960 '8' (14 pixels wide)
	0x00, 0x00, //               
	0x0F, 0x80, //     #####     
	0x1F, 0xC0, //    #######    
	0x38, 0xE0, //   ###   ###   
	0x30, 0x60, //   ##     ##   
	0x38, 0xE0, //   ###   ###   
	0x1F, 0xC0, //    #######    
	0x1F, 0xC0, //    #######    
	0x38, 0xE0, //   ###   ###   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x38, 0xE0, //   ###   ###   
	0x1F, 0xC0, //    #######    
	0x0F, 0x80, //     #####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1000 '9' (14 pixels wide)
	0x00, 0x00, //               
	0x0F, 0x00, //     ####      
	0x1F, 0xC0, //    #######    
	0x38, 0xC0, //   ###   ##    
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x38, 0xE0, //   ###   ###   
	0x1F, 0xE0, //    ########   
	0x0F, 0x60, //     #### ##   
	0x00, 0xE0, //         ###   
	0x00, 0xC0, //         ##    
	0x03, 0xC0, //       ####    
	0x3F, 0x80, //   #######     
	0x3E, 0x00, //   #####       
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1040 ':' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x03, 0x80, //       ###     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1080 ';' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x01, 0xC0, //        ###    
	0x01, 0xC0, //        ###    
	0x01, 0xC0, //        ###    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x04, 0x00, //      #        
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1120 '<' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x30, //           ##  
	0x00, 0xF0, //         ####  
	0x03, 0xC0, //       ####    
	0x07, 0x00, //      ###      
	0x1C, 0x00, //    ###        
	0x78, 0x00, //  ####         
	0x1C, 0x00, //    ###        
	0x07, 0x00, //      ###      
	0x03, 0xC0, //       ####    
	0x00, 0xF0, //         ####  
	0x00, 0x30, //           ##  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1160 '=' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x7F, 0xF0, //  ###########  
	0x7F, 0xF0, //  ###########  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x7F, 0xF0, //  ###########  
	0x7F, 0xF0, //  ###########  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1200 '>' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x30, 0x00, //   ##          
	0x3C, 0x00, //   ####        
	0x0F, 0x00, //     ####      
	0x03, 0x80, //       ###     
	0x00, 0xE0, //         ###   
	0x00, 0x78, //          #### 
	0x00, 0xE0, //         ###   
	0x03, 0x80, //       ###     
	0x0F, 0x00, //     ####      
	0x3C, 0x00, //   ####        
	0x30, 0x00, //   ##          
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1240 '?' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x0F, 0x80, //     #####     
	0x1F, 0xC0, //    #######    
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x00, 0x60, //          ##   
	0x01, 0xC0, //        ###    
	0x03, 0x80, //       ###     
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1280 '@' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0x80, //       ###     
	0x0C, 0x80, //     ##  #     
	0x08, 0x40, //     #    #    
	0x10, 0x40, //    #     #    
	0x10, 0x40, //    #     #    
	0x11, 0xC0, //    #   ###    
	0x12, 0x40, //    #  #  #    
	0x12, 0x40, //    #  #  #    
	0x12, 0x40, //    #  #  #    
	0x11, 0xC0, //    #   ###    
	0x10, 0x00, //    #          
	0x08, 0x00, //     #         
	0x08, 0x40, //     #    #    
	0x07, 0x80, //      ####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1320 'A' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1F, 0x80, //    ######     
	0x1F, 0x80, //    ######     
	0x03, 0x80, //       ###     
	0x06, 0xC0, //      ## ##    
	0x06, 0xC0, //      ## ##    
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0x60, //     ##   ##   
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x30, 0x30, //   ##      ##  
	0x78, 0x78, //  ####    #### 
	0x78, 0x78, //  ####    #### 
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1360 'B' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0x80, //   #######     
	0x3F, 0xC0, //   ########    
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0xE0, //    ##   ###   
	0x1F, 0xC0, //    #######    
	0x1F, 0xE0, //    ########   
	0x18, 0x70, //    ##    ###  
	0x18, 0x30, //    ##     ##  
	0x18, 0x30, //    ##     ##  
	0x3F, 0xF0, //   ##########  
	0x3F, 0xE0, //   #########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1400 'C' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0xB0, //      #### ##  
	0x0F, 0xF0, //     ########  
	0x1C, 0x70, //    ###   ###  
	0x38, 0x30, //   ###     ##  
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x38, 0x30, //   ###     ##  
	0x1C, 0x70, //    ###   ###  
	0x0F, 0xE0, //     #######   
	0x07, 0xC0, //      #####    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1440 'D' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x7F, 0x80, //  ########     
	0x7F, 0xC0, //  #########    
	0x30, 0xE0, //   ##    ###   
	0x30, 0x70, //   ##     ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x70, //   ##     ###  
	0x30, 0xE0, //   ##    ###   
	0x7F, 0xC0, //  #########    
	0x7F, 0x80, //  ########     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1480 'E' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x18, 0x30, //    ##     ##  
	0x18, 0x30, //    ##     ##  
	0x19, 0x80, //    ##  ##     
	0x1F, 0x80, //    ######     
	0x1F, 0x80, //    ######     
	0x19, 0x80, //    ##  ##     
	0x18, 0x30, //    ##     ##  
	0x18, 0x30, //    ##     ##  
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1520 'F' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x18, 0x30, //    ##     ##  
	0x18, 0x30, //    ##     ##  
	0x19, 0x80, //    ##  ##     
	0x1F, 0x80, //    ######     
	0x1F, 0x80, //    ######     
	0x19, 0x80, //    ##  ##     
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x3F, 0x00, //   ######      
	0x3F, 0x00, //   ######      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1560 'G' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0xB0, //      #### ##  
	0x1F, 0xF0, //    #########  
	0x18, 0x70, //    ##    ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x31, 0xF8, //   ##   ###### 
	0x31, 0xF8, //   ##   ###### 
	0x30, 0x30, //   ##      ##  
	0x18, 0x30, //    ##     ##  
	0x1F, 0xF0, //    #########  
	0x07, 0xC0, //      #####    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1600 'H' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1640 'I' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1680 'J' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0xF8, //       ####### 
	0x03, 0xF8, //       ####### 
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x30, 0xE0, //   ##    ###   
	0x3F, 0xC0, //   ########    
	0x0F, 0x80, //     #####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1720 'K' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3E, 0xF8, //   ##### ##### 
	0x3E, 0xF8, //   ##### ##### 
	0x18, 0xE0, //    ##   ###   
	0x19, 0x80, //    ##  ##     
	0x1B, 0x00, //    ## ##      
	0x1F, 0x00, //    #####      
	0x1D, 0x80, //    ### ##     
	0x18, 0xC0, //    ##   ##    
	0x18, 0xC0, //    ##   ##    
	0x18, 0x60, //    ##    ##   
	0x3E, 0x78, //   #####  #### 
	0x3E, 0x38, //   #####   ### 
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1760 'L' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0x00, //   ######      
	0x3F, 0x00, //   ######      
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x30, //     ##    ##  
	0x0C, 0x30, //     ##    ##  
	0x0C, 0x30, //     ##    ##  
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1800 'M' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x78, 0x78, //  ####    #### 
	0x78, 0x78, //  ####    #### 
	0x38, 0x70, //   ###    ###  
	0x3C, 0xF0, //   ####  ####  
	0x34, 0xB0, //   ## #  # ##  
	0x37, 0xB0, //   ## #### ##  
	0x37, 0xB0, //   ## #### ##  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x30, 0x30, //   ##      ##  
	0x7C, 0xF8, //  #####  ##### 
	0x7C, 0xF8, //  #####  ##### 
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1840 'N' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x39, 0xF0, //   ###  #####  
	0x3D, 0xF0, //   #### #####  
	0x1C, 0x60, //    ###   ##   
	0x1E, 0x60, //    ####  ##   
	0x1E, 0x60, //    ####  ##   
	0x1B, 0x60, //    ## ## ##   
	0x1B, 0x60, //    ## ## ##   
	0x19, 0xE0, //    ##  ####   
	0x19, 0xE0, //    ##  ####   
	0x18, 0xE0, //    ##   ###   
	0x3E, 0xE0, //   ##### ###   
	0x3E, 0x60, //   #####  ##   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1880 'O' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0x80, //      ####     
	0x0F, 0xC0, //     ######    
	0x1C, 0xE0, //    ###  ###   
	0x38, 0x70, //   ###    ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x38, 0x70, //   ###    ###  
	0x1C, 0xE0, //    ###  ###   
	0x0F, 0xC0, //     ######    
	0x07, 0x80, //      ####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1920 'P' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0xC0, //   ########    
	0x3F, 0xE0, //   #########   
	0x18, 0x70, //    ##    ###  
	0x18, 0x30, //    ##     ##  
	0x18, 0x30, //    ##     ##  
	0x18, 0x70, //    ##    ###  
	0x1F, 0xE0, //    ########   
	0x1F, 0xC0, //    #######    
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x3F, 0x00, //   ######      
	0x3F, 0x00, //   ######      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1960 'Q' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0x80, //      ####     
	0x0F, 0xC0, //     ######    
	0x1C, 0xE0, //    ###  ###   
	0x38, 0x70, //   ###    ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x38, 0x70, //   ###    ###  
	0x1C, 0xE0, //    ###  ###   
	0x0F, 0xC0, //     ######    
	0x07, 0x80, //      ####     
	0x07, 0xB0, //      #### ##  
	0x0F, 0xF0, //     ########  
	0x0C, 0xE0, //     ##  ###   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2000 'R' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0xC0, //   ########    
	0x3F, 0xE0, //   #########   
	0x18, 0x70, //    ##    ###  
	0x18, 0x30, //    ##     ##  
	0x18, 0x70, //    ##    ###  
	0x1F, 0xE0, //    ########   
	0x1F, 0xC0, //    #######    
	0x18, 0xE0, //    ##   ###   
	0x18, 0x60, //    ##    ##   
	0x18, 0x70, //    ##    ###  
	0x3E, 0x38, //   #####   ### 
	0x3E, 0x18, //   #####    ## 
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2040 'S' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x0F, 0xB0, //     ##### ##  
	0x1F, 0xF0, //    #########  
	0x38, 0x70, //   ###    ###  
	0x30, 0x30, //   ##      ##  
	0x38, 0x00, //   ###         
	0x1F, 0x80, //    ######     
	0x07, 0xE0, //      ######   
	0x00, 0x70, //          ###  
	0x30, 0x30, //   ##      ##  
	0x38, 0x70, //   ###    ###  
	0x3F, 0xE0, //   #########   
	0x37, 0xC0, //   ## #####    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2080 'T' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x0F, 0xC0, //     ######    
	0x0F, 0xC0, //     ######    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2120 'U' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x1C, 0xE0, //    ###  ###   
	0x0F, 0xC0, //     ######    
	0x07, 0x80, //      ####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2160 'V' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x78, 0xF0, //  ####   ####  
	0x78, 0xF0, //  ####   ####  
	0x30, 0x60, //   ##     ##   
	0x30, 0x60, //   ##     ##   
	0x18, 0xC0, //    ##   ##    
	0x18, 0xC0, //    ##   ##    
	0x0D, 0x80, //     ## ##     
	0x0D, 0x80, //     ## ##     
	0x0D, 0x80, //     ## ##     
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2200 'W' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x7C, 0x7C, //  #####   #####
	0x7C, 0x7C, //  #####   #####
	0x30, 0x18, //   ##       ## 
	0x33, 0x98, //   ##  ###  ## 
	0x33, 0x98, //   ##  ###  ## 
	0x33, 0x98, //   ##  ###  ## 
	0x36, 0xD8, //   ## ## ## ## 
	0x16, 0xD0, //    # ## ## #  
	0x1C, 0x70, //    ###   ###  
	0x1C, 0x70, //    ###   ###  
	0x1C, 0x70, //    ###   ###  
	0x18, 0x30, //    ##     ##  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2240 'X' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x78, 0xF0, //  ####   ####  
	0x78, 0xF0, //  ####   ####  
	0x30, 0x60, //   ##     ##   
	0x18, 0xC0, //    ##   ##    
	0x0D, 0x80, //     ## ##     
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x0D, 0x80, //     ## ##     
	0x18, 0xC0, //    ##   ##    
	0x30, 0x60, //   ##     ##   
	0x78, 0xF0, //  ####   ####  
	0x78, 0xF0, //  ####   ####  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2280 'Y' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x18, 0x60, //    ##    ##   
	0x0C, 0xC0, //     ##  ##    
	0x07, 0x80, //      ####     
	0x07, 0x80, //      ####     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x0F, 0xC0, //     ######    
	0x0F, 0xC0, //     ######    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2320 'Z' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x18, 0x60, //    ##    ##   
	0x18, 0xC0, //    ##   ##    
	0x01, 0x80, //        ##     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x0C, 0x60, //     ##   ##   
	0x18, 0x60, //    ##    ##   
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2360 '[' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0xC0, //       ####    
	0x03, 0xC0, //       ####    
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0xC0, //       ####    
	0x03, 0xC0, //       ####    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2400 '\' (14 pixels wide)
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x01, 0x80, //        ##     
	0x01, 0x80, //        ##     
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2440 ']' (14 pixels wide)
	0x00, 0x00, //               
	0x0F, 0x00, //     ####      
	0x0F, 0x00, //     ####      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x0F, 0x00, //     ####      
	0x0F, 0x00, //     ####      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2480 '^' (14 pixels wide)
	0x00, 0x00, //               
	0x02, 0x00, //       #       
	0x07, 0x00, //      ###      
	0x0D, 0x80, //     ## ##     
	0x18, 0xC0, //    ##   ##    
	0x30, 0x60, //   ##     ##   
	0x20, 0x20, //   #       #   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2520 '_' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############

	// @2560 '`' (14 pixels wide)
	0x00, 0x00, //               
	0x04, 0x00, //      #        
	0x03, 0x00, //       ##      
	0x00, 0x80, //         #     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2600 'a' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x0F, 0xC0, //     ######    
	0x1F, 0xE0, //    ########   
	0x00, 0x60, //          ##   
	0x0F, 0xE0, //     #######   
	0x1F, 0xE0, //    ########   
	0x38, 0x60, //   ###    ##   
	0x30, 0xE0, //   ##    ###   
	0x3F, 0xF0, //   ##########  
	0x1F, 0x70, //    ##### ###  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2640 'b' (14 pixels wide)
	0x00, 0x00, //               
	0x70, 0x00, //  ###          
	0x70, 0x00, //  ###          
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x37, 0x80, //   ## ####     
	0x3F, 0xE0, //   #########   
	0x38, 0x60, //   ###    ##   
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x38, 0x60, //   ###    ##   
	0x7F, 0xE0, //  ##########   
	0x77, 0x80, //  ### ####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2680 'c' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0xB0, //      #### ##  
	0x1F, 0xF0, //    #########  
	0x18, 0x30, //    ##     ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x38, 0x30, //   ###     ##  
	0x1F, 0xF0, //    #########  
	0x0F, 0xC0, //     ######    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2720 'd' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x70, //          ###  
	0x00, 0x70, //          ###  
	0x00, 0x30, //           ##  
	0x00, 0x30, //           ##  
	0x07, 0xB0, //      #### ##  
	0x1F, 0xF0, //    #########  
	0x18, 0x70, //    ##    ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x38, 0x70, //   ###    ###  
	0x1F, 0xF8, //    ########## 
	0x07, 0xB8, //      #### ### 
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2760 'e' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0x80, //      ####     
	0x1F, 0xE0, //    ########   
	0x18, 0x60, //    ##    ##   
	0x3F, 0xF0, //   ##########  
	0x3F, 0xF0, //   ##########  
	0x30, 0x00, //   ##          
	0x18, 0x30, //    ##     ##  
	0x1F, 0xF0, //    #########  
	0x07, 0xC0, //      #####    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2800 'f' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0xF0, //       ######  
	0x07, 0xF0, //      #######  
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2840 'g' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0xB8, //      #### ### 
	0x1F, 0xF8, //    ########## 
	0x18, 0x70, //    ##    ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x18, 0x70, //    ##    ###  
	0x1F, 0xF0, //    #########  
	0x07, 0xB0, //      #### ##  
	0x00, 0x30, //           ##  
	0x00, 0x70, //          ###  
	0x0F, 0xE0, //     #######   
	0x0F, 0xC0, //     ######    
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2880 'h' (14 pixels wide)
	0x00, 0x00, //               
	0x38, 0x00, //   ###         
	0x38, 0x00, //   ###         
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x1B, 0xC0, //    ## ####    
	0x1F, 0xE0, //    ########   
	0x1C, 0x60, //    ###   ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2920 'i' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1F, 0x00, //    #####      
	0x1F, 0x00, //    #####      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2960 'j' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1F, 0xC0, //    #######    
	0x1F, 0xC0, //    #######    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x00, 0xC0, //         ##    
	0x01, 0xC0, //        ###    
	0x3F, 0x80, //   #######     
	0x3F, 0x00, //   ######      
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3000 'k' (14 pixels wide)
	0x00, 0x00, //               
	0x38, 0x00, //   ###         
	0x38, 0x00, //   ###         
	0x18, 0x00, //    ##         
	0x18, 0x00, //    ##         
	0x1B, 0xE0, //    ## #####   
	0x1B, 0xE0, //    ## #####   
	0x1B, 0x00, //    ## ##      
	0x1E, 0x00, //    ####       
	0x1E, 0x00, //    ####       
	0x1B, 0x00, //    ## ##      
	0x19, 0x80, //    ##  ##     
	0x39, 0xF0, //   ###  #####  
	0x39, 0xF0, //   ###  #####  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3040 'l' (14 pixels wide)
	0x00, 0x00, //               
	0x1F, 0x00, //    #####      
	0x1F, 0x00, //    #####      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3080 'm' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x7E, 0xE0, //  ###### ###   
	0x7F, 0xF0, //  ###########  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x33, 0x30, //   ##  ##  ##  
	0x7B, 0xB8, //  #### ### ### 
	0x7B, 0xB8, //  #### ### ### 
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3120 'n' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3B, 0xC0, //   ### ####    
	0x3F, 0xE0, //   #########   
	0x1C, 0x60, //    ###   ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3160 'o' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0x80, //      ####     
	0x1F, 0xE0, //    ########   
	0x18, 0x60, //    ##    ##   
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x18, 0x60, //    ##    ##   
	0x1F, 0xE0, //    ########   
	0x07, 0x80, //      ####     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3200 'p' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x77, 0x80, //  ### ####     
	0x7F, 0xE0, //  ##########   
	0x38, 0x60, //   ###    ##   
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x38, 0x60, //   ###    ##   
	0x3F, 0xE0, //   #########   
	0x37, 0x80, //   ## ####     
	0x30, 0x00, //   ##          
	0x30, 0x00, //   ##          
	0x7C, 0x00, //  #####        
	0x7C, 0x00, //  #####        
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3240 'q' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0xB8, //      #### ### 
	0x1F, 0xF8, //    ########## 
	0x18, 0x70, //    ##    ###  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x30, 0x30, //   ##      ##  
	0x18, 0x70, //    ##    ###  
	0x1F, 0xF0, //    #########  
	0x07, 0xB0, //      #### ##  
	0x00, 0x30, //           ##  
	0x00, 0x30, //           ##  
	0x00, 0xF8, //         ##### 
	0x00, 0xF8, //         ##### 
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3280 'r' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3C, 0xE0, //   ####  ###   
	0x3D, 0xF0, //   #### #####  
	0x0F, 0x30, //     ####  ##  
	0x0E, 0x00, //     ###       
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x3F, 0xC0, //   ########    
	0x3F, 0xC0, //   ########    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3320 's' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x07, 0xE0, //      ######   
	0x1F, 0xE0, //    ########   
	0x18, 0x60, //    ##    ##   
	0x1E, 0x00, //    ####       
	0x0F, 0xC0, //     ######    
	0x01, 0xE0, //        ####   
	0x18, 0x60, //    ##    ##   
	0x1F, 0xE0, //    ########   
	0x1F, 0x80, //    ######     
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3360 't' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x3F, 0xE0, //   #########   
	0x3F, 0xE0, //   #########   
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x00, //     ##        
	0x0C, 0x30, //     ##    ##  
	0x0F, 0xF0, //     ########  
	0x07, 0xC0, //      #####    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3400 'u' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x38, 0xE0, //   ###   ###   
	0x38, 0xE0, //   ###   ###   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0x60, //    ##    ##   
	0x18, 0xE0, //    ##   ###   
	0x1F, 0xF0, //    #########  
	0x0F, 0x70, //     #### ###  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3440 'v' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x78, 0xF0, //  ####   ####  
	0x78, 0xF0, //  ####   ####  
	0x30, 0x60, //   ##     ##   
	0x18, 0xC0, //    ##   ##    
	0x18, 0xC0, //    ##   ##    
	0x0D, 0x80, //     ## ##     
	0x0D, 0x80, //     ## ##     
	0x07, 0x00, //      ###      
	0x07, 0x00, //      ###      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3480 'w' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x78, 0xF0, //  ####   ####  
	0x78, 0xF0, //  ####   ####  
	0x32, 0x60, //   ##  #  ##   
	0x32, 0x60, //   ##  #  ##   
	0x37, 0xE0, //   ## ######   
	0x1D, 0xC0, //    ### ###    
	0x1D, 0xC0, //    ### ###    
	0x18, 0xC0, //    ##   ##    
	0x18, 0xC0, //    ##   ##    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3520 'x' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x0C, 0xC0, //     ##  ##    
	0x07, 0x80, //      ####     
	0x03, 0x00, //       ##      
	0x07, 0x80, //      ####     
	0x0C, 0xC0, //     ##  ##    
	0x3C, 0xF0, //   ####  ####  
	0x3C, 0xF0, //   ####  ####  
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3560 'y' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x78, 0xF0, //  ####   ####  
	0x78, 0xF0, //  ####   ####  
	0x30, 0x60, //   ##     ##   
	0x18, 0xC0, //    ##   ##    
	0x18, 0xC0, //    ##   ##    
	0x0D, 0x80, //     ## ##     
	0x0F, 0x80, //     #####     
	0x07, 0x00, //      ###      
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x0C, 0x00, //     ##        
	0x7F, 0x00, //  #######      
	0x7F, 0x00, //  #######      
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3600 'z' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x18, 0xC0, //    ##   ##    
	0x01, 0x80, //        ##     
	0x03, 0x00, //       ##      
	0x06, 0x00, //      ##       
	0x0C, 0x60, //     ##   ##   
	0x1F, 0xE0, //    ########   
	0x1F, 0xE0, //    ########   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3640 '{' (14 pixels wide)
	0x00, 0x00, //               
	0x01, 0xC0, //        ###    
	0x03, 0xC0, //       ####    
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x07, 0x00, //      ###      
	0x0E, 0x00, //     ###       
	0x07, 0x00, //      ###      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0xC0, //       ####    
	0x01, 0xC0, //        ###    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3680 '|' (14 pixels wide)
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3720 '}' (14 pixels wide)
	0x00, 0x00, //               
	0x1C, 0x00, //    ###        
	0x1E, 0x00, //    ####       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x07, 0x00, //      ###      
	0x03, 0x80, //       ###     
	0x07, 0x00, //      ###      
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x06, 0x00, //      ##       
	0x1E, 0x00, //    ####       
	0x1C, 0x00, //    ###        
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @3760 '~' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x0E, 0x00, //     ###       
	0x3F, 0x30, //   ######  ##  
	0x33, 0xF0, //   ##  ######  
	0x01, 0xE0, //        ####   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
};
const uint8_t _gFont24_Table[] = 
{
	// @0 ' ' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @72 '!' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @144 '"' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0E, 0x70, 0x00, //     ###  ###     
	0x0E, 0x70, 0x00, //     ###  ###     
	0x0E, 0x70, 0x00, //     ###  ###     
	0x04, 0x20, 0x00, //      #    #      
	0x04, 0x20, 0x00, //      #    #      
	0x04, 0x20, 0x00, //      #    #      
	0x04, 0x20, 0x00, //      #    #      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @216 '#' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @288 '$' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x07, 0xB0, 0x00, //      #### ##     
	0x0F, 0xF0, 0x00, //     ########     
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x70, 0x00, //    ##    ###     
	0x1C, 0x00, 0x00, //    ###           
	0x0F, 0x80, 0x00, //     #####        
	0x07, 0xE0, 0x00, //      ######      
	0x00, 0xF0, 0x00, //         ####     
	0x18, 0x30, 0x00, //    ##     ##     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x1C, 0x70, 0x00, //    ###   ###     
	0x1F, 0xE0, 0x00, //    ########      
	0x1B, 0xC0, 0x00, //    ## ####       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @360 '%' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0x80, 0x00, //      ####        
	0x0F, 0xC0, 0x00, //     ######       
	0x1C, 0xE0, 0x00, //    ###  ###      
	0x18, 0x60, 0x00, //    ##    ##      
	0x18, 0x60, 0x00, //    ##    ##      
	0x1C, 0xE0, 0x00, //    ###  ###      
	0x0F, 0xF8, 0x00, //     #########    
	0x07, 0xE0, 0x00, //      ######      
	0x1F, 0xF0, 0x00, //    #########     
	0x07, 0x38, 0x00, //      ###  ###    
	0x06, 0x18, 0x00, //      ##    ##    
	0x06, 0x18, 0x00, //      ##    ##    
	0x07, 0x38, 0x00, //      ###  ###    
	0x03, 0xF0, 0x00, //       ######     
	0x01, 0xE0, 0x00, //        ####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @432 '&' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xF0, 0x00, //       ######     
	0x07, 0xF0, 0x00, //      #######     
	0x0C, 0x60, 0x00, //     ##   ##      
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x06, 0x00, 0x00, //      ##          
	0x07, 0x00, 0x00, //      ###         
	0x0F, 0x9C, 0x00, //     #####  ###   
	0x1D, 0xFC, 0x00, //    ### #######   
	0x18, 0xF0, 0x00, //    ##   ####     
	0x18, 0x70, 0x00, //    ##    ###     
	0x0F, 0xFC, 0x00, //     ##########   
	0x07, 0xDC, 0x00, //      ##### ###   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @504 ''' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @576 '(' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x70, 0x00, //          ###     
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @648 ')' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x18, 0x00, 0x00, //    ##            
	0x1C, 0x00, 0x00, //    ###           
	0x0E, 0x00, 0x00, //     ###          
	0x0E, 0x00, 0x00, //     ###          
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x00, 0x00, //      ###         
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x00, 0x00, //      ###         
	0x0F, 0x00, 0x00, //     ####         
	0x0E, 0x00, 0x00, //     ###          
	0x1C, 0x00, 0x00, //    ###           
	0x18, 0x00, 0x00, //    ##            
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @720 '*' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x1D, 0xB8, 0x00, //    ### ## ###    
	0x1F, 0xF8, 0x00, //    ##########    
	0x07, 0xE0, 0x00, //      ######      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @792 '+' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @864 ',' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x00, 0x00, //       ##         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @936 '-' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1008 '.' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1080 '/' (17 pixels wide)
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x00, 0x00, //       ##         
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x0E, 0x00, 0x00, //     ###          
	0x0C, 0x00, 0x00, //     ##           
	0x1C, 0x00, 0x00, //    ###           
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1152 '0' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x07, 0xE0, 0x00, //      ######      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x07, 0xE0, 0x00, //      ######      
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1224 '1' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x80, 0x00, //         #        
	0x07, 0x80, 0x00, //      ####        
	0x1F, 0x80, 0x00, //    ######        
	0x1D, 0x80, 0x00, //    ### ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1296 '2' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xC0, 0x00, //      #####       
	0x1F, 0xF0, 0x00, //    #########     
	0x38, 0x30, 0x00, //   ###     ##     
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x60, 0x00, //          ##      
	0x01, 0xC0, 0x00, //        ###       
	0x03, 0x80, 0x00, //       ###        
	0x06, 0x00, 0x00, //      ##          
	0x0C, 0x00, 0x00, //     ##           
	0x18, 0x00, 0x00, //    ##            
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1368 '3' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xE0, 0x00, //     #######      
	0x0C, 0x70, 0x00, //     ##   ###     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x60, 0x00, //          ##      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xE0, 0x00, //       #####      
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x0F, 0xC0, 0x00, //     ######       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1440 '4' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xE0, 0x00, //        ####      
	0x01, 0xE0, 0x00, //        ####      
	0x03, 0x60, 0x00, //       ## ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x18, 0x60, 0x00, //    ##    ##      
	0x30, 0x60, 0x00, //   ##     ##      
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x00, 0x60, 0x00, //          ##      
	0x03, 0xF8, 0x00, //       #######    
	0x03, 0xF8, 0x00, //       #######    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1512 '5' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xF0, 0x00, //    #########     
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xC0, 0x00, //    ## ####       
	0x1F, 0xF0, 0x00, //    #########     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x30, 0x30, 0x00, //   ##      ##     
	0x3F, 0xF0, 0x00, //   ##########     
	0x0F, 0xC0, 0x00, //     ######       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1584 '6' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xF8, 0x00, //         #####    
	0x03, 0xF8, 0x00, //       #######    
	0x07, 0x00, 0x00, //      ###         
	0x0E, 0x00, 0x00, //     ###          
	0x0C, 0x00, 0x00, //     ##           
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xC0, 0x00, //    ## ####       
	0x1F, 0xF0, 0x00, //    #########     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x38, 0x00, //     ##    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xE0, 0x00, //       #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1656 '7' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1728 '8' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xE0, 0x00, //      ######      
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x07, 0xE0, 0x00, //      ######      
	0x07, 0xE0, 0x00, //      ######      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x07, 0xE0, 0x00, //      ######      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1800 '9' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xC0, 0x00, //      #####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x38, 0x00, //     ##    ###    
	0x0F, 0xF8, 0x00, //     #########    
	0x03, 0xD8, 0x00, //       #### ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0xE0, 0x00, //         ###      
	0x1F, 0xC0, 0x00, //    #######       
	0x1F, 0x00, 0x00, //    #####         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1872 ':' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1944 ';' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x02, 0x00, 0x00, //       #          
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2016 '<' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x1C, 0x00, //            ###   
	0x00, 0x3C, 0x00, //           ####   
	0x00, 0xF0, 0x00, //         ####     
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0x00, 0x00, //     ####         
	0x3C, 0x00, 0x00, //   ####           
	0xF0, 0x00, 0x00, // ####             
	0x3C, 0x00, 0x00, //   ####           
	0x0F, 0x00, 0x00, //     ####         
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0x3C, 0x00, //           ####   
	0x00, 0x1C, 0x00, //            ###   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2088 '=' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xFC, 0x00, //  #############   
	0x7F, 0xFC, 0x00, //  #############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xFC, 0x00, //  #############   
	0x7F, 0xFC, 0x00, //  #############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2160 '>' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x70, 0x00, 0x00, //  ###             
	0x78, 0x00, 0x00, //  ####            
	0x1E, 0x00, 0x00, //    ####          
	0x07, 0x80, 0x00, //      ####        
	0x01, 0xE0, 0x00, //        ####      
	0x00, 0x78, 0x00, //          ####    
	0x00, 0x1E, 0x00, //            ####  
	0x00, 0x78, 0x00, //          ####    
	0x01, 0xE0, 0x00, //        ####      
	0x07, 0x80, 0x00, //      ####        
	0x1E, 0x00, 0x00, //    ####          
	0x78, 0x00, 0x00, //  ####            
	0x70, 0x00, 0x00, //  ###             
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2232 '?' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xC0, 0x00, //      #####       
	0x0F, 0xE0, 0x00, //     #######      
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x30, 0x00, //    ##     ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0xE0, 0x00, //         ###      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x00, 0x00, //       ##         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x00, 0x00, //      ###         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2304 '@' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xE0, 0x00, //       #####      
	0x07, 0xF0, 0x00, //      #######     
	0x0E, 0x38, 0x00, //     ###   ###    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x18, 0x78, 0x00, //    ##    ####    
	0x18, 0xF8, 0x00, //    ##   #####    
	0x19, 0xD8, 0x00, //    ##  ### ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x18, 0xF8, 0x00, //    ##   #####    
	0x18, 0x78, 0x00, //    ##    ####    
	0x18, 0x00, 0x00, //    ##            
	0x0C, 0x00, 0x00, //     ##           
	0x0E, 0x18, 0x00, //     ###    ##    
	0x07, 0xF8, 0x00, //      ########    
	0x03, 0xE0, 0x00, //       #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2376 'A' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0xC0, 0x00, //    #######       
	0x01, 0xC0, 0x00, //        ###       
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0x60, 0x00, //       ## ##      
	0x06, 0x30, 0x00, //      ##   ##     
	0x06, 0x30, 0x00, //      ##   ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0F, 0xF8, 0x00, //     #########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0xFC, 0x7F, 0x00, // ######   ####### 
	0xFC, 0x7F, 0x00, // ######   ####### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2448 'B' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xE0, 0x00, //  ##########      
	0x7F, 0xF0, 0x00, //  ###########     
	0x18, 0x38, 0x00, //    ##     ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x1C, 0x00, //    ##      ###   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x7F, 0xF8, 0x00, //  ############    
	0x7F, 0xF0, 0x00, //  ###########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2520 'C' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xEC, 0x00, //       ##### ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x0F, 0xF8, 0x00, //     #########    
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2592 'D' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xC0, 0x00, //  #########       
	0x7F, 0xF0, 0x00, //  ###########     
	0x18, 0x38, 0x00, //    ##     ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0xF0, 0x00, //  ###########     
	0x7F, 0xE0, 0x00, //  ##########      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2664 'E' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xF8, 0x00, //  ############    
	0x7F, 0xF8, 0x00, //  ############    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x19, 0x80, 0x00, //    ##  ##        
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0x80, 0x00, //    ######        
	0x19, 0x80, 0x00, //    ##  ##        
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7F, 0xF8, 0x00, //  ############    
	0x7F, 0xF8, 0x00, //  ############    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2736 'F' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0xCC, 0x00, //     ##  ##  ##   
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0F, 0xC0, 0x00, //     ######       
	0x0F, 0xC0, 0x00, //     ######       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x3F, 0xC0, 0x00, //   ########       
	0x3F, 0xC0, 0x00, //   ########       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2808 'G' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xEC, 0x00, //       ##### ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0xFE, 0x00, //   ##    #######  
	0x30, 0xFE, 0x00, //   ##    #######  
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x0C, 0x00, //   ###       ##   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x0F, 0xFC, 0x00, //     ##########   
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2880 'H' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2952 'I' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3024 'J' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xFE, 0x00, //      ##########  
	0x07, 0xFE, 0x00, //      ##########  
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x60, 0x00, //   ##     ##      
	0x3F, 0xE0, 0x00, //   #########      
	0x0F, 0x80, 0x00, //     #####        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3096 'K' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0x3E, 0x00, //  #######  #####  
	0x7F, 0x3E, 0x00, //  #######  #####  
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x60, 0x00, //    ##    ##      
	0x18, 0xC0, 0x00, //    ##   ##       
	0x19, 0x80, 0x00, //    ##  ##        
	0x1B, 0x80, 0x00, //    ## ###        
	0x1F, 0xC0, 0x00, //    #######       
	0x1C, 0xE0, 0x00, //    ###  ###      
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0x1F, 0x00, //  #######   ##### 
	0x7F, 0x1F, 0x00, //  #######   ##### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3168 'L' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0x80, 0x00, //  ########        
	0x7F, 0x80, 0x00, //  ########        
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x7F, 0xFC, 0x00, //  #############   
	0x7F, 0xFC, 0x00, //  #############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3240 'M' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xF0, 0x0F, 0x00, // ####        #### 
	0xF8, 0x1F, 0x00, // #####      ##### 
	0x38, 0x1C, 0x00, //   ###      ###   
	0x3C, 0x3C, 0x00, //   ####    ####   
	0x3C, 0x3C, 0x00, //   ####    ####   
	0x36, 0x6C, 0x00, //   ## ##  ## ##   
	0x36, 0x6C, 0x00, //   ## ##  ## ##   
	0x33, 0xCC, 0x00, //   ##  ####  ##   
	0x33, 0xCC, 0x00, //   ##  ####  ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0xFE, 0x7F, 0x00, // #######  ####### 
	0xFE, 0x7F, 0x00, // #######  ####### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3312 'N' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0xFE, 0x00, //  ####   #######  
	0x78, 0xFE, 0x00, //  ####   #######  
	0x1C, 0x18, 0x00, //    ###     ##    
	0x1E, 0x18, 0x00, //    ####    ##    
	0x1F, 0x18, 0x00, //    #####   ##    
	0x1B, 0x18, 0x00, //    ## ##   ##    
	0x1B, 0x98, 0x00, //    ## ###  ##    
	0x19, 0xD8, 0x00, //    ##  ### ##    
	0x18, 0xD8, 0x00, //    ##   ## ##    
	0x18, 0xF8, 0x00, //    ##   #####    
	0x18, 0x78, 0x00, //    ##    ####    
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0x18, 0x00, //  #######   ##    
	0x7F, 0x18, 0x00, //  #######   ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3384 'O' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x38, 0x1C, 0x00, //   ###      ###   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x1C, 0x00, //   ###      ###   
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3456 'P' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF8, 0x00, //   ###########    
	0x0C, 0x1C, 0x00, //     ##     ###   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0F, 0xF8, 0x00, //     #########    
	0x0F, 0xE0, 0x00, //     #######      
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x3F, 0xC0, 0x00, //   ########       
	0x3F, 0xC0, 0x00, //   ########       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3528 'Q' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x38, 0x1C, 0x00, //   ###      ###   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x1C, 0x00, //   ###      ###   
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x07, 0xC0, 0x00, //      #####       
	0x07, 0xCC, 0x00, //      #####  ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x0C, 0x38, 0x00, //     ##    ###    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3600 'R' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xE0, 0x00, //  ##########      
	0x7F, 0xF0, 0x00, //  ###########     
	0x18, 0x38, 0x00, //    ##     ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xC0, 0x00, //    #######       
	0x18, 0xE0, 0x00, //    ##   ###      
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0x1E, 0x00, //  #######   ####  
	0x7F, 0x0E, 0x00, //  #######    ###  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3672 'S' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xD8, 0x00, //      ##### ##    
	0x0F, 0xF8, 0x00, //     #########    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1E, 0x00, 0x00, //    ####          
	0x0F, 0xC0, 0x00, //     ######       
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x78, 0x00, //          ####    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1B, 0xE0, 0x00, //    ## #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3744 'T' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x0F, 0xF0, 0x00, //     ########     
	0x0F, 0xF0, 0x00, //     ########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3816 'U' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3888 'V' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0x7F, 0x00, //  ####### ####### 
	0x7F, 0x7F, 0x00, //  ####### ####### 
	0x18, 0x0C, 0x00, //    ##       ##   
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x06, 0x30, 0x00, //      ##   ##     
	0x06, 0x30, 0x00, //      ##   ##     
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0x60, 0x00, //       ## ##      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0x80, 0x00, //         #        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3960 'W' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xFE, 0x3F, 0x80, // #######   #######
	0xFE, 0x3F, 0x80, // #######   #######
	0x30, 0x06, 0x00, //   ##         ##  
	0x30, 0x06, 0x00, //   ##         ##  
	0x30, 0x86, 0x00, //   ##    #    ##  
	0x19, 0xCC, 0x00, //    ##  ###  ##   
	0x19, 0xCC, 0x00, //    ##  ###  ##   
	0x1B, 0x6C, 0x00, //    ## ## ## ##   
	0x1B, 0x6C, 0x00, //    ## ## ## ##   
	0x1E, 0x7C, 0x00, //    ####  #####   
	0x0E, 0x38, 0x00, //     ###   ###    
	0x0E, 0x38, 0x00, //     ###   ###    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4032 'X' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x03, 0xC0, 0x00, //       ####       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0xC0, 0x00, //       ####       
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4104 'Y' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7C, 0x7E, 0x00, //  #####   ######  
	0x7C, 0x7E, 0x00, //  #####   ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x03, 0xC0, 0x00, //       ####       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x0F, 0xF0, 0x00, //     ########     
	0x0F, 0xF0, 0x00, //     ########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4176 'Z' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x60, 0x00, //    ##    ##      
	0x18, 0xC0, 0x00, //    ##   ##       
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x06, 0x18, 0x00, //      ##    ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4248 '[' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0xF0, 0x00, //        #####     
	0x01, 0xF0, 0x00, //        #####     
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0xF0, 0x00, //        #####     
	0x01, 0xF0, 0x00, //        #####     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4320 '\' (17 pixels wide)
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1C, 0x00, 0x00, //    ###           
	0x0C, 0x00, 0x00, //     ##           
	0x0E, 0x00, 0x00, //     ###          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x00, 0x00, //       ##         
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4392 ']' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0F, 0x80, 0x00, //     #####        
	0x0F, 0x80, 0x00, //     #####        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x0F, 0x80, 0x00, //     #####        
	0x0F, 0x80, 0x00, //     #####        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4464 '^' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x80, 0x00, //         #        
	0x01, 0xC0, 0x00, //        ###       
	0x03, 0xE0, 0x00, //       #####      
	0x07, 0x70, 0x00, //      ### ###     
	0x06, 0x30, 0x00, //      ##   ##     
	0x0C, 0x18, 0x00, //     ##     ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x10, 0x04, 0x00, //    #         #   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4536 '_' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xFF, 0xFF, 0x00, // ################ 
	0xFF, 0xFF, 0x00, // ################ 

	// @4608 '`' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x80, 0x00, //       ###        
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4680 'a' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0F, 0xC0, 0x00, //     ######       
	0x1F, 0xE0, 0x00, //    ########      
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x07, 0xF0, 0x00, //      #######     
	0x1F, 0xF0, 0x00, //    #########     
	0x38, 0x30, 0x00, //   ###     ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x70, 0x00, //   ##     ###     
	0x1F, 0xFC, 0x00, //    ###########   
	0x0F, 0xBC, 0x00, //     ##### ####   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4752 'b' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x00, 0x00, //  ####            
	0x78, 0x00, 0x00, //  ####            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xE0, 0x00, //    ## #####      
	0x1F, 0xF8, 0x00, //    ##########    
	0x1C, 0x18, 0x00, //    ###     ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1C, 0x18, 0x00, //    ###     ##    
	0x7F, 0xF8, 0x00, //  ############    
	0x7B, 0xE0, 0x00, //  #### #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4824 'c' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xEC, 0x00, //       ##### ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x38, 0x0C, 0x00, //   ###       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x38, 0x0C, 0x00, //   ###       ##   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x0F, 0xF8, 0x00, //     #########    
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4896 'd' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x78, 0x00, //          ####    
	0x00, 0x78, 0x00, //          ####    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x07, 0xD8, 0x00, //      ##### ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x38, 0x00, //    ##     ###    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xFE, 0x00, //    ############  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4968 'e' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xE0, 0x00, //      ######      
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x30, 0x0C, 0x00, //   ##        ##   
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1F, 0xFC, 0x00, //    ###########   
	0x07, 0xF0, 0x00, //      #######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5040 'f' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0xFC, 0x00, //        #######   
	0x03, 0xFC, 0x00, //       ########   
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF0, 0x00, //   ##########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5112 'g' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x1F, 0xFE, 0x00, //    ############  
	0x18, 0x38, 0x00, //    ##     ###    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF8, 0x00, //    ##########    
	0x07, 0xD8, 0x00, //      ##### ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x38, 0x00, //           ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x0F, 0xC0, 0x00, //     ######       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5184 'h' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x00, 0x00, //  ####            
	0x78, 0x00, 0x00, //  ####            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xE0, 0x00, //    ## #####      
	0x1F, 0xF0, 0x00, //    #########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5256 'i' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0x80, 0x00, //    ######        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5328 'j' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xF0, 0x00, //    #########     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x1F, 0xE0, 0x00, //    ########      
	0x1F, 0x80, 0x00, //    ######        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5400 'k' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3C, 0x00, 0x00, //   ####           
	0x3C, 0x00, 0x00, //   ####           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0xF8, 0x00, //     ##  #####    
	0x0C, 0xF8, 0x00, //     ##  #####    
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0D, 0x80, 0x00, //     ## ##        
	0x0F, 0x80, 0x00, //     #####        
	0x0F, 0x00, 0x00, //     ####         
	0x0F, 0x80, 0x00, //     #####        
	0x0D, 0xC0, 0x00, //     ## ###       
	0x0C, 0xE0, 0x00, //     ##  ###      
	0x3C, 0x7C, 0x00, //   ####   #####   
	0x3C, 0x7C, 0x00, //   ####   #####   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5472 'l' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0x80, 0x00, //    ######        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5544 'm' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xF7, 0x78, 0x00, // #### ### ####    
	0xFF, 0xFC, 0x00, // ##############   
	0x39, 0xCC, 0x00, //   ###  ###  ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0xFD, 0xEF, 0x00, // ###### #### #### 
	0xFD, 0xEF, 0x00, // ###### #### #### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5616 'n' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7B, 0xE0, 0x00, //  #### #####      
	0x7F, 0xF0, 0x00, //  ###########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5688 'o' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x38, 0x1C, 0x00, //   ###      ###   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x1C, 0x00, //   ###      ###   
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5760 'p' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7B, 0xE0, 0x00, //  #### #####      
	0x7F, 0xF8, 0x00, //  ############    
	0x1C, 0x18, 0x00, //    ###     ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1C, 0x18, 0x00, //    ###     ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x1B, 0xE0, 0x00, //    ## #####      
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x7F, 0x00, 0x00, //  #######         
	0x7F, 0x00, 0x00, //  #######         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5832 'q' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x1F, 0xFE, 0x00, //    ############  
	0x18, 0x38, 0x00, //    ##     ###    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF8, 0x00, //    ##########    
	0x07, 0xD8, 0x00, //      ##### ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0xFE, 0x00, //         #######  
	0x00, 0xFE, 0x00, //         #######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5904 'r' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3E, 0x78, 0x00, //   #####  ####    
	0x3E, 0xFC, 0x00, //   ##### ######   
	0x07, 0xCC, 0x00, //      #####  ##   
	0x07, 0x00, 0x00, //      ###         
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF0, 0x00, //   ##########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5976 's' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xF8, 0x00, //      ########    
	0x0F, 0xF8, 0x00, //     #########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1F, 0x80, 0x00, //    ######        
	0x0F, 0xF0, 0x00, //     ########     
	0x00, 0xF8, 0x00, //         #####    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xE0, 0x00, //    ########      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6048 't' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF0, 0x00, //   ##########     
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x1C, 0x00, //     ##     ###   
	0x07, 0xFC, 0x00, //      #########   
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6120 'u' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x78, 0x00, //  ####    ####    
	0x78, 0x78, 0x00, //  ####    ####    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x0F, 0xFE, 0x00, //     ###########  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6192 'v' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7C, 0x3E, 0x00, //  #####    #####  
	0x7C, 0x3E, 0x00, //  #####    #####  
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x07, 0xE0, 0x00, //      ######      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6264 'w' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x3C, 0x00, //  ####     ####   
	0x78, 0x3C, 0x00, //  ####     ####   
	0x31, 0x18, 0x00, //   ##   #   ##    
	0x33, 0x98, 0x00, //   ##  ###  ##    
	0x33, 0x98, 0x00, //   ##  ###  ##    
	0x1A, 0xB0, 0x00, //    ## # # ##     
	0x1E, 0xF0, 0x00, //    #### ####     
	0x1E, 0xF0, 0x00, //    #### ####     
	0x1C, 0x60, 0x00, //    ###   ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6336 'x' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x03, 0xC0, 0x00, //       ####       
	0x01, 0x80, 0x00, //        ##        
	0x03, 0xC0, 0x00, //       ####       
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6408 'y' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x1F, 0x00, //  ######    ##### 
	0x7E, 0x1F, 0x00, //  ######    ##### 
	0x18, 0x0C, 0x00, //    ##       ##   
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x06, 0x30, 0x00, //      ##   ##     
	0x06, 0x30, 0x00, //      ##   ##     
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0xE0, 0x00, //       #####      
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x3F, 0xC0, 0x00, //   ########       
	0x3F, 0xC0, 0x00, //   ########       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6480 'z' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x60, 0x00, //    ##    ##      
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x06, 0x18, 0x00, //      ##    ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6552 '{' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xE0, 0x00, //        ####      
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x80, 0x00, //       ###        
	0x07, 0x00, 0x00, //      ###         
	0x03, 0x80, 0x00, //       ###        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0xE0, 0x00, //        ####      
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6624 '|' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6696 '}' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x80, 0x00, //      ####        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x07, 0x80, 0x00, //      ####        
	0x07, 0x00, 0x00, //      ###         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6768 '~' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0E, 0x00, 0x00, //     ###          
	0x1F, 0x18, 0x00, //    #####   ##    
	0x3B, 0xB8, 0x00, //   ### ### ###    
	0x31, 0xF0, 0x00, //   ##   #####     
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
};
uint8_t _gFont48_Table[ _C_DAT_WIDTHBYTE_48 * _C_DAT_HEIGHT_48 * _C_DAT_NUM_CHAR ] = { 0 };

/************************************************************************************************/
/*	《７》ファイル内で共有する関数プロトタイプ宣言												*/
/************************************************************************************************/
uint8_t _Fonts_GetPixel( uint16_t Px, uint16_t Py, uint16_t WidthByte, uint8_t* FontTable );
void _Fonts_SetPixel( uint16_t Px, uint16_t Py, uint16_t WidthByte, uint8_t* FontTable, uint8_t Pixel );

/************************************************************************************************/
/*	《８》ＯＳ資源定義																			*/
/************************************************************************************************/

/************************************************************************************************/
/*	《９》外部参照変数定義(ドメイン・グローバルな外部変数定義)									*/
/************************************************************************************************/
FONT gFont8 =
{
	_gFont8_Table,
	5,
	8
};
FONT gFont12 =
{
	_gFont12_Table,
	7,
	12,
};
FONT gFont16 =
{
	_gFont16_Table,
	11,
	16,
};
FONT gFont20 =
{
	_gFont20_Table,
	14,
	20,
};
FONT gFont24 =
{
	_gFont24_Table,
	_C_DAT_WIDTH_24,
	_C_DAT_HEIGHT_24,
};
// gFont24 を倍に拡大してﾒﾓﾘに展開する
// gFont24 横のﾊﾞｲﾄは 17ﾋﾟｸｾﾙなので 3ﾊﾞｲﾄ使用しているが、gFont48　は、34ﾋﾟｸｾﾙなので5ﾊﾞｲﾄ使用となる
FONT gFont48 =
{
	_gFont48_Table,
	_C_DAT_WIDTH_48,
	_C_DAT_HEIGHT_48,
};

/************************************************************************************************/
/*	機能概要：48ﾎﾟｲﾝﾄのﾌｫﾝﾄ生成																	*/
/*	引数	：なし																				*/
/*	戻り値	：なし																				*/
/*	備考	：																					*/
/************************************************************************************************/
void Fonts_Create48()
{
	uint8_t srcAddr;
	uint8_t dstAddr;
	for( int charCount = 0; charCount < _C_DAT_NUM_CHAR; charCount++ )
	{
		uint16_t srcIndex = _C_DAT_WIDTHBYTE_24 * _C_DAT_HEIGHT_24 * charCount;
		uint16_t dstIndex = _C_DAT_WIDTHBYTE_48 * _C_DAT_HEIGHT_48 * charCount;

		for( int y = 0; y < gFont48.Height; y++ )
		{
			for( int x = 0; x < gFont48.Width; x++ )
			{
				// 拡大ｽｹｰﾙ2
				// 拡大前の元ﾃﾞｰﾀﾋﾟｸｾﾙ値を取得し、拡大先のﾌｫﾝﾄﾃｰﾌﾞﾙにｾｯﾄする
				uint8_t data = _Fonts_GetPixel( x / _C_DAT_SCALE_24_48, y / _C_DAT_SCALE_24_48, _C_DAT_WIDTHBYTE_24, (uint8_t* )( &_gFont24_Table[ srcIndex ] ) );
				_Fonts_SetPixel(                x,                      y,                      _C_DAT_WIDTHBYTE_48, &( _gFont48_Table[ dstIndex ] ), data );
			}
		}
	}	}

uint8_t _Fonts_GetPixel( uint16_t Px, uint16_t Py, uint16_t WidthByte, uint8_t* FontTable )
{
	uint16_t addr = Px / 8 + Py * WidthByte;
	uint8_t  data = FontTable[ addr ];
	if( ( data & ( 0x80 >> ( Px % 8 )) ) != 0 )
	{
		return 1;
	}
	return 0;
}
void _Fonts_SetPixel( uint16_t Px, uint16_t Py, uint16_t WidthByte, uint8_t* FontTable, uint8_t Pixel )
{
	uint16_t addr = Px / 8 + Py * WidthByte;
	uint8_t  data = FontTable[ addr ];
	if( Pixel == 0 )
	{
		FontTable[ addr ] = data & ~( 0x80 >> ( Px % 8 ));
	}
	else
	{
		FontTable[ addr ] = data |  ( 0x80 >> ( Px % 8 ));
	}
}
