/************************************************************************************************/
/*																								*/
/* FILE NAME   : Display.h									VERSION : 							*/
/*																								*/
/* DESCRIPTION : ﾃﾞｨｽﾌﾟﾚｲ ﾍｯﾀﾞﾌｧｲﾙ																*/
/*																								*/
/* HISTORY     :																				*/
/*																								*/
/************************************************************************************************/
#ifndef DISPLAY_H
#define DISPLAY_H
 
/************************************************************************************************/
/*	《１》取込みファイル定義																	*/
/************************************************************************************************/
#include <Arduino.h>
#include "Fonts.h"

/************************************************************************************************/
/*	《２》定数定義																				*/
/************************************************************************************************/
#define C_DAT_ROTATE_0			0														// 回転
#define C_DAT_ROTATE_90			90
#define C_DAT_ROTATE_180		180
#define C_DAT_ROTATE_270		270

/************************************************************************************************/
/*	《３》マクロ定義																			*/
/************************************************************************************************/

/************************************************************************************************/
/*	《４》Typedef定義(型定義)																	*/
/************************************************************************************************/
typedef enum																			// ﾃﾞｨｽﾌﾟﾚｲﾀｲﾌﾟ
{
	enOled					= 0,														// OLED
	enEpaper																			// 電子ﾍﾟｰﾊﾟｰ
} DISPLAY_TYPE;
typedef enum																			// ﾐﾗｰﾀｲﾌﾟ
{
	enMirror_Non			= 0,														// 無効
	enMirror_Horizontal,																// 水平ﾐﾗｰ
	enMirror_Vertical,																	// 垂直ﾐﾗｰ
	enMirror_Origin																		// 原点ﾐﾗｰ
} MIRROR_TYPE;
typedef enum																			// ﾄﾞｯﾄｻｲｽﾞ
{
	enDot_1X1				= 1,														// 1 x 1
	enDot_2X2,																			// 2 X 2
	enDot_3X3,																			// 3 X 3
	enDot_4X4,																			// 4 X 4
	enDot_5X5,																			// 5 X 5
	enDot_6X6,																			// 6 X 6
	enDot_7X7,																			// 7 X 7
	enDot_8X8																			// 8 X 8
} DOT_SIZE;
typedef enum																			// ﾄﾞｯﾄｽﾀｲﾙ
{
	enDot_Around			= 0,														// dot pixel 1 x 1
	enDot_RightUp																		// dot pixel 2 X 2
} DOT_STYLE;
typedef enum																			// ﾗｲﾝｽﾀｲﾙ
{
	enLine_Solid			= 0,														// 実線
	enLine_Dot																			// 破線
} LINE_STYLE;

typedef struct
{
	uint8_t*	Image;
	uint16_t	Width;
	uint16_t	Height;
	uint16_t	WidthMemory;
	uint16_t	HeightMemory;
	uint16_t	Rotate;
	uint16_t	Mirror;
	uint16_t	WidthByte;
	uint16_t	HeightByte;
} PAINT;

/************************************************************************************************/
/*	《５》構造体/共用体定義																		*/
/************************************************************************************************/

/************************************************************************************************/
/*	《６》外部参照変数定義(ドメイン・グローバルな外部変数)										*/
/************************************************************************************************/

/************************************************************************************************/
/*	《７》関数プロトタイプ宣言(外部に公開する関数)												*/
/************************************************************************************************/
extern void Display_Init( DISPLAY_TYPE Type );
extern void Display_Clear();
extern void Display_Draw( uint16_t Sx, uint16_t Sy, const char* pString, FONT* Font );
extern void Display_Draw( uint16_t Sx, uint16_t Sy, int32_t Nummber, FONT* Font );
extern void Display_Sleep();
extern uint16_t Display_GetisplayWidth();
extern uint16_t Display_GetDisplayHeight();

extern void Paint_NewImage( uint8_t* Image, uint16_t Width, uint16_t Height, uint16_t Rotate );
extern void Paint_SelectImage( uint8_t* Image );
extern void Paint_SetRotate( uint16_t Rotate );
extern void Paint_SetMirror( uint16_t Mirror );
extern void Paint_Clear( uint16_t Color );
extern void Paint_SetPixel( uint16_t Px, uint16_t Py, uint16_t Color );
extern void Paint_ClearWindows( uint16_t Sx, uint16_t Sy, uint16_t Ex, uint16_t Ey, uint16_t Color );
extern void Paint_DrawPoint( uint16_t Px, uint16_t Py, uint16_t Color, DOT_SIZE Size, DOT_STYLE Style );
extern void Paint_DrawLine( uint16_t Sx, uint16_t Sy, uint16_t Ex, uint16_t Ey, uint16_t Color, DOT_SIZE Width, LINE_STYLE Style );
extern void Paint_DrawRectangle( uint16_t Sx, uint16_t Sy, uint16_t Ex, uint16_t Ey, uint16_t Color, DOT_SIZE Width, bool fill );
extern void Paint_DrawCircle( uint16_t Cx, uint16_t Cy, uint16_t Radius, uint16_t Color, DOT_SIZE Width, bool fill );
extern void Paint_DrawString( uint16_t Sx, uint16_t Sy, const char* pString, FONT* Font, uint16_t Foreground, uint16_t Background );
extern void Paint_DrawChar( uint16_t Px, uint16_t Py, const char Acsii_Char, FONT* Font, uint16_t Foreground, uint16_t Background );
extern void Paint_DrawNum( uint16_t Sx, uint16_t Sy, int32_t Nummber, FONT* Font, uint16_t Foreground, uint16_t Background );
extern void Paint_DrawBitMap( const uint8_t* Image );


#endif // DISPLAY_H
