<?php
//
// このﾌｧｲﾙ中で<?phpの外に、例えば以下の文字列などがあると 
// <!DOCTYPE HTML>
// <html lang=ja>
// 
//  javascript の fetch の戻りで以下の文字列も戻ってしまうので注意
//  res = await fetch(・・・) で
//  res = '<!DOCTYPE HTML>\n<html lang=ja>・・・'
//
/************************************************************************************************/
/*                                                                                              */
/*                                                                                              */
/*                                           php定義                                            */
/*                                         ﾊﾞｯｸｴﾝﾄﾞ処理                                         */
/*                                                                                              */
/************************************************************************************************/

	$raw  = file_get_contents( 'php://input' );											// POSTされた生のﾃﾞｰﾀを受け取る
	$data = json_decode( $raw );														// json形式をphp変数に変換
	if( $data != null )
	{
		$response = array(
			'message'=> $data->message,
			'file'=>    '',
			'data'=>    ''
		);

		$fileName = './data/' . $data->file;
		switch( $data->message )
		{
			case 'SaveFile':
				// JSON_UNESCAPED_UNICODE は \uXXXX での表記でなく、日本語表記でｴﾝｺｰﾄﾞさせるﾌﾗｸﾞ
				// JSON_PRETTY_PRINT      は 改行とﾀﾌﾞ付き表現でｴﾝｺｰﾄﾞさせるﾌﾗｸﾞ
				file_put_contents( $fileName, json_encode( $data->data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT ));
				break;
			case 'ResetDemo':
				copy( './data/schedule_org.json', './data/schedule.json' );
				break;
			case 'GetFile':
				$reqData = json_decode( file_get_contents( $fileName ));				// ﾃﾞｰﾀ読込み
				$response[ 'data' ] = $reqData;
				break;
			default:
				break;
		}
		echo json_encode( $response );													// json形式にして返す。echoするとsendPost()の戻り値として返せる
	}
?>