<?php
/************************************************************************************************/
/*                                                                                              */
/*                                                                                              */
/*                                          ﾛｸﾞｲﾝ処理                                           */
/*                                                                                              */
/*                                                                                              */
/************************************************************************************************/
// ﾛｸﾞｲﾝ後はﾌﾞﾗｳｻﾞを閉じるまでｾｯｼｮﾝ有効でﾛｸﾞｲﾝ状態が継続する
// ﾌﾞﾗｳｻﾞを閉じればﾛｸﾞｱｳﾄ状態になる
	header( 'Expires: ' . gmstrftime('%a, %d %b %Y %H:%M:%S GMT', time() ));			// ｷｬｯｼｭｸﾘｱ ﾍﾟｰｼﾞの有効期限が切れるまでの時間を現在時刻で指定し、期限切れとする

	$userid   = '';																		// ﾕｰｻﾞID(半角英数字)
	$password = '';																		// ﾊﾟｽﾜｰﾄﾞ

	session_start();																	// ｾｯｼｮﾝ開始
	if( isset( $_GET[ 'logout' ] ))
	{
		$_SESSION = array();
		session_destroy();																// ｾｯｼｮﾝ破棄
	}
	$login_error = '';
	if( !isset( $_SESSION[ 'auth' ] ))													// ｾｯｼｮﾝ変数初期化
	{
		$_SESSION[ 'auth' ] = FALSE;
	}
	/*************************/
	/* IDとﾊﾟｽが渡された場合 */
	/*************************/
	if( isset( $_POST[ 'userid' ] ) && isset( $_POST[ 'password' ]))					// $_POST は HTTP POST で渡された値を取得する変数
	{
		if( $_POST[ 'userid' ] === $userid && $_POST[ 'password' ] === $password )
		{
			session_regenerate_id( TRUE );												// ｾｯｼｮﾝ再生成(ｾｯｼｮﾝﾊｲｼﾞｬｯｸ対応らしい)
			$_SESSION[ 'auth' ] = TRUE;
		}

		if( $_SESSION[ 'auth' ] === FALSE )
		{
			$login_error = '<font color="red">ユーザーIDかパスワードに誤りがあります</font>';
		}
	}
	/*************************/
	/* IDとﾊﾟｽ未入力 or 不正 */
	/*************************/
	if( $_SESSION[ 'auth' ] === FALSE )
	{
?>
		<!DOCTYPE HTML>
		<html lang=ja>
		<head>
		</head>
		<style>
		</style>
		<body>
			<div>
				<p class="Tac">ログインをお願いします</p>

				<font color="red">デモ版なので、そのままLOGINボタンをクリックしてください</font>

				<form action="index.php" method="post">
					<label style="width:80px;display:block;float:left">User ID</label>		<!-- label の幅指定は、block と float の設定が必要 -->
					<input name="userid"   id="userid"   value="" size="10" /><br>
					<label style="width:80px;display:block;float:left">Password</label>		<!-- label の幅指定は、block と float の設定が必要 -->
					<input name="password" id="password" value="" size="10" />
					<p class="Tac">
						<input type="submit" style="width:80px" value="LOGIN" />
					</p>
				</form>
			</div>
			<?php
				if( isset( $login_error ))
				{
					echo $login_error;
				}
			?>
		</body>
		</html>
<?php
		exit();
	}
	/*************************/
	/* IDとﾊﾟｽ正常で以下実施 */
	/*************************/
?>


<!DOCTYPE HTML>
<html lang=ja>
<!--
/************************************************************************************************/
/*                                                                                              */
/*                                                                                              */
/*                                           head定義                                           */
/*                                                                                              */
/*                                                                                              */
/************************************************************************************************/
-->
<?php
// ﾌﾞﾗｳｻﾞに表示したくないｺﾒﾝﾄをPHPでｺﾒﾝﾄしている
// 
// 編集不可でｺｰﾙする場合
// http://localhost/wordpress/wp-content/web_app/schedule_app/index.php
// 
// 編集可でｺｰﾙする場合
// http://localhost/wordpress/wp-content/web_app/schedule_app/index.php?edit
?>
<head>
	<meta charset=UTF-8 name="viewport" content="width=device-width, initial-scale=1">
	<title>Schedule Sharing</title>
	<link rel="icon" href="data:,">
</head>
<style>
	div
	{
		padding:          5px;
		box-sizing:       border-box;
		line-height:      25px;
		border:           solid 1px #E0E0E0;
		background-color: #F8F8F8;
	}
	/*************************/
	/*        ﾀﾌﾞ関係        */
	/*************************/
	/* ﾀﾌﾞ切り替えの全体ｽﾀｲﾙ						*/
	.tabs-all
	{
		margin:           auto;
		align:            center;
		width:            1000px;					/* ｺﾒﾝﾄｱｳﾄすれば、幅方向ｽﾄﾚｯﾁ表示される */
		padding-top:      20px;
		top:              8px;
		left:             0px;
		font-size:        13px;
	}
	/* ﾀﾌﾞのｽﾀｲﾙ									*/
	.tab-item
	{
		width:            150px;
		height:           25px;
		line-height:      25px;
		border-bottom:    1px solid #5ab4bd;
		background-color: #d9d9d9;
		font-size:        15px;
		text-align:       center;
		color:            #565656;
		display:          block;
		float:            left;
		text-align:       center;
		font-weight:      bold;
		transition:       all 0.2s ease;
	}
	/* ﾀﾌﾞ上のﾏｳｽが不透過化							*/
	.tab-item:hover
	{
		opacity:          0.75;
	}
	/* ﾗｼﾞｵﾎﾞﾀﾝを全て消す							*/
	input[name=tab-item]
	{
		display:          none;
	}
	/* ﾀﾌﾞ切り替えの中身のｽﾀｲﾙ						*/
	.tab-content
	{
		display:          none;
		padding:          0;
		clear:            both;
		overflow:         hidden;
	}
	/* 選択されているﾀﾌﾞのｺﾝﾃﾝﾂのみを表示			*/
	#Id_ScheduleTab:checked ~ #Id_ScheduleContent,
	#Id_OthersTab:checked   ~ #Id_OthersContent
	{
		display: block;
	}
	/* 選択されているﾀﾌﾞのｽﾀｲﾙを変える				*/
	.tabs-all input:checked + .tab-item
	{
		background-color: #E1F0B4;
	}
	/*************************/
	/*       ﾃｰﾌﾞﾙ関係       */
	/*************************/
	/* ﾃｰﾌﾞﾙｽﾀｲﾙ									*/
	table,
	th,
	td
	{
		padding:          5px;
		border:           1px solid;
		border-collapse:  collapse;
		border-color:     #000000;
	}
	table
	{
		align:            center;
		margin:           auto
	}
	.event-row
	{
		background-color: #000000;
		color:            #FFFFFF;
	}
	.title-row
	{
		background-color: #0070C0;
		color:            #FFFFFF;
	}
	.edit-btn
	{
		width:            80px;
		height:           20px;
		font-size:        13px;
	}
	.sel-btn
	{
		width:            40px;
		height:           20px;
		font-size:        13px;
	}
	.date-col
	{
		text-align:       center;
		width:            10%;
	}
	.contens-col
	{
		text-align:       center;
		width:            10%;
	}
	.time-col
	{
		text-align:       center;
		width:            35%;
	}
	.details-col
	{
		text-align:       center;
		width:            55%;
	}
	.edit-col
	{
		text-align:       center;
		width:            10%;
	}
	.time-lbl,
	.member-lbl,
	.logo-lbl,
	.bkgnd-lbl
	{
		display:          block;
		float:            left;
		width:            40px;
	}
	.time-sel
	{
		width:            60px;
	}
	/*************************/
	/*       ﾓｰﾀﾞﾙ関係       */
	/*************************/
	.modal
	{
		display:          none;
		position:         fixed;
		z-index:          1;
		left:             0;
		top:              0;
		height:           100%;
		width:            100%;
		overflow:         auto;
		background-color: rgba( 0,0,0,0.5 );
	}
	.modal-content
	{
		background-color: #f4f4f4;
		margin:           20% auto;
		width:            50%;
		box-shadow:       0 5px 8px 0 rgba( 0,0,0,0.2 ),0 7px 20px 0 rgba( 0,0,0,0.17 );
	}
	.modal-header
	{
		background:       lightblue;
		padding:          3px 15px;
		display:          flex;
		justify-content:  space-between;
	}
	.modal-header h1
	{
		margin: 1rem      0;
	}
	.modalClose
	{
		font-size:        2rem;
	}
	.modal-body
	{
		padding:          10px 20px;
		color:            black;
	}
	/* ﾓｰﾀﾞﾙの×印でのﾏｳｽ形状 */
	.modalClose:hover
	{
		cursor:           pointer;
	}
</style>
<!--
/************************************************************************************************/
/*                                                                                              */
/*                                                                                              */
/*                                           body定義                                           */
/*                                                                                              */
/*                                                                                              */
/************************************************************************************************/
-->
<body>
	<!--
	/*************************/
	/*          ﾀﾌﾞ          */
	/*************************/
	-->
	<div class="tabs-all">
		<input type="radio" id="Id_ScheduleTab" name="tab-item" checked>
		<label class="tab-item" for="Id_ScheduleTab"  >Schedule</label>
		<input type="radio" id="Id_OthersTab"   name="tab-item">
		<label class="tab-item" for="Id_OthersTab">Others</label>

		<!--
		/*************************/
		/*      Scheduleﾀｸﾞ      */
		/*************************/
		-->
		<div class="tab-content" id="Id_ScheduleContent">
			<p>
				<?php
					createMenuBtn();
				?>
			<p/>

			<p>
				<?php
					// ｽｹｼﾞｭｰﾙﾌｧｲﾙがあれば読む
					$file = './data/schedule.json';
					if( file_exists( $file ))
					{
						createTableList(  $file );
						createTable( $file );
					}
				?>
			<p/>
		</div>

		<!--
		/*************************/
		/*        その他         */
		/*************************/
		-->
		<div class="tab-content" id="Id_OthersContent">
		</div>
		<!--
		/*************************/
		/*         ﾓｰﾀﾞﾙ         */
		/*************************/
		-->
		<div id="waitModal" class="modal">
			<div class="modal-content">
				<div class="modal-header">
					<h1>Reading Data</h1>
					<span class="modalClose">×</span>
				</div>
<!--
				<div class="modal-body">
					<p>You've just displayed this awesome Modal Window!</p>
					<p>Let's enjoy learning JavaScript ☺️</p>
				</div>
-->
			</div>
		</div>
	</div>

	<!--
	/************************************************************************************************/
	/*                                                                                              */
	/*                                                                                              */
	/*                                        JavaScript定義                                        */
	/*                                                                                              */
	/*                                                                                              */
	/************************************************************************************************/
	-->
	<script>
		/********************************************************************************************/
		/*                                                                                          */
		/*                                         変数定義                                         */
		/*                                                                                          */
		/********************************************************************************************/
		const C_STR_DATA_DIR     = './data/';											// ﾃﾞｰﾀﾌｧｲﾙﾌｫﾙﾀﾞ
		const C_STR_BKGROUND_DIR = './data/img/';										// 背景ﾌｧｲﾙﾌｫﾙﾀﾞ
		const C_STR_LOGO_DIR     = './data/img/';										// ﾛｺﾞﾌｧｲﾙﾌｫﾙﾀﾞ
		const C_MES_SEL_MEMBER   = 'Select Group';										// ﾒﾝﾊﾞｰｾﾙ のｾﾚｸﾄﾎﾞｯｸｽ表記
		const C_MES_SEL_LOGO     = 'Select logo';										// ﾛｺﾞｾﾙ   のｾﾚｸﾄﾎﾞｯｸｽ表記
		const C_MES_SEL_BKGND    = 'Select background';									// ﾛｺﾞｾﾙ   のｾﾚｸﾄﾎﾞｯｸｽ表記
		const C_MES_SEL_TIME     = 'Select place';										// 時間ｾﾙ  のｾﾚｸﾄﾎﾞｯｸｽ表記
		const C_MES_SEL_DETAILS  = 'Select place and address';							// 詳細ｾﾙ  のｾﾚｸﾄﾎﾞｯｸｽ表記

		var   gPlace_Address     = null;												// 住所録ﾃﾞｰﾀ
		const gTime              = [ '00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15','16', '17', '18', '19', '20', '21', '22', '23' ];
		const gMin               = [ '00', '05', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55' ];
		var   gGroup_Member      = null;												// ﾒﾝﾊﾞｰﾃﾞｰﾀ
		var   gFocusBlock        = false;												// ﾌｫｰｶｽ制御ﾌﾗｸﾞ
		const gModal             = document.getElementById( 'waitModal' );				// ｳｴｲﾄ表示ﾓｰﾀﾞﾙ
		const gModalClose        = document.getElementsByClassName( 'modalClose' )[ 0 ];
		var   gBkGround          = null;												// 背景設定ﾃﾞｰﾀ
		var   gLogo              = null;												// ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ

		var   gBkGround_IdNum    = null;												// 背景設定ｾﾙのID 背景表示のﾃﾝﾎﾟﾗﾘｰ変数
		var   gBkGround_Name     = null;												// 背景名         背景表示のﾃﾝﾎﾟﾗﾘｰ変数
		var   gLogo_Id           = null;												// ﾛｺﾞ表示ｾﾙのID  ﾛｺﾞ表示のﾃﾝﾎﾟﾗﾘｰ変数
		var   gLogo_FileName     = null;												// ﾛｺﾞﾌｧｲﾙ名      ﾛｺﾞ表示のﾃﾝﾎﾟﾗﾘｰ変数

		gModalClose.addEventListener( 'click', modalClose );

		/********************************************************************************************/
		/*                                                                                          */
		/*                                         関数定義                                         */
		/*                                                                                          */
		/********************************************************************************************/
		window.addEventListener( 'load', onLoad );

		/*************************/
		/*     ﾛｰﾄﾞ完了ｲﾍﾞﾝﾄ     */
		/*************************/
		function onLoad()
		{
			let url    = new URL( window.location.href );								// URLを取得
			let params = url.searchParams;												// URLSearchParamsｵﾌﾞｼﾞｪｸﾄを取得
			if( params.has( 'edit' ))
			{
				modalOpen();															// ﾌｧｲﾙ読込みまでｳｴｲﾄを表示する
			}

			sendPost( 'Id_OnLoad_0', 'GetFile', 'place_address.json', '' );				// 住所録ﾌｧｲﾙ読込み→ﾒﾝﾊﾞｰﾌｧｲﾙ読込み→背景設定ﾌｧｲﾙ読込み→ﾛｺﾞﾌｧｲﾙ読込み→ﾛｺﾞ情報にｾｯﾄされているﾛｺﾞを読込んで表示
		}
		/*************************/
		/*  ﾁｪｯｸﾎﾞｯｸｽ変更ｲﾍﾞﾝﾄ   */
		/*************************/
		function chkBoxChanged( id )
		{
			element = document.getElementById( id );

			switch( id )
			{
				case 'Id_Editable':
					reload();
					break;
				default:
					break;
			}
		}
		/*************************/
		/*  ｾﾚｸﾄﾎﾞｯｸｽ変更ｲﾍﾞﾝﾄ   */
		/*************************/
		function selectBoxChanged( event )
		{
			let id = event.srcElement.id;
			let id_header = id.split( '?' );											// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離

			switch( id )
			{
				case 'Id_Sel_TblList':													// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ変更
					showTable();
					break;
				default:
					switch( id.split( '?' )[ 0 ] )
					{
						case 'Id_Sel_MemberNameList':
							addText( 'Id_Cell_Member', id_header[ 1 ] );
							break;
						case 'Id_Sel_LogoList':
							addLogo( id, 'Id_Cell_Logo', id_header[ 1 ] );
							break;
						case 'Id_Sel_BkGndList':
							setBkGround( id, id_header[ 1 ] );
							break;
						case 'Id_Sel_PlaceAddrList':
							addText( 'Id_Cell_Details', id_header[ 1 ] );
							break;
						default:
							break;
					}
					break;
			}
		}
		/*************************/
		/*     ﾏｳｽｱｯﾌﾟｲﾍﾞﾝﾄ      */
		/*************************/
		// 通常ﾏｳｽｱｯﾌﾟをｲﾍﾞﾝﾄﾄﾘｶﾞｰにするが、今回ﾏｳｽｱｯﾌﾟをﾄﾘｶﾞとした。以下その理由
		// 時間ｾﾙや詳細ｾﾙなどにﾌｫｰｶｽを与えたらｾﾚｸﾄﾎﾞｯｸｽを表示させ、ﾌｫｰｶｽﾛｽﾄで表示を消している
		// 表示有無によって表の縦ｻｲｽﾞが変化するので、ｾﾚｸﾄﾎﾞｯｸｽ表示中に削除・挿入ﾎﾞﾀﾝを押すと
		// ｾﾚｸﾄﾎﾞｯｸｽの表示が消えて表のｻｲｽﾞが小さくなる。同時にﾎﾞﾀﾝも移動してしまうので
		// ﾎﾞﾀﾝを離した時点でﾏｳｽはﾎﾞﾀﾝから離れてしまう。その結果ﾏｳｽｱｯﾌﾟｲﾍﾞﾝﾄは発生しない
		// これを解決するのは複雑になりすぎるのでﾏｳｽﾀﾞｳﾝをﾄﾘｶﾞとした（表のｻｲｽﾞが変更になってもﾀﾞｳﾝｲﾍﾞﾝﾄは発火済）
		function mouseDn( event )
		{
			let id        = event.srcElement.id;
			let id_header = id.split( '?' );											// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離

			console.log( 'Button ' + id );

			switch( id )
			{
				case 'Id_Reload':														// 再読込み → 自分を呼ぶので結果的にはﾘﾛｰﾄﾞの実行
					reload();
					break;
				case 'Id_Save':															// 更新
					clrCellElements( 'Id_Cell_Member'  );
					clrCellElements( 'Id_Cell_Logo'    );
					clrCellElements( 'Id_Cell_Time'    );
					clrCellElements( 'Id_Cell_Details' );
					sendPost( id, 'SaveFile', 'schedule.json', getTableData());			// ﾃｰﾌﾞﾙﾃﾞｰﾀ取得と送信
					break;
				case 'Id_ResetDemo':													// ﾃﾞﾓﾃﾞｰﾀ初期化
					sendPost( id, 'ResetDemo', '', '' );
					break;
				default:
					switch( id.split( '?' )[ 0 ] )
					{
						case 'Id_Btn_DelTable':											// ﾃｰﾌﾞﾙの削除
							removeTable( id );
							break;
						case 'Id_Btn_InsTable':											// ﾃｰﾌﾞﾙの挿入
							insertTable( id );
							break;
						case 'Id_Btn_DelDate':											// 日付行の削除
							removeDate( id );
							break;
						case 'Id_Btn_InsDate':											// 日付行の挿入
							insertDate( id );
							break;
						case 'Id_Btn_DelRow':											// ｺﾝﾃﾝﾂ行の削除
							removeContent( id );
							break;
						case 'Id_Btn_InsRow':											// ｺﾝﾃﾝﾂ行の挿入
							insertContent( id );
							break;
						case 'Id_Btn_Time_Add':											// 時間ｾﾙへのﾃｷｽﾄ追加
							addText( 'Id_Cell_Time', id_header[ 1 ] );
							break;
						default:
							break;
					}
					break;
			}
		}
		/*************************/
		/*     ﾌｫｰｶｽｱｳﾄｲﾍﾞﾝﾄ     */
		/*************************/
		function cellBlur( event )
		{
			let id        = event.currentTarget.id;										// ｲﾍﾞﾝﾄ名ｾﾙのID取得
			let id_header = id.split( '?' );											// Id_Btn_InsRow?0 などの文字列部とID番号(0_0_0)を分離
			let element;

			console.log( 'Blur   ' + id );

			if( gFocusBlock === true )
			{
				return;
			}
			switch( id_header[ 0 ] )
			{
				case 'Id_Cell_Event':
					element = document.getElementById( id );
					rewriteSheduleList( 'Id_Table?' + id_header[ 1 ], element.innerText );
					break;
				case 'Id_Cell_Member':
				case 'Id_Sel_MemberNameList':
					document.getElementById( 'Id_Cell_Member?' + id_header[ 1 ] ).height = "";

					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽを受け取る → 戻る
						if(( 'Id_Cell_Member?'        + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_MemberNameList?' + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}
					removeMemberCellElements( id_header[ 1 ] );
					break;
				case 'Id_Cell_Logo':
				case 'Id_Sel_LogoList':
				case 'Id_Sel_BkGndList':
					document.getElementById( 'Id_Cell_Logo?' + id_header[ 1 ] ).height = "";

					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽを受け取る → 戻る
						if(( 'Id_Cell_Logo?'     + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_LogoList?'  + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_BkGndList?' + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}
					removeLogoCellElements( id_header[ 1 ] );
					break;
				case 'Id_Cell_Time':
				case 'Id_Sel_StaTimeList':
				case 'Id_Sel_StaMinList':
				case 'Id_Sel_EndTimeList':
				case 'Id_Sel_EndMinList':
				case 'Id_Sel_PlaceList':
				case 'Id_Btn_Time_Add':
					document.getElementById( 'Id_Cell_Time?' + id_header[ 1 ] ).height = "";

					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽを受け取る → 戻る
						if(( 'Id_Cell_Time?'       + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_StaTimeList?' + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_StaMinList?'  + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_EndTimeList?' + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_EndMinList?'  + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_PlaceList?'   + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Btn_Time_Add?'    + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}
					removeTimeCellElements( id_header[ 1 ] );

					break;
				case 'Id_Cell_Details':
				case 'Id_Sel_PlaceAddrList':
					document.getElementById( 'Id_Cell_Details?' + id_header[ 1 ] ).height = "";

					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽを受け取る → 戻る
						if(( 'Id_Cell_Details?'      + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_PlaceAddrList?' + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}
					removeDetailsCellElements( id_header[ 1 ] );
					break;
				default:
					break;
			}
		}
		/*************************/
		/*      ﾌｫｰｶｽｲﾍﾞﾝﾄ       */
		/*************************/
		function cellFocus( event )
		{
			let id        = event.currentTarget.id;										// ｲﾍﾞﾝﾄ名ｾﾙのID取得
			let id_header = id.split( '?' );											// Id_Btn_InsRow?0 などの文字列部とID番号(0_0_0)を分離

			console.log( 'Focus  ' + id );

			if( gFocusBlock === true )
			{
				return;
			}
			switch( id_header[ 0 ] )
			{
				case 'Id_Cell_Event':
					break;
				case 'Id_Cell_Member':
				case 'Id_Sel_MemberNameList':
					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽをﾛｽﾄ → 戻る
						if(( 'Id_Cell_Member?'        + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_MemberNameList?' + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}

					if( gGroup_Member === null )
					{
						return;
					}
					addMemberCellElements( id_header[ 1 ] );
					break;
				case 'Id_Cell_Logo':
				case 'Id_Sel_LogoList':
				case 'Id_Sel_BkGndList':
					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽをﾛｽﾄ → 戻る
						if(( 'Id_Cell_Logo?'     + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_LogoList?'  + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_BkGndList?' + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}

					if( gLogo === null )
					{
						return;
					}
					addLogoCellElements( id_header[ 1 ] );
					break;
				case 'Id_Cell_Time':
				case 'Id_Sel_StaTimeList':
				case 'Id_Sel_StaMinList':
				case 'Id_Sel_EndTimeList':
				case 'Id_Sel_EndMinList':
				case 'Id_Sel_PlaceList':
				case 'Id_Btn_Time_Add':
					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽをﾛｽﾄ → 戻る
						if(( 'Id_Cell_Time?'       + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_StaTimeList?' + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_StaMinList?'  + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_EndTimeList?' + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_EndMinList?'  + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_PlaceList?'   + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Btn_Time_Add?'    + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}

					if( gPlace_Address === null )
					{
						return;
					}
					addTimeCellElements( id_header[ 1 ] );
					break;
				case 'Id_Cell_Details':
				case 'Id_Sel_PlaceAddrList':
					if( event.relatedTarget !== null )
					{
						// 同一ｾﾙの要素がﾌｫｰｶｽをﾛｽﾄ → 戻る
						if(( 'Id_Cell_Details?'      + id_header[ 1 ] === event.relatedTarget.id )
						|| ( 'Id_Sel_PlaceAddrList?' + id_header[ 1 ] === event.relatedTarget.id ))
						{
							return;
						}
					}

					if( gPlace_Address === null )
					{
						return;
					}
					addDetailsCellElements( id_header[ 1 ] );
					break;
				default:
					break;
			}
		}
		/*************************/
		/*       POST送信        */
		/*************************/
		async function sendPost( id, mes, filename, send )
		{
			param = {
				message: mes,
				file:    filename,
				data:    send
			};

			let res, resData;
			try
			{
				res = await fetch(
					'server.php',														// 第1引数に送り先
					{
						method:  'POST',												// ﾒｿｯﾄﾞ指定
						headers: { 'Content-Type': 'application/json' },				// jsonを指定
						body:    JSON.stringify( param )								// json形式に変換して添付
					}
				);
				/*************************/
				/*       応答受信        */
				/*************************/
				resData = await res.json();

				if( mes !== resData.message )											// 正常なら送信ﾒｯｾｰｼﾞと応答ﾒｯｾｰｼﾞは同じ
				{
					console.log( 'Save Error' );
				}

				switch( id )
				{
					case 'Id_Save':														// 更新
					case 'Id_ResetDemo':												// ﾃﾞﾓﾃﾞｰﾀ初期化
						break;
					case 'Id_OnLoad_0':
						gPlace_Address = getPlaceAddress( resData.data.Data );			// 住所録ﾌｧｲﾙ取得
						sendPost( 'Id_OnLoad_1', 'GetFile', 'group_member.json', '' );	// ﾒﾝﾊﾞｰﾘｽﾄ要求
						break;
					case 'Id_OnLoad_1':
						gGroup_Member = getMemberList( resData.data.Data );				// ﾒﾝﾊﾞｰﾘｽﾄ取得
						sendPost( 'Id_OnLoad_2', 'GetFile', 'background.json', '' );	// 背景ﾘｽﾄ要求
						break;
					case 'Id_OnLoad_2':
						gBkGround = getBkGroundList( resData.data.Data );				// 背景ﾘｽﾄ取得
						sendPost( 'Id_OnLoad_3', 'GetFile', 'logo.json', '' );			// ﾛｺﾞﾘｽﾄ要求
						break;
					case 'Id_OnLoad_3':
						gLogo = getLogoList( resData.data.Data );						// ﾛｺﾞﾘｽﾄ取得

						[ gBkGround_IdNum, gBkGround_Name ] = getBkGroundInfo( false );	// ﾃｰﾌﾞﾙ内の背景情報取得 ｾﾙId_Cell_BkGroundの情報は消さない
						[ gLogo_Id,        gLogo_FileName ] = getLogoInfo(     true  );	// ﾃｰﾌﾞﾙ内のﾛｺﾞ情報取得  ｾﾙId_Cell_LogoFileの情報はﾛｺﾞ削除などで編集できず管理できないので消す

						reqBkGroundFileData();											// 背景ﾃﾞｰﾀ要求。背景画像ﾃﾞｰﾀ取得→ﾛｺﾞ画像ﾃﾞｰﾀ→画像ﾃﾞｰﾀｾｯﾄ の順番で処理する
						break;
					default:
						break;
				}
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		/*************************/
		/*  背景ﾃﾞｰﾀ要求と取得   */
		/*************************/
		async function reqBkGroundFileData()
		{
			let res, resData;
			try
			{
				// gBkGround の構成[ 背景名, 背景ﾌｧｲﾙ名 or 背景色, 背景ﾌｫﾝﾄ色, ﾀｲﾄﾙ背景色, ﾀｲﾄﾙ文字色, 背景ﾌｧｲﾙﾃﾞｰﾀ, 背景ﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ]
				for( let index = 0; index < gBkGround[ 1 ].length; index++ )
				{
					if( gBkGround[ 6 ][ index ] === false )								// 背景ﾌｧｲﾙﾃﾞｰﾀ取得未の場合
					{
						if( gBkGround[ 1 ][ index ].includes( '#' ) === true )			// 色指定ならｽﾙｰ
						{
							gBkGround[ 6 ][ index ] = true;

							if( index === gBkGround[ 1 ].length - 1 )
							{
								reqLogoFileData();
								return;
							}
							continue;
						}
						res     = await fetch( C_STR_BKGROUND_DIR + gBkGround[ 1 ][ index ] );
						resData = await res.blob();

						gBkGround[ 6 ][ index ] = true;
						gBkGround[ 5 ][ index ] = resData;
						if( index === gBkGround[ 1 ].length - 1 )
						{
							reqLogoFileData();
							return;
						}
						reqBkGroundFileData();
						return;
					}
				}
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		/*************************/
		/*   ﾛｺﾞﾃﾞｰﾀ要求と取得   */
		/*************************/
		async function reqLogoFileData()
		{
			let res, resData;
			try
			{
				// gLogo の構成[ ﾛｺﾞﾌｧｲﾙ名, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ]
				for( let index = 0; index < gLogo[ 0 ].length; index++ )
				{
					if( gLogo[ 2 ][ index ] === false )									// ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ取得未の場合
					{
						res     = await fetch( C_STR_LOGO_DIR + gLogo[ 0 ][ index ] );
						resData = await res.blob();

						gLogo[ 2 ][ index ] = true;
						gLogo[ 1 ][ index ] = resData;
						if( index === gLogo[ 0 ].length - 1 )
						{
							setLogos();
							setBkGrounds();
							modalClose();												// ｳｴｲﾄ表示を消す
							return;
						}
						reqLogoFileData();
						return;
					}
				}
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		/*************************/
		/*    Logo画像ﾃﾞｰﾀｾｯﾄ    */
		/*************************/
		function setLogos()
		{
			let fileIndex;
			try
			{
				// gLogo の構成[ ﾛｺﾞﾌｧｲﾙ名, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ]
				for( let index = 0; index < gLogo_Id.length; index++ )					// ﾃｰﾌﾞﾙで使用されているﾛｺﾞﾌｧｲﾙ名でﾛｺﾞﾘｽﾄ内を検索
				{																		// ﾛｺﾞﾌｧｲﾙ名に一致する gLogo ﾃﾞｰﾀを利用してｾｯﾄする
					fileIndex = gLogo[ 0 ].indexOf( gLogo_FileName[ index ] );			// ﾛｺﾞﾘｽﾄ内のｲﾝﾃﾞｯｸｽ取得
					if( fileIndex < 0 )
					{
						continue;
					}
					
					setLogo( gLogo[ 0 ][ fileIndex ], gLogo[ 1 ][ fileIndex ], gLogo_Id[ index ] );
				}
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		// filename：ﾌｧｲﾙ名
		// image   ：画像ﾃﾞｰﾀ
		// id      ：ｾｯﾄ先のｾﾙID
		function setLogo( filename, image, id )
		{
			let url, img;
			try
			{
				// 画像要素の生成
				url             = ( window.URL || window.webkitURL ).createObjectURL( image );
				img             = document.createElement( 'img' );
				img.src         = url;
				img.height      = 100;
				img.id          = filename;
				img.tabIndex    = '0';													// これを設定しないとﾌｫｰｶｽを受けられない
				img.onkeydown   = keyDn;
				img.style.float = "right";

				// 画像要素をﾛｺﾞ表示ｾﾙにｾｯﾄ
				document.getElementById( id ).appendChild( img );
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		function keyDn( event )
		{
			if(( event.keyCode == 46 )													// DEL ｷｰ
			|| ( event.keyCode == 8  ))													// BSｷｰ
			{
				event.srcElement.remove();
			}
		}
		/*************************/
		/*    背景画像ﾃﾞｰﾀｾｯﾄ    */
		/*************************/
		function setBkGrounds()
		{
			let nameIndex;
			try
			{
				//                     0                1              2           3            4           5                  6
				// gBkGround の構成[ 背景名, 背景ﾌｧｲﾙ名 or 背景色, 背景ﾌｫﾝﾄ色, ﾀｲﾄﾙ背景色, ﾀｲﾄﾙ文字色, 背景ﾌｧｲﾙﾃﾞｰﾀ, 背景ﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ]
				for( let index = 0; index < gBkGround_Name.length; index++ )			// ﾃｰﾌﾞﾙで使用されている背景名で背景ﾘｽﾄ内を検索
				{																		// 背景名に一致する gBkGround ﾃﾞｰﾀを利用してｾｯﾄする
					nameIndex = gBkGround[ 0 ].indexOf( gBkGround_Name[ index ] );		// 背景ﾘｽﾄ内のｲﾝﾃﾞｯｸｽ取得
					if( nameIndex < 0 )
					{
						continue;
					}
					//                      ﾃｰﾌﾞﾙID番号               背景ﾌｧｲﾙﾃﾞｰﾀ                     背景色                     背景ﾌｫﾝﾄ色
					setEventRowColor( gBkGround_IdNum[ index ], gBkGround[ 5 ][ nameIndex ], gBkGround[ 1 ][ nameIndex ], gBkGround[ 2 ][ nameIndex ] );
					//                      ﾃｰﾌﾞﾙID番号                ﾀｲﾄﾙ背景色                    ﾀｲﾄﾙ文字色
					setTitleRowColor( gBkGround_IdNum[ index ], gBkGround[ 3 ][ nameIndex ], gBkGround[ 4 ][ nameIndex ] );
				}
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		// idNum    ：ﾃｰﾌﾞﾙID番号
		// image    ：背景ﾌｧｲﾙﾃﾞｰﾀ
		// backColor：背景色
		// fontColor：背景ﾌｫﾝﾄ色
		function setEventRowColor( idNum, image, backColor, fontColor )
		{
			let element = document.getElementById( 'Id_Row_Event?'  + idNum );			// ｲﾍﾞﾝﾄ行の要素

			if( image === null )														// 色指定の場合
			{
				element.style.backgroundColor = backColor;								// 背景色ｾｯﾄ
				element.style.backgroundImage = '';										// 背景画像削除
			}
			else
			{
				let url = ( window.URL || window.webkitURL ).createObjectURL( image );
				element.style.backgroundImage = "url(" + url + ")";						// 背景画像ｾｯﾄ
			}

			element.style.color = fontColor;											// 文字色ｾｯﾄ
		}
		// idNum    ：ﾃｰﾌﾞﾙID番号
		// backColor：ﾀｲﾄﾙ背景色
		// fontColor：ﾀｲﾄﾙ文字色
		function setTitleRowColor( idNum, backColor, fontColor )
		{
			let element = document.getElementById( 'Id_Row_Title?' + idNum );			// ﾀｲﾄﾙ行の要素
			element.style.backgroundColor = backColor;									// 背景色ｾｯﾄ
			element.style.color           = fontColor;									// 文字色ｾｯﾄ
		}
		/*************************/
		/*       ﾓｰﾀﾞﾙ表示       */
		/*************************/
		function modalOpen()
		{
			gModal.style.display = 'block';
		}
		/*************************/
		/*      ﾓｰﾀﾞﾙｸﾛｰｽﾞ       */
		/*************************/
		// ×印をｸﾘｯｸしてﾓｰﾀﾞﾙを閉じる
		function modalClose()
		{
			gModal.style.display = 'none';
		}
		/*************************/
		/*         ﾘﾛｰﾄﾞ         */
		/*************************/
		function reload()
		{
			if( document.getElementById( 'Id_Editable' ).checked )						// 編集可否のﾁｪｯｸﾎﾞｯｸｽの状態を引き継ぐためにﾊﾟﾗﾒｰﾀを添付する
			{
				window.location.href = 'index.php?edit';
			}
			else
			{
				window.location.href = 'index.php';
			}
		}
		/*************************/
		/*      住所録取得       */
		/*************************/
		function getPlaceAddress( data )
		{
			let name = new Array();
			let addr = new Array();
			let tel  = new Array();

			for( let index = 0; index < data.length; index++ )
			{
				name.push( data[ index ][ 'Name'    ] );
				addr.push( data[ index ][ 'Address' ] );
				tel.push(  data[ index ][ 'Tel'     ] );
			}
			return [ name, addr, tel ];
		}
		/*************************/
		/*     ﾒﾝﾊﾞｰﾘｽﾄ取得      */
		/*************************/
		function getMemberList( data )
		{
			let group  = new Array();
			let logo   = new Array();

			for( let index = 0; index < data.length; index++ )
			{
				group.push(  data[ index ][ 'Group'  ] );
				logo.push(   data[ index ][ 'Logo'   ] );
			}

			let member = new Array( group.length );
			let sex    = new Array( group.length );
			for( let group_index = 0; group_index < group.length; group_index++ )
			{
				member[ group_index ] = new Array();
				sex[    group_index ] = new Array();

				for( let index = 0; index < data[ group_index ][ 'Member' ].length; index++ )
				{
					member[ group_index ].push( data[ group_index ][ 'Member' ][ index ][ 'Name'] );
					sex[ group_index ].push(    data[ group_index ][ 'Member' ][ index ][ 'Sex' ] );
				}
			}
			return [ group, logo, member, sex ];
		}
		/*************************/
		/*      背景ﾘｽﾄ取得      */
		/*************************/
		// [ 背景名, 背景ﾌｧｲﾙ名 or 背景色, 背景ﾌｫﾝﾄ色, ﾀｲﾄﾙ背景色, ﾀｲﾄﾙ文字色, 背景ﾌｧｲﾙﾃﾞｰﾀ, 背景ﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ] を戻す。背景ﾌｧｲﾙﾃﾞｰﾀはここではnull
		function getBkGroundList( data )
		{
			let name            = new Array();
			let bkFileOrColor   = new Array();
			let bkFontColor     = new Array();
			let titleColor   　 = new Array();
			let titleFontColor  = new Array();
			let fileData     　 = new Array();
			let fileDataEnabled = new Array();

			for( let index = 0; index < data.length; index++ )
			{
				name.push(            data[ index ][ "Name"           ] );
				bkFileOrColor.push(   data[ index ][ "BkFileOrColor"  ] );
				bkFontColor.push(     data[ index ][ "BkFontColor"    ] );
				titleColor.push(      data[ index ][ "TitleColor"     ] );
				titleFontColor.push(  data[ index ][ "TitleFontColor" ] );
				fileData.push(        null  );
				fileDataEnabled.push( false );
			}
			return [ name, bkFileOrColor, bkFontColor, titleColor, titleFontColor, fileData, fileDataEnabled ];
		}
		/*************************/
		/*      ﾛｺﾞﾘｽﾄ取得       */
		/*************************/
		// [ ﾛｺﾞﾌｧｲﾙ名, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ] を戻す。ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀはここではnull
		function getLogoList( data )
		{
			let fileName        = new Array();
			let fileData        = new Array();
			let fileDataEnabled = new Array();

			for( let index = 0; index < data.length; index++ )
			{
				fileName.push(        data[ index ][ 'File' ] );
				fileData.push(        null  );
				fileDataEnabled.push( false );
			}

			return [ fileName, fileData, fileDataEnabled ];
		}
		/*************************/
		/*    ｽｹｼﾞｭｰﾙﾃｰﾌﾞﾙ表示    */
		/*************************/
		// ﾃｰﾌﾞﾙﾘｽﾄで選択されたﾃｰﾌﾞﾙを表示
		function showTable()
		{
			let id_header, table, table_br;
			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得

			// 最初が選択された場合は全てのﾃｰﾌﾞﾙを表示する
			if( element.selectedIndex === 0 )
			{
				for( index = 1; index < element.childElementCount; index++ )
				{
					id_header = element.options[ index ].value.split( '?' );			// ﾃｰﾌﾞﾙIDを取得

					// teble の ID を取得して、ﾃｰﾌﾞﾙそのものを表示・非表示とする
					// teble 毎の改行も同様に表示・非表示とする
					table    = document.getElementById( 'Id_Table?'    + id_header[ 1 ] );
					table_br = document.getElementById( 'Id_Table_br?' + id_header[ 1 ] );
					table.style.display    = "block";
					table_br.style.display = "block";
				}
			}
			else
			{
				for( index = 1; index < element.childElementCount; index++ )
				{
					id_header = element.options[ index ].value.split( '?' );			// ﾃｰﾌﾞﾙIDを取得

					// teble の ID を取得して、ﾃｰﾌﾞﾙそのものを表示・非表示とする
					// teble 毎の改行も同様に表示・非表示とする
					table    = document.getElementById( 'Id_Table?'    + id_header[ 1 ] );
					table_br = document.getElementById( 'Id_Table_br?' + id_header[ 1 ] );

					if( element.selectedIndex === index )
					{
						table.style.display    = "block";
						table_br.style.display = "block";
					}
					else
					{
						table.style.display    = "none";
						table_br.style.display = "none";
					}
				}
			}
		}
		/*************************/
		/*   ﾛｺﾞｾﾙへのﾛｺﾞ追加   */
		/*************************/
		// idLogoList：ﾛｺﾞ選択のｾﾚｸﾄﾎﾞｯｸｽID
		// idStr     ：ｾﾙID文字列
		// idNum     ：ｾﾙID番号
		function addLogo( idLogoList, idStr, idNum )
		{
			let element   = document.getElementById( idLogoList );
			let sel_index = element.selectedIndex;										// ｾﾚｸﾄﾎﾞｯｸｽの選択ｲﾝﾃﾞｯｸｽを取得
			if( sel_index === 0 )
			{
				return;
			}
			sel_index--;																// 先頭はﾀｲﾄﾙなので減算

			removeLogoCellElements( idNum );											// ﾛｺﾞｾﾙ要素の削除

			// gLogo の構成[ ﾛｺﾞﾌｧｲﾙ名, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ, ﾛｺﾞﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ]
			setLogo( gLogo[ 0 ][ sel_index ], gLogo[ 1 ][ sel_index ], idStr + '?' + idNum );
		}
		/*************************/
		/*       背景変更        */
		/*************************/
		// idBkGndList：背景選択のｾﾚｸﾄﾎﾞｯｸｽID
		// idNum      ：ｾﾙID番号
		function setBkGround( idBkGndList, idNum )
		{
			let element   = document.getElementById( idBkGndList );
			let sel_index = element.selectedIndex;										// ｾﾚｸﾄﾎﾞｯｸｽの選択ｲﾝﾃﾞｯｸｽを取得
			if( sel_index === 0 )
			{
				return;
			}
			sel_index--;																// 先頭はﾀｲﾄﾙなので減算

			removeLogoCellElements( idNum );											// ﾛｺﾞｾﾙ要素の削除

			//                     0                1              2           3            4           5                  6
			// gBkGround の構成[ 背景名, 背景ﾌｧｲﾙ名 or 背景色, 背景ﾌｫﾝﾄ色, ﾀｲﾄﾙ背景色, ﾀｲﾄﾙ文字色, 背景ﾌｧｲﾙﾃﾞｰﾀ, 背景ﾌｧｲﾙﾃﾞｰﾀ取得済ﾌﾗｸﾞ ]

			//              ﾃｰﾌﾞﾙID番号     背景ﾌｧｲﾙﾃﾞｰﾀ                     背景色                     背景ﾌｫﾝﾄ色
			setEventRowColor( idNum, gBkGround[ 5 ][ sel_index ], gBkGround[ 1 ][ sel_index ], gBkGround[ 2 ][ sel_index ] );
			//              ﾃｰﾌﾞﾙID番号     ﾀｲﾄﾙ背景色                    ﾀｲﾄﾙ文字色
			setTitleRowColor( idNum, gBkGround[ 3 ][ sel_index ], gBkGround[ 4 ][ sel_index ] );

			element           = document.getElementById( 'Id_Cell_BkGround?' + idNum );
			element.innerText = gBkGround[ 0 ][ sel_index ];
		}
		/*************************/
		/*  指定ｾﾙへのﾃｷｽﾄ追加   */
		/*************************/
		// idStr：ｾﾙID文字列
		// idNum：ｾﾙID番号
		function addText( idStr, idNum )
		{
			let str;
			let element;
			let height;

			gFocusBlock = true;

			switch( idStr )
			{
				case 'Id_Cell_Member':
					str = getMemberCellElements(  idNum );
					break;
				case 'Id_Cell_Time':
					str = getTimeCellElements(    idNum );
					break;
				case 'Id_Cell_Details':
					str = getDetailsCellElements( idNum );
					break;
				default:
					return;
			}

			if( str !== '' )
			{
				element        = document.getElementById( idStr + '?' + idNum );
				element.height = element.clientHeight;									// 要素を削除するとｾﾙの高さが小さくなり、ﾏｳｽﾀﾞｳﾝによるﾌｫｰｶｽが受けられない。高さを再設定すると小さくならないで済むみたい
				// ｾﾙにはﾎﾞﾀﾝなどもﾃｷｽﾄとして表現されているので、ﾃｷｽﾄを追加するには、ｾﾙにｾｯﾄされている要素削除が必要
				switch( idStr )
				{
					case 'Id_Cell_Member':
						removeMemberCellElements(  idNum );								// ﾒﾝﾊﾞｰｾﾙ要素の削除
						break;
					case 'Id_Cell_Time':
						removeTimeCellElements(    idNum );								// 時間ｾﾙ要素の削除
						break;
					case 'Id_Cell_Details':
						removeDetailsCellElements( idNum );								// 詳細ｾﾙ要素の削除
						break;
					default:
						return;
				}
				if( element.innerText !== '' )
				{
					element.innerText  = element.innerText + '\n' + str;
				}
				else
				{
					element.innerText  = element.innerText + str;
				}
			}
			// ｾﾚｸﾄﾎﾞｯｸｽにﾌｫｰｶｽがあって、Write ﾎﾞﾀﾝを押すので、Write ﾎﾞﾀﾝにﾌｫｰｶｽが入ってから、ｾﾚｸﾄﾎﾞｯｸｽのﾌｫｰｶｽが外れるので
			// ここでの処理中にｾﾚｸﾄﾎﾞｯｸｽの cellBlur ｲﾍﾞﾝﾄが起動してしまうので、cellBlur 関数内で gFocusBlock でﾌﾞﾛｯｸする
			gFocusBlock = false;
		}
		// idNum：ID番号
		function getMemberCellElements( idNum )
		{
			let element;
			let str = '';

			element = document.getElementById( 'Id_Sel_MemberNameList?' + idNum );
			if(( element === null ) || ( element.selectedIndex === 0 ))
			{
				return str;
			}
			for( let index = 0; index < gGroup_Member[ 2 ][ element.selectedIndex -1 ].length; index++ )
			{
				str += gGroup_Member[ 2 ][ element.selectedIndex - 1 ][ index ];
	
				if( index !== gGroup_Member[ 2 ][ element.selectedIndex -1 ].length - 1 )
				{
					str += '\n';
				}
			}

			return str;
		}
		// idNum：ID番号
		function getTimeCellElements( idNum )
		{
			let element0, element1;
			let str = '';

			element0 = document.getElementById( 'Id_Sel_StaTimeList?' + idNum );
			element1 = document.getElementById( 'Id_Sel_StaMinList?'  + idNum );
			if(( element0.selectedIndex !== 0 ) && ( element1.selectedIndex !== 0 ))
			{
				str += element0.options[ element0.selectedIndex ].value + ':' + element1.options[ element1.selectedIndex ].value;
			}
			element0 = document.getElementById( 'Id_Sel_EndTimeList?' + idNum );
			element1 = document.getElementById( 'Id_Sel_EndMinList?'  + idNum );
			if(( element0.selectedIndex !== 0 ) && ( element1.selectedIndex !== 0 ))
			{
				str += '～' + element0.options[ element0.selectedIndex ].value + ':' + element1.options[ element1.selectedIndex ].value;
			}
			element0 = document.getElementById( 'Id_Sel_PlaceList?'   + idNum );
			if( element0.selectedIndex !== 0 )
			{
				// 文字列中間での複数空白は、HTML内では一つに減らされるので、\u00A0 ｺｰﾄﾞを使う
				if( str !== '' )
				{
					str += '\u00A0\u00A0\u00A0';
				}
				str += element0.options[ element0.selectedIndex ].value;
			}

			return str;
		}
		// idNum：ID番号
		function getDetailsCellElements( idNum )
		{
			let element;
			let str = '';

			element = document.getElementById( 'Id_Sel_PlaceAddrList?' + idNum );
			if(( element === null ) || ( element.selectedIndex === 0 ))
			{
				return str;
			}
			// 文字列先頭の空白はHTML内では無視されるので、\u00A0 ｺｰﾄﾞを使う
			str += gPlace_Address[ 0 ][ element.selectedIndex - 1 ];
			if( gPlace_Address[ 1 ][ element.selectedIndex - 1 ] !== '' )
			{
				str += '\n' + '\u00A0\u00A0\u00A0' + gPlace_Address[ 1 ][ element.selectedIndex - 1 ];
			}
			if( gPlace_Address[ 2 ][ element.selectedIndex - 1 ] !== '' )
			{
				str += '\n' + '\u00A0\u00A0\u00A0' + gPlace_Address[ 2 ][ element.selectedIndex - 1 ];
			}

			return str;
		}
		/*************************/
		/*    全ｾﾙ要素の削除     */
		/*************************/
		function clrCellElements( idStr )
		{
			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( let list_index = 1; list_index < element.childElementCount; list_index++ )
			{
				let id_header = element.options[ list_index ].value.split( '?' );		// ID文字列、ID番号取得
				let id_array  = id_header[ 1 ].split( '_' );							// ﾃｰﾌﾞﾙID
				let date_Info = getDateInfo( id_array[ 0 ] );							// [ 日付行数、日付ID最大、全日付IDの番号部分の配列 ] を取得
				let content_info;

				for( let date_index = 0; date_index < date_Info[ 2 ].length; date_index++ )
				{
					let temp    = date_Info[ 2 ][ date_index ].split( '_' );
					let tbl_id  = temp[ 0 ];
					let date_id = temp[ 1 ];

					switch( idStr )
					{
						case 'Id_Cell_Member':
							removeMemberCellElements( tbl_id );							// ﾒﾝﾊﾞｰｾﾙ要素の削除
							break;
						case 'Id_Cell_Logo':											// ﾛｺﾞｾﾙ要素の削除
							removeLogoCellElements( tbl_id );
							break;
						case 'Id_Cell_Time':
						case 'Id_Cell_Details':
							content_info = getContentsInfo(  tbl_id, date_id );			// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を取得

							for( let contents_index = 0; contents_index < content_info[ 2 ].length; contents_index++ )
							{
								let idNum = content_info[ 2 ][ contents_index ];
								switch( idStr )
								{
									case 'Id_Cell_Time':
										removeTimeCellElements(    idNum );				// 時間ｾﾙ要素の削除
										break;
									case 'Id_Cell_Details':
										removeDetailsCellElements( idNum );				// 詳細ｾﾙ要素の削除
										break;
									default:
										return;
								}
							}
							break;
						default:
							return;
					}
				}
			}
		}
		/*************************/
		/*   ﾒﾝﾊﾞｰｾﾙ要素の削除   */
		/*************************/
		// idNum：ID番号
		function removeMemberCellElements( idNum )
		{
			removeCellElement( 'Id_Sel_MemberNameList_br?'    + idNum );
			removeCellElement( 'Id_Sel_MemberNameList_br?'    + idNum );
			removeCellElement( 'Id_Sel_MemberNameList_Title?' + idNum );
			removeCellElement( 'Id_Sel_MemberNameList?'       + idNum );
		}
		/*************************/
		/*    ﾛｺﾞｾﾙ要素の削除    */
		/*************************/
		// idNum：ID番号
		function removeLogoCellElements( idNum )
		{
			removeCellElement( 'Id_Sel_LogoList_br?'          + idNum );
			removeCellElement( 'Id_Sel_LogoList_br?'          + idNum );
			removeCellElement( 'Id_Sel_LogoList_Title?'       + idNum );
			removeCellElement( 'Id_Sel_LogoList?'             + idNum );

			removeCellElement( 'Id_Sel_BkGndList_br?'         + idNum );
			removeCellElement( 'Id_Sel_BkGndList_Title?'      + idNum );
			removeCellElement( 'Id_Sel_BkGndList?'            + idNum );
		}
		/*************************/
		/*   時間ｾﾙ要素の削除    */
		/*************************/
		// idNum：ID番号
		function removeTimeCellElements( idNum )
		{
			removeCellElement( 'Id_Sel_StaTimeList_br?'       + idNum );
			removeCellElement( 'Id_Sel_StaTimeList_br?'       + idNum );
			removeCellElement( 'Id_Sel_StaTimeList_Title?'    + idNum );
			removeCellElement( 'Id_Sel_StaTimeList?'          + idNum );
			removeCellElement( 'Id_Sel_StaMinList?'           + idNum );
			removeCellElement( 'Id_Sel_EndTimeList_br?'       + idNum );
			removeCellElement( 'Id_Sel_EndTimeList_Title?'    + idNum );
			removeCellElement( 'Id_Sel_EndTimeList?'          + idNum );
			removeCellElement( 'Id_Sel_EndMinList?'           + idNum );
			removeCellElement( 'Id_Sel_PlaceList_br?'         + idNum );
			removeCellElement( 'Id_Sel_PlaceList_Title?'      + idNum );
			removeCellElement( 'Id_Sel_PlaceList?'            + idNum );
			removeCellElement( 'Id_Btn_Time_Add?'             + idNum );
		}
		/*************************/
		/*   詳細ｾﾙ要素の削除    */
		/*************************/
		// idNum：ID番号
		function removeDetailsCellElements( idNum )
		{
			removeCellElement( 'Id_Sel_PlaceAddrList_br?'     + idNum );
			removeCellElement( 'Id_Sel_PlaceAddrList_br?'     + idNum );
			removeCellElement( 'Id_Sel_PlaceAddrList_Title?'  + idNum );
			removeCellElement( 'Id_Sel_PlaceAddrList?'        + idNum );
		}
		// id：ID
		function removeCellElement( id )
		{
			try
			{
				element = document.getElementById( id );
				if( element !== null )
				{
					element.remove();
				}
			}
			catch( err )
			{
				console.log( err );
				modalClose();															// ｳｴｲﾄ表示を消す
			}
		}
		/*************************/
		/*   ﾒﾝﾊﾞｰｾﾙ要素の追加   */
		/*************************/
		// idNum：ID番号
		function addMemberCellElements( idNum )
		{
			let cell = document.getElementById( 'Id_Cell_Member?' + idNum );
			setLf(        cell, 'Id_Sel_MemberNameList', idNum );															// Id_Sel_MemberNameList_br?
			setLf(        cell, 'Id_Sel_MemberNameList', idNum );															// Id_Sel_MemberNameList_br?
			setTitle(     cell, 'Id_Sel_MemberNameList', idNum, 'member-lbl',    'Text'  );									// Id_Sel_MemberNameList_Title?
			setSelectBox( cell, 'Id_Sel_MemberNameList', idNum, 'member-sel',    C_MES_SEL_MEMBER,   gGroup_Member[ 0 ] );	// Id_Sel_MemberNameList?
		}
		/*************************/
		/*    ﾛｺﾞｾﾙ要素の追加    */
		/*************************/
		// idNum：ID番号
		function addLogoCellElements( idNum )
		{
			let cell = document.getElementById( 'Id_Cell_Logo?' + idNum );
			setLf(        cell, 'Id_Sel_LogoList',       idNum );															// Id_Sel_LogoList_br?
			setLf(        cell, 'Id_Sel_LogoList',       idNum );															// Id_Sel_LogoList_br?
			setTitle(     cell, 'Id_Sel_LogoList',       idNum, 'logo-lbl',      'Text'  );									// Id_Sel_LogoList_Title?
			setSelectBox( cell, 'Id_Sel_LogoList',       idNum, 'logo-sel',      C_MES_SEL_LOGO,     gLogo[ 0 ] );			// Id_Sel_LogoList?

			setLf(        cell, 'Id_Sel_BkGndList',      idNum );															// Id_Sel_BkGndList_br?
			setTitle(     cell, 'Id_Sel_BkGndList',      idNum, 'bkgnd-lbl',     'Text'  );									// Id_Sel_BkGndList_Title?
			setSelectBox( cell, 'Id_Sel_BkGndList',      idNum, 'bkgnd-sel',     C_MES_SEL_BKGND,    gBkGround[ 0 ] );		// Id_Sel_BkGndList?
		}
		/*************************/
		/*   時間ｾﾙ要素の追加    */
		/*************************/
		// idNum：ID番号
		function addTimeCellElements( idNum )
		{
			if( !document.getElementById( 'Id_Template' ).checked )
			{
				return;
			}

			let cell = document.getElementById( 'Id_Cell_Time?' + idNum );
			setLf(        cell, 'Id_Sel_StaTimeList',    idNum );															// Id_Sel_StaTimeList_br?
			setLf(        cell, 'Id_Sel_StaTimeList',    idNum );															// Id_Sel_StaTimeList_br?
			setTitle(     cell, 'Id_Sel_StaTimeList',    idNum, 'time-lbl',      'Start'        );							// Id_Sel_StaTimeList_Title?
			setSelectBox( cell, 'Id_Sel_StaTimeList',    idNum, 'time-sel',      'time',  gTime );							// Id_Sel_StaTimeList?
			setSelectBox( cell, 'Id_Sel_StaMinList',     idNum, 'time-sel',      'min',   gMin  );							// Id_Sel_StaMinList?
			setLf(        cell, 'Id_Sel_EndTimeList',    idNum )															// Id_Sel_EndTimeList_br?
			setTitle(     cell, 'Id_Sel_EndTimeList',    idNum, 'time-lbl',      'End'          );							// Id_Sel_EndTimeList_Title?
			setSelectBox( cell, 'Id_Sel_EndTimeList',    idNum, 'time-sel',      'time',  gTime );							// Id_Sel_EndTimeList?
			setSelectBox( cell, 'Id_Sel_EndMinList',     idNum, 'time-sel',      'min',   gMin  );							// Id_Sel_EndMinList?
			setLf(        cell, 'Id_Sel_PlaceList',      idNum );															// Id_Sel_PlaceList_br?
			setTitle(     cell, 'Id_Sel_PlaceList',      idNum, 'time-lbl',      'Text'         );							// Id_Sel_PlaceList_Title?
			setSelectBox( cell, 'Id_Sel_PlaceList',      idNum, 'place-sel',     C_MES_SEL_TIME,     gPlace_Address[ 0 ] );	// Id_Sel_PlaceList?
			setAddBtn(    cell, 'Id_Btn_Time_Add',       idNum, 'sel-btn',       'Add'          );							// Id_Btn_Time_Add?
		}
		/*************************/
		/*   詳細ｾﾙ要素の追加    */
		/*************************/
		// idNum：ID番号
		function addDetailsCellElements( idNum )
		{
			if( !document.getElementById( 'Id_Template' ).checked )
			{
				return;
			}

			let cell = document.getElementById( 'Id_Cell_Details?' + idNum );
			setLf(        cell, 'Id_Sel_PlaceAddrList',  idNum );															// Id_Sel_PlaceAddrList_br?
			setLf(        cell, 'Id_Sel_PlaceAddrList',  idNum );															// Id_Sel_PlaceAddrList_br?
			setTitle(     cell, 'Id_Sel_PlaceAddrList',  idNum, 'time-lbl',       'Text'  );								// Id_Sel_PlaceAddrList_Title?
			setSelectBox( cell, 'Id_Sel_PlaceAddrList',  idNum, 'place_addr-sel', C_MES_SEL_DETAILS, gPlace_Address[ 0 ] );	// Id_Sel_PlaceAddrList?
		}
		/*************************/
		/*    ｾﾙへの要素配置     */
		/*************************/
		// 対象ｾﾙにｾﾚｸﾄﾎﾞｯｸｽを配置して戻す
		// cell     ：対象ｾﾙ
		// idStr    ：ｾﾙID文字列
		// idNum    ：ｾﾙID番号
		// className：ｸﾗｽ名
		// title    ：ｲﾝﾃﾞｯｸｽ0への表示文字列
		// text     ：選択項目の文字列
		function setTitle( cell, idStr, idNum, className, title )
		{
			let element       = document.createElement( "label" )						// ﾗﾍﾞﾙ生成
			element.id        = idStr + '_Title?' + idNum;
			element.innerText = title;
			if( className !== '' )
			{
				element.classList.add( className );
			}
			cell.appendChild( element );												// ﾗﾍﾞﾙ追加
		}
		function setLf( cell, idStr, idNum )
		{
			let element = document.createElement( "br" )								// 改行生成
			element.id  = idStr + '_br?' + idNum;
			cell.appendChild( element );												// 改行追加
		}
		function setSelectBox( cell, idStr, idNum, className, title, text )
		{
			let element = createSelectBox( title, text, idStr + '?' + idNum );			// ｾﾚｸﾄﾎﾞｯｸｽ生成
			if( className !== '' )
			{
				element.classList.add( className );
			}
			cell.appendChild( element );												// ｾﾚｸﾄﾎﾞｯｸｽ追加
		}
		function setAddBtn( cell, idStr, idNum, className, title )
		{
			let btn    = createBtn( title, idStr + '?' + idNum );						// ﾎﾞﾀﾝ生成
			btn.onblur = cellBlur;
			btn.classList.add( 'edit-btn' );											// ｸﾗｽ名ｾｯﾄ

			if( className !== '' )
			{
				btn.classList.add( className );
			}
			cell.appendChild( btn );													// ﾎﾞﾀﾝ追加
		}
		/*************************/
		/*     ｾﾚｸﾄﾎﾞｯｸｽ生成     */
		/*************************/
		// title：先頭に表示する文字列
		// text ：選択項目の文字列
		// id   ：ｾﾚｸﾄﾎﾞｯｸｽID
		function createSelectBox( title, text, id )
		{
			let select      = document.createElement( "select" );
			select.id       = id;
			select.onchange = selectBoxChanged;
			select.onblur   = cellBlur;
			select.onfocus  = cellFocus;
			select.onchange = selectBoxChanged;

			select.add( ( new Option( title )));
			for( let index = 0; index < text.length; index++ )
			{
				select.add( ( new Option( text[ index ] )));
			}

			return select;
		}
		/*************************/
		/*        ｾﾙ生成         */
		/*************************/
		// 指定行に新規ｾﾙを追加し、新規ｾﾙを戻す
		// row     ：指定行
		// id      ：ｾﾙID
		// editable：ｾﾙ編集可否
		function CreateCell( row, id, editable )
		{
			let cell = row.insertCell();
			cell.contentEditable = editable;
			cell.id              = id;

			return cell;
		}
		/*************************/
		/*       ﾎﾞﾀﾝ生成        */
		/*************************/
		// text：ﾎﾞﾀﾝ表示名
		// id  ：ﾎﾞﾀﾝID
		function createBtn( text, id )
		{
			// button で生成すると '<br><button id="***?0_2" style="width: 40px; height: 20px; font-size: 10px;">Del row</button>' の形で生成される
			// ﾃｰﾌﾞﾙのtextContent方に text が設定されてしまうのでまずい → input で生成する
			// let btn = document.createElement( "button" );

			let btn         = document.createElement( "input" );
			btn.type        = 'button';
			btn.id          = id;
			btn.value       = text;
			btn.onmousedown = mouseDn;

			return btn;
		}
		/*************************/
		/*   ﾃｰﾌﾞﾙﾘｽﾄへの追加    */
		/*************************/
		// ins_index：ﾃｰﾌﾞﾙﾘｽﾄ挿入位置
		// ins_id   ：挿入ID
		// ins_text ：挿入文字列
		function addTableList( ins_index, ins_id, ins_text )
		{
			let oldValue = new Array();
			let oldText  = new Array();

			// ﾃｰﾌﾞﾙﾘｽﾄを配列にｺﾋﾟｰ。ｲﾝﾃﾞｯｸｽは0からとしAllもｺﾋﾟｰする
			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( index = 0; index < element.childElementCount; index++ )
			{
				oldValue.push( element.options[ index ].value );
				oldText.push(  element.options[ index ].text  );
			}

			// ﾃｰﾌﾞﾙﾘｽﾄｸﾘｱ
			clrTableList();

			// ﾃｰﾌﾞﾙﾘｽﾄ追加
			for( index = 0; index < oldValue.length; index++ )
			{
				if( index === ins_index )
				{
					option       = document.createElement( "option" );
					option.value = ins_id;
					option.text  = ins_text;
					element.appendChild( option );

					option       = document.createElement( "option" );
					option.value = oldValue[ index ];
					option.text  = oldText[  index ];
					element.appendChild( option );
				}
				else
				{
					option       = document.createElement( "option" );
					option.value = oldValue[ index ];
					option.text  = oldText[  index ];
					element.appendChild( option );
				}
			}
			if( oldValue.length === ins_index )
			{
				option       = document.createElement( "option" );
				option.value = ins_id;
				option.text  = ins_text;
				element.appendChild( option );
			}
		}
		/*************************/
		/*   ﾃｰﾌﾞﾙﾘｽﾄ表示更新    */
		/*************************/
		function rewriteSheduleList( id, text )
		{
			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( index = 1; index < element.childElementCount; index++ )
			{
				if( element.options[ index ].value === id )
				{
					element.options[ index ].text = text;
					return;
				}
			}
		}
		/*************************/
		/*      ﾃｰﾌﾞﾙﾘｽﾄｸﾘｱ      */
		/*************************/
		function clrTableList()
		{
			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			while( element.lastChild )													// ﾘｽﾄ全削除
			{
				element.removeChild( element.lastChild );
			}
		}
		/*************************/
		/*      ﾃｰﾌﾞﾙの削除      */
		/*************************/
		// id：Id_Btn_DelTable?i の形式
		function removeTable( id )
		{
			let id_header = id.split( '?' );											// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離
			let id_array  = id_header[ 1 ].split( '_' );								// ﾃｰﾌﾞﾙID

			// 指定ﾃｰﾌﾞﾙの中で日付行数などの情報を取得し、全日付行を削除する
			let date_Info = getDateInfo( id_array[ 0 ] );								// [ 日付行数、日付ID最大、全日付IDの番号部分の配列 ] を取得

			for( let index = 0; index < date_Info[ 0 ]; index++ )
			{
				removeDate( 'Id_Btn_DelDate?' + date_Info[ 2 ][ index ] );
			}
		}
		/*************************/
		/*     日付行の削除      */
		/*************************/
		// id：Id_Btn_DelDate?i_j の形式
		function removeDate( id )
		{
			let id_header    = id.split( '?' );											// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離
			let id_array     = id_header[ 1 ].split( '_' );								// ﾃｰﾌﾞﾙID、日付ID、ｺﾝﾃﾝﾂID取得用

			// 指定日付の中でｺﾝﾃﾝﾂ行数などの情報を取得し、全ｺﾝﾃﾝﾂ行を削除する
			let content_info = getContentsInfo( id_array[ 0 ], id_array[ 1 ] );			// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を取得

			for( let index = 0; index < content_info[ 0 ]; index++ )
			{
				removeContent( 'Id_Btn_DelRow?' + content_info[ 2 ][ index ] );
			}
		}
		/*************************/
		/*     ｺﾝﾃﾝﾂ行の削除     */
		/*************************/
		// id：Id_Btn_DelRow?i_j_k の形式
		function removeContent( id )
		{
			let id_header    = id.split( '?' );											// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離
			let id_array     = id_header[ 1 ].split( '_' );								// ﾃｰﾌﾞﾙID、日付ID、ｺﾝﾃﾝﾂID取得用
			let table        = document.getElementById('Id_Table?' + id_array[ 0 ]);	// 挿入対象のﾃｰﾌﾞﾙ取得

			// 指定日付の中でｺﾝﾃﾝﾂ行数などの情報を取得し、1行なら日付も削除する
			let content_info = getContentsInfo( id_array[ 0 ], id_array[ 1 ] );			// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を取得

			// 指定ﾃｰﾌﾞﾙの中で日付行数などの情報を取得し、1行ならﾃｰﾌﾞﾙも削除する
			let date_Info    = getDateInfo( id_array[ 0 ] );							// [ 日付行数、日付ID最大、全日付IDの番号部分の配列 ] を取得

			if( content_info[ 0 ] > 0 )
			{
				// 削除行のｲﾝﾃﾞｯｸｽを求める
				let target_index = document.getElementById( 'Id_Cell_ContentsName?' + id_header[ 1 ] ).parentNode.rowIndex;
				// 削除対象の行が、日付行と同じ場合
				if( content_info[ 3 ] === target_index )
				{
					// ｺﾝﾃﾝﾂ行数が1での日付行の削除
					//  __________________________________________________________________
					//  |         |          |               |            |               |
					//  |  日付   |          |               |            |               |←この行の削除の場合
					//  |_________|__________|_______________|____________|_______________|　下の段をｺﾋﾟｰして下の段を削除する
					if( content_info[ 0 ] === 1 )
					{
						table.deleteRow( target_index );								// 日付行の削除

						// 日付行が1つの場合は、ﾃｰﾌﾞﾙも削除する
						if( date_Info[ 0 ] === 1 )
						{
							removeCellElement( 'Id_Table?'    + id_array[ 0 ] );
							removeCellElement( 'Id_Table_br?' + id_array[ 0 ] );

							// ﾃｰﾌﾞﾙﾘｽﾄから、削除されたﾃｰﾌﾞﾙを削除
							let element = document.getElementById( 'Id_Sel_TblList' );	// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
							for( index = 1; index < element.childElementCount; index++ )
							{
								if( element.options[ index ].value === 'Id_Table?' + id_array[ 0 ] )
								{
									let sellected = element.selectedIndex;
									element.remove( index );							// ﾃｰﾌﾞﾙ削除
									if( element.childElementCount === 1 )				// ﾃｰﾌﾞﾙが全てないなら、新規に1つ追加
									{
										insertTable( '' );
									}
									else
									{
										// Allが選択されている場合は、何もしないでOK
										if( sellected === 0 )
										{
											;// Do Nothing
										}
										// 個別表示の場合
										else
										{
											// 最後が削除されるので、一つ手前を表示させる
											if( sellected > element.childElementCount - 1 )
											{
												element.selectedIndex = element.childElementCount - 1;
											}
											// 一つ削除済で、そのｲﾝﾃﾞｯｸｽを表示させるので、一つ下が表示されることになる
											else
											{
												element.selectedIndex = sellected;
											}
											showTable();								// ﾃｰﾌﾞﾙﾘｽﾄで選択されたﾃｰﾌﾞﾙを表示
										}
									}
									break;
								}
							}
						}
					}
					// ｺﾝﾃﾝﾂ行数が複数での日付行の削除
					//  __________________________________________________________________
					//  |         |          |               |            |               |
					//  |    0    | dst 1    |       2       |     3      |       4       |←この行の削除の場合(target_index)
					//  |         |_____↑___|_______↑______|_____↑_____|_______↑______|　下の段をｺﾋﾟｰして下の段を削除する
					//  |         |     ｜   |       ｜      |     ｜     |       ｜      |
					//  |  日付   | src 0    |       1       |     2      |       3       |
					//  |         |__________|_______________|____________|_______________|
					//  |         |          |               |            |               |
					//  |         |          |               |            |               |
					//  |_________|__________|_______________|____________|_______________|
					else
					{
						for( let index = 0; index < table.rows[ target_index + 1 ].cells.length; index++ )
						{
							let dst       = table.rows[ target_index     ].cells[ index + 1 ];
							let src       = table.rows[ target_index + 1 ].cells[ index ];
							dst.id        = src.id;
							dst.innerText = src.innerText;
							if( index === table.rows[ target_index + 1 ].cells.length - 1 )
							{
								dst.innerText = '';
								setEditBtn( dst, src.id.split( '?' )[ 1 ] );
							}
						}
						table.deleteRow( target_index + 1 );							// 日付行の下段を削除
						// 日付ｾﾙの列結合数を -1
						document.getElementById( 'Id_Cell_Date?' + id_array[ 0 ] + '_' + id_array[ 1 ] ).rowSpan--;
					}

				}
				// 削除対象の行が、日付行と異なる場合
				//  __________________________________________________________________
				//  |         |          |               |            |               |
				//  |         |          |               |            |               |
				//  |         |__________|_______________|____________|_______________|
				//  |         |          |               |            |               |
				//  |  日付   |          |               |            |               |←この行の削除の場合
				//  |         |__________|_______________|____________|_______________|  この行を削除する
				//  |         |          |               |            |               |
				//  |         |          |               |            |               |
				//  |_________|__________|_______________|____________|_______________|
				else
				{
					table.deleteRow( target_index );
					// 日付ｾﾙの列結合数を -1
					document.getElementById( 'Id_Cell_Date?' + id_array[ 0 ] + '_' + id_array[ 1 ] ).rowSpan--;
				}
			}
		}
		/*************************/
		/*      ﾃｰﾌﾞﾙの挿入      */
		/*************************/
		// id：Id_Btn_InsTable?i の形式
		function insertTable( id )
		{
			let id_header;																// Id_Btn_InsTable?0 などの文字列部とID番号(0)を分離
			let id_array;																// ﾃｰﾌﾞﾙID、日付ID、ｺﾝﾃﾝﾂID取得用
			let table_info;																// [ ﾃｰﾌﾞﾙ数、ﾃｰﾌﾞﾙID最大、ﾃｰﾌﾞﾙﾘｽﾄ挿入位置 ] を取得
			let ins_element;															// ﾃｰﾌﾞﾙ挿入位置の要素(この要素の後に挿入される)
			let sel_element = document.getElementById( 'Id_Sel_TblList' );;				// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得

			if( id !== '' )
			{
				id_header   = id.split( '?' );
				id_array    = id_header[ 1 ].split( '_' );
				table_info  = getTableInfo( id_array[ 0 ] );
				ins_element = document.getElementById('Id_Table_br?'+id_array[0]);		// ﾃｰﾌﾞﾙ間の改行の後にﾃｰﾌﾞﾙ挿入
			}
			else
			{
				table_info = [ 0, -1, 1 ];												// 新規IDは、ﾃｰﾌﾞﾙID最大(-1)を+1して使用、ﾃｰﾌﾞﾙﾘｽﾄ挿入位置は1
				ins_element = document.getElementById( 'Id_Sel_TblList_br' );			// ﾃｰﾌﾞﾙﾘｽﾄの後にﾃｰﾌﾞﾙ挿入
			}

			/*************************/
			/*   ｽｹｼﾞｭｰﾙﾃｰﾌﾞﾙ挿入    */
			/*************************/
			let newId              = table_info[ 1 ] + 1;								// 新規ID
			let newTable           = document.createElement( "table" );					// 新規ﾃｰﾌﾞﾙ生成
			newTable.id            = 'Id_Table?' + newId;
			newTable.cellPadding   = '5';
			newTable.style.display = "block";

			let row_index = addNewHeader( newTable, newId );
			let newRow    = newTable.insertRow( row_index );							// 新規日付行追加
			addNewDate( newRow, newId + '_0', newId + '_0_0' );
			ins_element.after( newTable );												// 新規ﾃｰﾌﾞﾙ挿入
			
			let lf           = document.createElement( "br" )
			lf.id            = 'Id_Table_br?' + newId;
			lf.style.display = "block";
			newTable.after( lf );														// 改行を追加

			/*************************/
			/*     ﾃｰﾌﾞﾙﾘｽﾄ挿入      */
			/*************************/
			let sellected = sel_element.selectedIndex;
			let str       = document.getElementById( 'Id_Cell_Event?' + newId ).innerText;
			addTableList( table_info[ 2 ], newTable.id, str );

			// Allが選択されている場合は、何もしないでOK
			if( sellected === 0 )
			{
				;// Do Nothing
			}
			// 個別表示の場合
			else
			{
				// 選択ﾃｰﾌﾞﾙの次挿入される
				sel_element.selectedIndex = sellected + 1;
				showTable();															// ﾃｰﾌﾞﾙﾘｽﾄで選択されたﾃｰﾌﾞﾙを表示
			}
		}
		/*************************/
		/*     日付行の挿入      */
		/*************************/
		// id：Id_Btn_InsDate?i_j の形式
		function insertDate( id )
		{
			let id_header = id.split( '?' );											// Id_Btn_InsDate?0_0 などの文字列部とID番号(0_0)を分離
			let id_array  = id_header[ 1 ].split( '_' );								// ﾃｰﾌﾞﾙID、日付ID
			let table     = document.getElementById( 'Id_Table?' + id_array[ 0 ] );		// 挿入対象のﾃｰﾌﾞﾙ取得
			let id_date   = 'Id_Cell_Date?' + id_array[ 0 ] + '_' + id_array[ 1 ];		// 挿入対象の日付ｾﾙID
			let flag      = false;														// 挿入対象の日付ｾﾙID検出済ﾌﾗｸﾞ(true)
			let flag_end  = false;
			let ins_index = -1;															// 挿入列ｲﾝﾃﾞｯｸｽ
			let ins_id    = -1;

			// 指定ﾃｰﾌﾞﾙの中で日付行数などの情報を取得し、挿入時の日付IDを date_Info[ 1 ] + 1 としてｾｯﾄする
			let date_Info = getDateInfo( id_array[ 0 ] );

			/*************************/
			/*     挿入行の取得      */
			/*************************/
			for( let row_index = 0; row_index < table.rows.length; row_index++ )
			{
				for( let index = 0; index < table.rows[ row_index ].cells.length; index++ )
				{
					// 挿入対象の日付ｾﾙ検出済の場合
					if( flag === false )
					{
						if( id_date === table.rows[ row_index ].cells[ index ].id )
						{
							flag = true;												// 挿入対象の日付ｾﾙID検出
						}
					}
					// 挿入対象の日付ｾﾙ検出済の場合
					else
					{
						id_header = table.rows[ row_index ].cells[ index ].id.split( '?' );
						switch( id_header[ 0 ] )
						{
							case "Id_Cell_Date":										// 日付ｾﾙの場合
								flag     = false;
								flag_end = true;
								break;
							case "Id_Cell_Details":										// 次の日付ｾﾙを検出するまで編集ｾﾙIDを更新
								ins_index = row_index + 1;								// 挿入対象の日付ｾﾙが最終日付の場合でも編集ｾﾙIDは更新される
								ins_id    = id_header[ 1 ].split( '_' )[ 2 ];			// ｺﾝﾃﾝﾂID取得
								break;
							default:
								break;
						}
					}
					if( flag_end === true )
					{
						break;
					}
				}
				if( flag_end === true )
				{
					break;
				}
			}
			/*************************/
			/*      日付行挿入       */
			/*************************/
			let newRow;
			newRow = table.insertRow( ins_index );										// 指定行に新規行追加

			let newId = id_array[ 0 ] + '_' + ( date_Info[ 1 ] + 1 );
			addNewDate( newRow, newId, newId + '_0' );									// 新規行への日付行追加
		}
		/*************************/
		/*     ｺﾝﾃﾝﾂ行の挿入     */
		/*************************/
		// 列数 table.rows[ row_index ].cells.length
		//                             __________________________________________________________________
		//               列数  行番号  |                    |                            |               |↑
		// row_index=0    2      0     |       Event        |           Member           |     Logo      |｜
		//                             |____________________|____________________________|_______________|｜
		//                             |         |          |               |            |               |｜
		//                5      1     |   Date  | Contents |  Time & Place |  Details   |     Edit      |｜
		//                             |_________|__________|_______________|____________|_______________|｜
		//                             |         |          |               |            |               |｜
		//                5      2     |         |          |               |            |               |｜table.rows.length は 5
		//                             |         |__________|_______________|____________|_______________|｜
		//                             |         |          |               |            |               |｜
		//                4      3     |  日付   |          |               |            |               |｜
		//                             |         |__________|_______________|____________|_______________|｜
		//                             |         |          |               |            |               |｜
		//                4      4     |         |          |               |            |               |｜
		//                             |_________|__________|_______________|____________|_______________|↓
		//
		// 合成されたｾﾙは、一番上で5としてｶｳﾝﾄされるが、その下ではｶｳﾝﾄされない
		//
		// id：Id_Btn_InsRow?i_j_k の形式
		function insertContent( id )
		{
			let id_header = id.split( '?' );											// Id_Btn_InsRow?0_0_0 などの文字列部とID番号(0_0_0)を分離
			let id_array  = id_header[ 1 ].split( '_' );								// ﾃｰﾌﾞﾙID、日付ID、ｺﾝﾃﾝﾂID取得用
			let table     = document.getElementById( 'Id_Table?' + id_array[ 0 ] );		// 挿入対象のﾃｰﾌﾞﾙ取得
			let id_date   = 'Id_Cell_Date?' + id_array[ 0 ] + '_' + id_array[ 1 ];		// 挿入対象の日付ｾﾙID取得
			let id_edit   = 'Id_Cell_Edit?' + id_array[ 0 ] + '_' + id_array[ 1 ] + '_' + id_array[ 2 ];	// 挿入対象の編集ｾﾙID
			let ins_index = -1;															// 挿入列ｲﾝﾃﾞｯｸｽ

			// 指定日付の中でｺﾝﾃﾝﾂ行数などの情報を取得し、挿入時のｺﾝﾃﾝﾂIDを content_info[ 1 ] + 1 としてｾｯﾄする
			let content_info = getContentsInfo( id_array[ 0 ], id_array[ 1 ] );			// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を取得

			/*************************/
			/*     挿入行の取得      */
			/*************************/
			for( let row_index = 0; row_index < table.rows.length; row_index++ )
			{
				for( let index = 0; index < table.rows[ row_index ].cells.length; index++ )
				{
					if( id_date === table.rows[ row_index ].cells[ index ].id )
					{
						table.rows[ row_index ].cells[ index ].rowSpan++;				// 日付ｾﾙの列結合数を +1
					}
					if( id_edit === table.rows[ row_index ].cells[ index ].id )
					{
						ins_index = row_index + 1;
					}
				}
			}
			/*************************/
			/*     ｺﾝﾝﾃﾝﾂ行挿入      */
			/*************************/
			let newRow;
			newRow = table.insertRow( ins_index );										// 指定行に新規行追加

			let newId = id_array[ 0 ] + '_' + id_array[ 1 ] + '_' + ( content_info[ 1 ] + 1 );
			let add   = addNewContent( newRow, newId );									// 新規行へのｺﾝﾃﾝﾂ追加

			setEditBtn( add, newId );													// 編集ｾﾙへの編集ﾎﾞﾀﾝ配置
		}
		/*************************/
		/* 指定ﾃｰﾌﾞﾙへのﾍｯﾀﾞ追加 */
		/*************************/
		function addNewHeader( table, tbl_id )
		{
			let count = 0;
			let row;
			row    = table.insertRow( count++ );										// 先頭に新規行追加
			row.id = 'Id_Row_Event?' + tbl_id;
			row.classList.add( 'event-row' );											// 行のｸﾗｽをｾｯﾄ

			let editable   = document.getElementById('Id_Editable').checked;			// 編集可否取得
			let event      = CreateCell( row, 'Id_Cell_Event?'  + tbl_id,editable );	// ｲﾍﾞﾝﾄ名ｾﾙの生成と追加
			let member     = CreateCell( row, 'Id_Cell_Member?' + tbl_id,editable );	// ﾒﾝﾊﾞｰｾﾙの生成と追加
			let logo       = CreateCell( row, 'Id_Cell_Logo?'   + tbl_id,editable );	// ﾛｺﾞ表示ｾﾙの生成と追加
			event.colSpan  = 2;															// 列の結合
			member.colSpan = 1;
			logo.colSpan   = 2;

			event.innerText = 'Empty table';

			row = table.insertRow( count++ );											// 2段目に新規行追加
			row.id = 'Id_Row_Title?' + tbl_id;
			row.classList.add( 'title-row' );											// 行のｸﾗｽをｾｯﾄ
			let date_cell           = row.insertCell();
			let contents_cell       = row.insertCell();
			let time_cell           = row.insertCell();
			let details_cell        = row.insertCell();
			let edit_cell           = row.insertCell();

			date_cell.innerText     = 'Date';											// ｾﾙのﾃｷｽﾄをｾｯﾄ
			contents_cell.innerText = 'Contents';
			time_cell.innerText     = 'Time & Place';
			details_cell.innerText  = 'Details';
			edit_cell.innerText     = 'Edit';

			date_cell.classList.add(     'date-col'    );								// ｾﾙのｸﾗｽをｾｯﾄ
			contents_cell.classList.add( 'contens-col' );
			time_cell.classList.add(     'time-col'    );
			details_cell.classList.add(  'details-col' );
			edit_cell.classList.add(     'edit-col'    );

			//  ﾃｰﾌﾞﾙ編集のﾎﾞﾀﾝ生成
			let btnDel = createBtn( 'Del table', 'Id_Btn_DelTable?' + tbl_id );
			let btnIns = createBtn( 'Ins table', 'Id_Btn_InsTable?' + tbl_id );
			btnDel.classList.add(   'edit-btn' );										// ｸﾗｽ名ｾｯﾄ
			btnIns.classList.add(   'edit-btn' );

			// ﾃｰﾌﾞﾙ編集のﾎﾞﾀﾝ追加
			event.appendChild( document.createElement( "br" ));							// ｾﾙに改行を追加
			event.appendChild( btnDel );												// ｾﾙに削除ﾎﾞﾀﾝ追加
			event.appendChild( btnIns );												// ｾﾙに挿入ﾎﾞﾀﾝ追加

			// ﾛｺﾞﾌｧｲﾙ名格納ｴﾘｱ生成(非表示)
			let logofile           = document.createElement( "p" );
			logofile.id            = 'Id_Cell_LogoFile?' + tbl_id;
			logofile.style.display = 'none';
			logo.appendChild( logofile );												// ﾛｺﾞ表示ｾﾙにﾛｺﾞﾌｧｲﾙ要素追加
			// 背景名格納ｴﾘｱ生成(非表示)
			let bk_name            = document.createElement( "p" );
			bk_name.id             = 'Id_Cell_BkGround?' + tbl_id;
			bk_name.style.display  = 'none';
			bk_name.innerText      = 'Default';
			logo.appendChild( bk_name );												// ﾛｺﾞ表示ｾﾙに背景名要素追加

			event.onblur   = cellBlur;
			member.onblur  = cellBlur;
			member.onfocus = cellFocus;
			logo.onblur    = cellBlur;
			logo.onfocus   = cellFocus;

			return count;																// 行数を戻す
		}
		/*************************/
		/* 指定行への日付行追加  */
		/*************************/
		// row       ：指定行
		// date_id   ：日付ID ID番 IDは Id_Cell_Date?0_0 など文字列部とID番号(0_0)で構成される
		// content_id：ｺﾝﾃﾝﾂID
		function addNewDate( row, date_id, content_id )
		{
			let editable = document.getElementById('Id_Editable').checked;				// 編集可否取得
			let date     = CreateCell( row, 'Id_Cell_Date?' + date_id, editable );		// 日付ｾﾙの生成と追加
			let edit     = addNewContent( row, content_id );

			setDateBtn( date, date_id    );												// 日付ｾﾙへの編集ﾎﾞﾀﾝ配置
			setEditBtn( edit, content_id );												// 編集ｾﾙへの編集ﾎﾞﾀﾝ配置
		}
		/*************************/
		/*  指定行へのｺﾝﾃﾝﾂ追加  */
		/*************************/
		// row  ：指定行
		// idNum：ID番号 IDは Id_Cell_Event?0_0_0 など文字列部とID番号(0_0_0)で構成される
		function addNewContent( row, idNum )
		{
			let editable = document.getElementById( 'Id_Editable' ).checked;			// 編集可否取得

			CreateCell( row, 'Id_Cell_ContentsName?'+idNum, editable, null, null );		// ｺﾝﾃﾝﾂ名ｾﾙの生成と追加
			let time        = CreateCell( row, 'Id_Cell_Time?'   +idNum,editable );		// 時間ｾﾙの生成と追加
			let details     = CreateCell( row, 'Id_Cell_Details?'+idNum,editable );		// 詳細ｾﾙの生成と追加
			time.onblur     = cellBlur;
			time.onfocus    = cellFocus;
			details.onblur  = cellBlur;
			details.onfocus = cellFocus;

			return CreateCell( row, 'Id_Cell_Edit?'  + idNum, "false"  );				// 編集ｾﾙの生成と追加し編集ｾﾙを戻す
		}
		/*************************/
		/*日付ｾﾙへの編集ﾎﾞﾀﾝ配置 */
		/*************************/
		// 日付ｾﾙに編集ﾎﾞﾀﾝを配置して戻す
		// cell ：対象ｾﾙ
		// idNum：ｾﾙID番号
		function setDateBtn( cell, idNum )
		{
			//  日付行編集のﾎﾞﾀﾝ生成
			let btnDel = createBtn( 'Del date', 'Id_Btn_DelDate?' + idNum );
			let btnIns = createBtn( 'Ins date', 'Id_Btn_InsDate?' + idNum );
			btnDel.classList.add( 'edit-btn' );											// ｸﾗｽ名ｾｯﾄ
			btnIns.classList.add( 'edit-btn' );

			// 日付行編集のﾎﾞﾀﾝ追加
			cell.appendChild( document.createElement( "br" ));							// 改行を追加
			cell.appendChild( btnDel );													// 削除ﾎﾞﾀﾝ追加
			cell.appendChild( document.createElement( "br" ));							// 改行を追加
			cell.appendChild( btnIns );													// 挿入ﾎﾞﾀﾝ追加
		}
		/*************************/
		/*  ｾﾙへの編集ﾎﾞﾀﾝ配置   */
		/*************************/
		// 対象ｾﾙに編集ﾎﾞﾀﾝを配置して戻す
		// cell ：対象ｾﾙ
		// idNum：ｾﾙID番号
		function setEditBtn( cell, idNum )
		{
			cell.align = 'center';														// ｱﾗｲﾒﾝﾄｾｯﾄ

			// 編集ﾎﾞﾀﾝ生成
			let btnDel = createBtn( 'Del row', 'Id_Btn_DelRow?' + idNum );
			let btnIns = createBtn( 'Ins row', 'Id_Btn_InsRow?' + idNum );
			btnDel.classList.add( 'edit-btn' );											// ｸﾗｽ名ｾｯﾄ
			btnIns.classList.add( 'edit-btn' );

			// ｾﾙへの編集ﾎﾞﾀﾝ追加
			cell.appendChild( btnDel );													// 削除ﾎﾞﾀﾝ追加
			cell.appendChild( document.createElement( "br" ));							// 改行を追加
			cell.appendChild( btnIns );													// 挿入ﾎﾞﾀﾝ追加
		}
		/*************************/
		/*     ﾃｰﾌﾞﾙﾃﾞｰﾀ取得     */
		/*************************/
		function getTableData()
		{
			let tables  = new Object();
			let data    = new Array();
			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( index = 1; index < element.childElementCount; index++ )
			{
				data.push( getTable( element.options[ index ].value ));					// ﾃｰﾌﾞﾙIDを指定してﾃﾞｰﾀ取得
			}
			tables[ 'Data' ] = data;
			return tables;
		}
		// 以下のJSON形式になるようにﾃﾞｰﾀを取得して戻す
		// "Data":
		// [
		// 	{
		// 		"Event"		:"",							← Objectで生成
		// 		"Member"	:"",							← Objectで生成(改行で複数ｾｯﾄ可)
		//		"Logo"		:"",							← Objectで生成(改行で複数ｾｯﾄ可)
		// 		"Date"		:								← Objectで生成し配列をｾｯﾄする
		// 		[
		// 			{
		// 				"Name"				:"",			← Objectで生成
		// 				"Contents"			:				← Objectで生成し配列をｾｯﾄする
		// 				[
		// 					{
		// 						"Name"		:"",			← Objectで生成
		// 						"Time"		:"",			← Objectで生成
		// 						"Details"	:""				← Objectで生成
		// 					},
		// 					{
		// 						"Name"		:"",
		// 						"Time"		:"",
		// 						"Details"	:""
		// 					}
		// 				]
		// 			},
		// 			{
		// 				"Name"				:"11/7(木)",
		// 				"Contents"			:
		// 				[
		// 					{
		// 						"Name"		:"",
		// 						"Time"		:"",
		// 						"Details"	:""
		// 					}
		// 				]
		// 			}
		// 		]
		// 	},
		// 	{
		// 		"Event"		:"",
		// 		"Member"	:"",
		//		"Logo"		:"",
		// 		"Date"		:
		// 		[
		// 			{
		// 				"Name"				:"",
		// 				"Contents"			:
		// 				[
		// 					{
		// 						"Name"		:"",
		// 						"Time"		:"",
		// 						"Details"	:""
		// 					},
		// 					{
		// 						"Name"		:"",
		// 						"Time"		:"",
		// 						"Details"	:""
		// 					}
		// 				]
		// 			},
		// 			{
		// 				"Name"				:"11/7(木)",
		// 				"Contents"			:
		// 				[
		// 					{
		// 						"Name"		:"",
		// 						"Time"		:"",
		// 						"Details"	:""
		// 					}
		// 				]
		// 			}
		// 		]
		// 	}
		// ]
		function getTable( id )
		{
			let table = document.getElementById( id );

			let date_count = 0;
			let table_item = new Object();
			let date_item;
			let date_array = new Array();
			let contents_item;
			let contents_array;

			for( let row of table.rows )
			{
				for( let cell of row.cells )
				{
					let id_header = cell.id.split( '?' );								// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離
					let str       = removeLastLf( cell.innerText );
					switch( id_header[ 0 ] )
					{
						case "Id_Cell_Event":
							table_item[ 'Event' ] = str;
							break;
						case "Id_Cell_Member":
							table_item[ 'Member' ] = str;
							break;
						case "Id_Cell_Logo":
							let fileName = '';
							for( let index = 0; index < cell.childNodes.length; index++ )
							{
								if( cell.childNodes[ index ].tagName === 'IMG' )
								{
									fileName += cell.childNodes[ index ].id;			// IDはﾛｺﾞﾌｧｲﾙ名
									if( index !== cell.childNodes.length - 1 )
									{
										fileName += '\n';
									}
								}
								if( cell.childNodes[ index ].id.indexOf( 'Id_Cell_BkGround' ) >= 0 )
								{
									table_item[ 'BkGround' ] = cell.childNodes[ index ].innerText;
								}
							}
							table_item[ 'Logo' ] = fileName;
							break;
						case "Id_Cell_Date":
							if( date_count !== 0 )
							{
								date_item[ 'Contents' ] = contents_array;
								date_array.push( date_item );
							}
							date_count++;
							date_item           = new Object();
							date_item[ 'Name' ] = str;
							contents_item  = new Object();
							contents_array = new Array();
							break;
						case "Id_Cell_ContentsName":
							contents_item[ 'Name' ] = str;
							break;
						case "Id_Cell_Time":
							contents_item[ 'Time' ] = str;
							break;
						case "Id_Cell_Details":
							contents_item[ 'Details' ] = str;
							contents_array.push( contents_item );
							contents_item = new Object();
							break;
						default:
							break;
					}
				}
			}
			date_item[ 'Contents' ] = contents_array;
			date_array.push( date_item );
			table_item[ 'Date' ] = date_array;

			return table_item;
		}
		// 文字列の末尾が改行なら削除
		// ｾﾙ内にﾎﾞﾀﾝを配置しているｹｰｽで、改行を入れているため末尾の改行を削除する
		// ﾎﾞﾀﾝの無いｾﾙの文字列の改行も削除されるが、末尾だけなので問題はないはず
		function removeLastLf( str )
		{
			while( str.substr( -1 ) === '\n' )
			{
				str = str.slice( 0, -1 );
			}
			return str;
		}
		/*************************/
		/*     ﾃｰﾌﾞﾙ情報取得     */
		/*************************/
		// [ ﾃｰﾌﾞﾙ数、ﾃｰﾌﾞﾙID最大、ﾃｰﾌﾞﾙﾘｽﾄ挿入位置 ] を戻す。ｴﾗｰなら-1を戻す
		// Id_Cell_ContentsName?i_j_k とすると
		// tbl_id：i ﾃｰﾌﾞﾙID
		function getTableInfo( tbl_id )
		{
			let id_max     = -1;														// ﾃｰﾌﾞﾙIDの最大値
			let ins_index  = -1;														// 挿入ｲﾝﾃﾞｯｸｽ

			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( let index = 1; index < element.length; index++ )
			{
				let id = element.options[ index ].value;
				let id_header = id.split( '?' );										// Id_Table?0 などの文字列部とID番号(0)を分離
				let id_array  = id_header[ 1 ].split( '_' );							// ﾃｰﾌﾞﾙID

				if( Number( id_array[ 0 ] ) > id_max )
				{
					id_max = Number( id_array[ 0 ] );									// ID最大値を取得
				}
				if( Number( id_array[ 0 ] ) === Number( tbl_id ))
				{
					ins_index = index + 1;
				}
			}
			return [ element.length - 1, id_max, ins_index ];							// [ ﾃｰﾌﾞﾙ数、ﾃｰﾌﾞﾙID最大、ﾃｰﾌﾞﾙﾘｽﾄ挿入位置 ] を戻す
		}
		/*************************/
		/*    日付行情報取得     */
		/*************************/
		// [ 日付行数、日付ID最大、全日付IDの番号部分の配列 ] を戻す。ｴﾗｰなら-1を戻す
		// Id_Cell_ContentsName?i_j_k とすると
		// tbl_id：i ﾃｰﾌﾞﾙID
		function getDateInfo( tbl_id )
		{
			let table       = document.getElementById( 'Id_Table?' + tbl_id );		// ﾁｪｯｸ対象のﾃｰﾌﾞﾙ取得
			let date_count  = 0;														// ﾁｪｯｸ対象の日付行数
			let id_max      = -1;														// ﾁｪｯｸ対象の日付IDの最大値
			let date_id_num = new Array();												// ﾁｪｯｸ対象の全日付行IDの番号部分

			for( let row of table.rows )
			{
				for( let cell of row.cells )
				{
					let id_header = cell.id.split( '?' );								// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離
					switch( id_header[ 0 ] )
					{
						case "Id_Cell_Date":											// 日付ｾﾙの場合
							date_count++;
							date_id_num.push( id_header[ 1 ] );							// ﾁｪｯｸ対象の全日付行IDの番号部分を取得

							let con = id_header[ 1 ].split( '_' );
							if( con[ 1 ] > id_max )
							{
								id_max = con[ 1 ];										// ID最大値を取得
							}
							break;
						default:
							break;
					}
				}
			}
			return [ date_count, Number( id_max ), date_id_num ];						// [ 日付行数、日付ID最大、全日付IDの番号部分の配列 ] を戻す
		}
		/*************************/
		/*    ｺﾝﾃﾝﾂ行情報取得    */
		/*************************/
		//
		// ﾃｰﾌﾞﾙ番号 i
		//  __________________________________________________________________ 
		//  |                    |                            |               |
		//  |       Event        |                 Member     |     Logo      |
		//  |____________________|____________________________|_______________|
		//  |         |          |               |            |               |
		//  |   Date  | Contents |  Time & Place |  Details   |     Edit      |
		//  |_________|__________|_______________|____________|_______________|
		//  |         |          |               |            |               |↑
		//  |         |    ①    |               |            |               |｜
		//  |         |__________|_______________|____________|_______________|｜
		//  |         |          |               |            |               |｜
		//  |   3/4   |    ②    |               |            |               |｜ ｺﾝﾃﾝﾂ行数 content_count = 3
		//  |         |__________|_______________|____________|_______________|｜
		//  |   id    |          |               |            |               |｜
		//  |         |    ③    |               |            |               |｜
		//  |_________|__________|_______________|____________|_______________|↓
		//  |         |          |               |            |               |↑
		//  |   3/5   |    ④    |               |            |               |｜
		//  |         |__________|_______________|____________|_______________|｜ ｺﾝﾃﾝﾂ行数 content_count = 2
		//  |         |          |               |            |               |｜
		//  |   id    |    ⑤    |               |            |               |｜
		//  |_________|__________|_______________|____________|_______________|↓
		//
		// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を戻す。ｴﾗｰなら-1を戻す
		//
		// ①のID Id_Cell_ContentsName?i_0_0
		// ②のID Id_Cell_ContentsName?i_0_1
		// ③のID Id_Cell_ContentsName?i_0_2
		// ④のID Id_Cell_ContentsName?i_1_0
		// ⑤のID Id_Cell_ContentsName?i_1_1
		//
		// Time & Place は Id_Cell_Time?    がIDのﾍｯﾀﾞ
		// Details      は Id_Cell_Details? がIDのﾍｯﾀﾞ
		//
		// Id_Cell_ContentsName?i_j_k とすると
		// tbl_id ：i ﾃｰﾌﾞﾙID
		// date_id：j 日付ID
		function getContentsInfo( tbl_id, date_id )
		{
			let table         = document.getElementById( 'Id_Table?' + tbl_id );		// ﾁｪｯｸ対象のﾃｰﾌﾞﾙ取得
			let id            = 'Id_Cell_Date?' + tbl_id + '_' + date_id;				// ﾁｪｯｸ対象の日付ｾﾙID取得
			let check         = false;													// ﾁｪｯｸ対象の日付ｾﾙID取得ﾌﾗｸﾞ
			let content_count = 0;														// ﾁｪｯｸ対象のｺﾝﾃﾝﾂ行数
			let id_max        = -1;														// ﾁｪｯｸ対象のｺﾝﾃﾝﾂIDの最大値
			let detail_id_num = new Array();											// ﾁｪｯｸ対象の全ｺﾝﾃﾝﾂ行IDの番号部分
			let data_index    = -1;														// ﾁｪｯｸ対象の日付ｾﾙの行ｲﾝﾃﾞｯｸｽ

			for( let row_index = 0; row_index < table.rows.length; row_index++ )
			{
				for( let index = 0; index < table.rows[ row_index ].cells.length; index++ )
				{
					let id_header = table.rows[row_index].cells[index].id.split('?');	// Id_Cell_Event?0_0_0 などの文字列部とID番号(0_0_0)を分離
					switch( id_header[ 0 ] )
					{
						case "Id_Cell_Date":											// 日付ｾﾙの場合
							if( check === false )
							{
								if( id === table.rows[ row_index ].cells[ index ].id )	// ﾁｪｯｸ対象の日付ｾﾙ検出
								{
									check      = true;
									data_index = row_index;
								}
							}
							else														// ﾁｪｯｸ対象の日付ｾﾙ検出中で新しい日付ｾﾙ検出
							{
								return [ content_count, Number( id_max ), detail_id_num, data_index ];	// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を戻す
							}
							break;
						case "Id_Cell_Details":											// Details検出でｺﾝﾃﾝﾂ検出完とする
							if( check === true )
							{
								content_count++;
								detail_id_num.push( id_header[ 1 ] );					// ﾁｪｯｸ対象の全ｺﾝﾃﾝﾂ行IDの番号部分を取得

								let con = id_header[ 1 ].split( '_' );
								if( con[ 2 ] > id_max )
								{
									id_max = con[ 2 ];									// ID最大値を取得
								}
							}
							break;
						default:
							break;
					}
				}
			}
			if( check === true )
			{
				return [ content_count, Number( id_max ), detail_id_num, data_index ];	// [ ｺﾝﾃﾝﾂ行数、ｺﾝﾃﾝﾂID最大、全ｺﾝﾃﾝﾂIDの番号部分の配列、日付ｾﾙの行ｲﾝﾃﾞｯｸｽ ] を戻す
			}
			return [ -1, -1, -1 ];
		}
		/*************************/
		/*     背景情報取得     */
		/*************************/
		// [ 全背景設定ﾃｰﾌﾞﾙのID番号配列、全背景名の配列 ] を戻す。ｴﾗｰなら-1を戻す
		function getBkGroundInfo( erase_flag )
		{
			let bk_ground_idNum = new Array();											// 全背景設定ﾃｰﾌﾞﾙのID番号配列
			let bk_ground_Name  = new Array();											// 全背景名の配列

			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( let index = 1; index < element.length; index++ )
			{
				let id        = element.options[ index ].value;
				let id_header = id.split( '?' );										// Id_Table?0 などの文字列部とID番号(0)を分離

				let cell = document.getElementById( 'Id_Cell_BkGround?' + id_header[ 1 ] );
				let name = cell.innerText;												// 背景名取得
				if( erase_flag === true )												// ｾﾙの内容は、以降無用なので消去
				{
					cell.innerText = '';
				}
				if( name !== '' )
				{
					bk_ground_idNum.push( id_header[ 1 ] );
					bk_ground_Name.push( name );
				}
			}
			return [ bk_ground_idNum, bk_ground_Name ];								// [ 全背景設定ﾃｰﾌﾞﾙのID番号配列、全背景名の配列 ] を戻す
		}
		/*************************/
		/*      ﾛｺﾞ情報取得      */
		/*************************/
		// [ 全ﾛｺﾞ表示ｾﾙのID配列、全ﾛｺﾞﾌｧｲﾙ名の配列 ] を戻す。ｴﾗｰなら-1を戻す
		function getLogoInfo( erase_flag )
		{
			let logo_id       = new Array();											// 全ﾛｺﾞ表示ｾﾙのID配列
			let logo_fileName = new Array();											// 全ﾛｺﾞﾌｧｲﾙ名の配列

			let element = document.getElementById( 'Id_Sel_TblList' );					// ﾃｰﾌﾞﾙﾘｽﾄｾﾚｸﾄﾎﾞｯｸｽ取得
			for( let index = 1; index < element.length; index++ )
			{
				let id        = element.options[ index ].value;
				let id_header = id.split( '?' );										// Id_Table?0 などの文字列部とID番号(0)を分離

				let cell = document.getElementById( 'Id_Cell_LogoFile?' + id_header[ 1 ] );
				let file = cell.innerText.split( '\n' );								// 1ｾﾙ分のﾌｧｲﾙ名配列
				if( erase_flag === true )												// ｾﾙの内容は、以降無用なので消去
				{
					cell.innerText = '';
				}

				for( let file_index = 0; file_index < file.length; file_index++ )
				{
					if( file[ file_index ] !== '' )
					{
						logo_id.push( 'Id_Cell_Logo?' + id_header[ 1 ] );
						logo_fileName.push( file[ file_index ] );
					}
				}
			}
			return [ logo_id, logo_fileName ];											// [ 全ﾃｰﾌﾞﾙIDの番号部分の配列、全ﾛｺﾞﾌｧｲﾙ名の配列 ] を戻す
		}
	</script>
</body>
</html>

<?php
/************************************************************************************************/
/*                                                                                              */
/*                                                                                              */
/*                                           php定義                                            */
/*                                                                                              */
/*                                                                                              */
/************************************************************************************************/
/*************************/
/*   ﾃｰﾌﾞﾙ操作ﾎﾞﾀﾝ生成   */
/*************************/
function createMenuBtn()
{
	if( isset( $_GET[ 'edit' ] ))														// 編集可
	{
		// &nbsp は特殊文字のｽﾍﾟｰｽ
		echo '<label>';
		echo '<input type="checkbox" id="Id_Editable"  onchange ="chkBoxChanged(this.id)" checked>Administrator&nbsp&nbsp&nbsp&nbsp</label>';
		echo '<label>';
		echo '<input type="checkbox" id="Id_Template"  onchange ="chkBoxChanged(this.id)">Template select&nbsp&nbsp&nbsp&nbsp</label>';

		echo '<input type="button"   id="Id_Reload"    onmousedown="mouseDn(event)" value="Reload"     style="width:100px">';
		echo '<input type="button"   id="Id_Save"      onmousedown="mouseDn(event)" value="Save"       style="width:100px">';
		echo '<input type="button"   id="Id_ResetDemo" onmousedown="mouseDn(event)" value="Reset Demo" style="width:100px">';

		// ﾛｸﾞｱｳﾄでﾍﾟｰｼﾞ遷移させてﾛｸﾞｲﾝ画面表示をさせるのに、href を使う(ｻｰﾊﾞｰへfetchなどで送信してもﾍﾟｰｼﾞ遷移はしない)
		echo '<input type="button"   id="Id_Logout"    onclick="location.href=' .  "'index.php?logout'" . '" value="Logout" style="width:100px;float:right">';
	}
	else
	{
		// &nbsp は特殊文字のｽﾍﾟｰｽ
		echo '<label>';
		echo '<input type="checkbox" id="Id_Editable"  onchange ="chkBoxChanged(this.id)">Administrator&nbsp&nbsp&nbsp&nbsp</label>';

		// ﾛｸﾞｱｳﾄでﾍﾟｰｼﾞ遷移させてﾛｸﾞｲﾝ画面表示をさせるのに、href を使う(ｻｰﾊﾞｰへfetchなどで送信してもﾍﾟｰｼﾞ遷移はしない)
		echo '<input type="button"   id="Id_Logout"    onclick="location.href=' .  "'index.php?logout'" . '" value="Logout" style="width:100px;float:right">';
	}
}
/*************************/
/*     ﾃｰﾌﾞﾙﾘｽﾄ生成      */
/*************************/
// ｾﾚｸﾄﾎﾞｯｸｽの value はﾃｰﾌﾞﾙの ID とする
// ﾃｰﾌﾞﾙの ID はﾃﾞｰﾀ順として createTable でｾｯﾄされている
function createTableList( $file )
{
	$scheduleData = json_decode( file_get_contents( $file ));							// ﾃﾞｰﾀ読込み

	echo 'Schedule List　';
	echo '<select id="Id_Sel_TblList" onchange="selectBoxChanged(event)"' . '>';
	echo '<option value="' . count( $scheduleData->Data ) . '" selected>All</option>';	// 最初に「全て」を追加し、これをﾃﾞﾌｫﾙﾄ選択状態とする
	for( $tbl_id = 0; $tbl_id < count( $scheduleData->Data ); $tbl_id++ )				// ﾃﾞｰﾀ順のIDをｾｯﾄ
	{
		$str = $scheduleData->Data[ $tbl_id ]->Event;
		echo '<option value="Id_Table?' . $tbl_id . '">' . $str . '</option>';
	}
	echo '</select>';
	echo '<br id="Id_Sel_TblList_br">';													// 改行出力
}
/*************************/
/* ﾌｧｲﾙ読込みとﾃｰﾌﾞﾙ生成 */
/*************************/
// tr、tdの位置関係
//      ____________________________________________________________________________________________________
//      |                                   |                                          |                    |
// <tr> |<td>          Event           </td>|<td>               Member            </td>|<td>    Logo   </td>| </tr>
//      |___________________________________|__________________________________________|____________________|
//      |               |                   |                       |                  |                    |
// <tr> |<td> Date </td>|<td> Contents </td>|<td> Time & Place </td>|<td> Details </td>|<td>    Edit   </td>|</tr>
//      |_______________|___________________|_______________________|__________________|____________________|
//      |               |                   |                       |                  |                    |
// <tr> |<td> 日付 </td>|<td>          </td>|<td>              </td>|<td>         </td>|<td>      </td></tr>|
//      |               |___________________|_______________________|__________________|____________________|
//      |               |                   |                       |                  |                    |
//      |               |<tr><td>      </td>|<tr><td>          </td>|<tr><td>     </td>|<tr><td>  </td></tr>|
//      |               |___________________|_______________________|__________________|____________________|
//      |               |                   |                       |                  |                    |
//      |               |<tr><td>      </td>|<tr><td>          </td>|<tr><td>     </td>|<tr><td>  </td></tr>|
//      |_______________|___________________|_______________________|__________________|____________________|
//
function createTable( $file )
{
	$editable = 'false';
	if( isset( $_GET[ 'edit' ] ))														// 編集可
	{
		$editable = 'true';
	}

	$scheduleData = json_decode( file_get_contents( $file ));							// ﾃﾞｰﾀ読込み

	for( $tbl_id = 0; $tbl_id < count( $scheduleData->Data ); $tbl_id++ )
	{
		echo '<table id="' . 'Id_Table?' . $tbl_id . '" style="display:block">';		// Id_Table?0 ～ Id_Table?n のﾃｰﾌﾞﾙIDをふる

		// ｲﾍﾞﾝﾄ名の表示
		$str = nl2br( $scheduleData->Data[ $tbl_id ]->Event );							// 改行ｺｰﾄﾞ変換( \n → <br> )
		echo '<tr class="event-row" id="Id_Row_Event?' . $tbl_id . '">';
		echo '<td id="Id_Cell_Event?' . $tbl_id . '" colspan="2" contentEditable="'    . $editable . '" onblur="cellBlur(event)">';
		echo $str . '<br>';																// ｲﾍﾞﾝﾄ名出力

		// ﾃｰﾌﾞﾙ編集の表示(ﾃｰﾌﾞﾙ削除・ﾃｰﾌﾞﾙ挿入ﾎﾞﾀﾝ)
		if( $editable == 'true' )
		{
			echo getBtn( 'Id_Btn_DelTable?', $tbl_id, 'Del table' );
			echo getBtn( 'Id_Btn_InsTable?', $tbl_id, 'Ins table' );
		}
		echo '</td>';

		// ﾒﾝﾊﾞｰの表示
		$str = nl2br( $scheduleData->Data[ $tbl_id ]->Member );							// 改行ｺｰﾄﾞ変換( \n → <br> )
		echo '<td id="Id_Cell_Member?' . $tbl_id . '" colspan="1" contentEditable="'   . $editable . '" onblur="cellBlur(event)" onfocus="cellFocus(event)">';
		echo $str . '</td>';															// ﾒﾝﾊﾞｰ出力
							
		// ﾛｺﾞの表示
		// ﾛｺﾞﾌｧｲﾙ名をｾｯﾄするが、見えなくしている
		$str = nl2br( $scheduleData->Data[ $tbl_id ]->Logo );							// 改行ｺｰﾄﾞ変換( \n → <br> )
		echo '<td id="Id_Cell_Logo?'     . $tbl_id . '" colspan="2" contentEditable="' . $editable . '" onblur="cellBlur(event)" onfocus="cellFocus(event)">';
		echo '<p  id="Id_Cell_LogoFile?' . $tbl_id . '" style="display:none">' . $str . '</p>';
		// 背景名をｾｯﾄするが、見えなくしている
		$str = nl2br( $scheduleData->Data[ $tbl_id ]->BkGround );						// 改行ｺｰﾄﾞ変換( \n → <br> )
		echo '<p  id="Id_Cell_BkGround?' . $tbl_id . '" style="display:none">' . $str . '</p>';
		echo '</td></tr>';

		// ｶﾗﾑﾀｲﾄﾙの表示
		echo '<tr class="title-row" id="Id_Row_Title?' . $tbl_id . '">';
		echo '<td class="date-col"    >Date        </td>';
		echo '<td class="contens-col" >Contents    </td>';
		echo '<td class="time-col"    >Time & Place</td>';
		echo '<td class="details-col" >Details     </td>';
		echo '<td class="edit-col"    >Edit        </td></tr>';

		for( $date = 0; $date < count( $scheduleData->Data[ $tbl_id ]->Date ); $date++ )
		{
			$count = 0;
			for( $contents = 0; $contents < count( $scheduleData->Data[ $tbl_id ]->Date[ $date ]->Contents ); $contents++ )
			{
				$count++;
			}
			$date_id = $tbl_id . '_' . $date;
			// 日付の表示
			$str = nl2br( $scheduleData->Data[ $tbl_id ]->Date[ $date ]->Name );
			echo '<tr><td id="Id_Cell_Date?' . $date_id . '" rowspan=' . $count . ' contentEditable="' . $editable . '">';		// 日付IDをふる
			echo $str . '<br>';																									// 日付出力

			// 日付行編集の表示(日付行削除・日付行挿入ﾎﾞﾀﾝ)
			if( $editable == 'true' )
			{
				echo getBtn( 'Id_Btn_DelDate?', $date_id, 'Del date' ) . '<br>';
				echo getBtn( 'Id_Btn_InsDate?', $date_id, 'Ins date' );
			}
			echo '</td>';

			for( $contents = 0; $contents < count( $scheduleData->Data[ $tbl_id ]->Date[ $date ]->Contents ); $contents++ )
			{
				if( $contents != 0 )
				{
					echo '<tr>';
				}
				$contents_id = $tbl_id . '_' . $date . '_' . $contents;
				// ｺﾝﾃﾝﾂ名の表示
				$str = nl2br( $scheduleData->Data[ $tbl_id ]->Date[ $date ]->Contents[ $contents ]->Name );						// ｺﾝﾃﾝﾂ名のｺﾝﾃﾝﾂIDをふる
				echo '<td id="Id_Cell_ContentsName?' . $contents_id . '" contentEditable="' . $editable . '">';
				echo $str . '</td>';
				// 時間の表示
				$str = nl2br( $scheduleData->Data[ $tbl_id ]->Date[ $date ]->Contents[ $contents ]->Time );						// 時間のｺﾝﾃﾝﾂIDをふる
				echo '<td id="Id_Cell_Time?'         . $contents_id . '" contentEditable="' . $editable . '" onblur="cellBlur(event)" onfocus="cellFocus(event)">';
				echo $str . '</td>';
				// 詳細の表示
				$str = nl2br( $scheduleData->Data[ $tbl_id ]->Date[ $date ]->Contents[ $contents ]->Details );					// 詳細のｺﾝﾃﾝﾂIDをふる
				echo '<td id="Id_Cell_Details?'      . $contents_id . '" contentEditable="' . $editable . '" onblur="cellBlur(event)" onfocus="cellFocus(event)">';
				echo $str . '</td>';
				// ｺﾝﾃﾝﾂ行編集の表示(行削除・行挿入ﾎﾞﾀﾝ)
				if( $editable == 'true' )
				{
					echo '<td align="center" id="Id_Cell_Edit?' . $contents_id . '">';											// 編集のｺﾝﾃﾝﾂIDをふる
					echo getBtn( 'Id_Btn_DelRow?', $contents_id, 'Del row' ) . '<br>';
					echo getBtn( 'Id_Btn_InsRow?', $contents_id, 'Ins row' ) . '<br>';
				}
				else
				{
					echo '<td align="center" id="Id_Cell_Edit?' . $contents_id . '"></td></tr>';
				}
			}
		}
		echo '</table>';
		echo '<br id="' . 'Id_Table_br?' . $tbl_id .'" style="display:block">';													// 改行出力 Id_Table_br?0 ～ Id_Table_br?n のIDをふる
	}
}
function getBtn( $idStr, $idNum, $value )
{
	$str = '<input type="button"'                .' ';
	$str = $str . 'class="edit-btn"'             .' ';
	$str = $str . 'id="' . $idStr . $idNum       . '" ';
	$str = $str . 'onmousedown="mouseDn(event)"' . ' ';
	$str = $str . 'value="' . $value             . '">';
	return  $str;
}
?>
