#ifndef SYSTEM_H
#define SYSTEM_H

#include "iodefine.h"

/* ---< RL78gݍ݊֐ȗ >--- */
#define DI						__DI
#define EI						__EI
#define HALT					__halt
#define NOP						__nop
#define STOP					__stop
#define BRK     				__brk

/* ---< ۯ >--- */
#define FMAIN					( 32000000 )										// ۯ 32MHz

#define NULL    				((void *)0)
/* ---< ^U >--- */
#define BOOL					unsigned char
#define TRUE					(1)													// ^
#define FALSE					(0)													// U

//*************************
//         ޯ
//*************************
#define BIT0					(0x00000001U)
#define BIT1					(0x00000002U)
#define BIT2					(0x00000004U)
#define BIT3					(0x00000008U)
#define BIT4					(0x00000010U)
#define BIT5					(0x00000020U)
#define BIT6					(0x00000040U)
#define BIT7					(0x00000080U)

//*************************
//         UART
//*************************
#define C_SIZE_MESSAGE			1													// үޒ
#define C_SIZE_PARA				20													// Ұő咷
#define C_SIZE_CHKSUM			1													// ђ
#define C_SIZE_COM_FRAME		( C_SIZE_MESSAGE + C_SIZE_PARA + C_SIZE_CHKSUM )	// Mڰт̍ő咷
#define C_SIZE_COM_BUF			( C_SIZE_PARA * 2 )									// Mޯ̧

//*************************
//        ϸے`
//*************************
#define M_RING_INC(a,b)		( ((b)<=(a+1)) ? (a=0) : (a+=1) )
#define M_RING_DEC(a,b)		( (0==a) ? (a=(b)-1) : (a-=1) )

//*************************
//          ^
//*************************
typedef signed char				int8_t;
typedef unsigned char			uint8_t;
typedef signed short			int16_t;
typedef unsigned short			uint16_t;
typedef signed long				int32_t;
typedef unsigned long			uint32_t;
typedef signed long long		int64_t;
typedef unsigned long long		uint64_t;
typedef int32_t					fix32_t;

//*************************
//     ޕϊ
//      ٴި
//*************************
typedef union uint16union
{
	uint16_t		Uint16Data;
	uint8_t			Data[ 2 ];
} UINT16_UNION;

//*************************
//       RLʐMװ
//*************************
typedef enum
{
	enComErr_Non				= 0,												// װȂ
	enComErr_RcvIndexOver,															// Mޯ
	enComErr_RcvChecksum,															// MѴװ
	enComErr_RcvNotStx,																// 擪STXłȂްM
	enComErr_RcvNotEtx,																// ŌオETXłȂްM
	enComErr_RcvNotSupported,														// ΉĺَM
	enComErr_RcvOverrun,															// Mޯ̧ް
	enComErr_SndIndexOver,															// Mޯ
	enComErr_SndAck,																// ACKMװ
	enComErr_SndStx,																// STXMװ
	enComErr_SndFrame,																// ްMװ
	enComErr_SndChecksum,															// ёMװ
	enComErr_SndEtx																	// ETXMװ
} COM_ERROR;

//*************************
//      ނ̾ݻ^
//*************************
typedef enum
{
	enRmbOff				= 0,													// Ӱ
	enRmbPassive,																	// ߯Ӱ
	enRmbSafe,																		// Ӱ
	enRmbFull																		// Ӱ
} RMBMODE;
typedef union BumpsDrop
{
	uint8_t		Data;
	struct
	{
		uint8_t	BumpR		: 1;													// E߰Փ
		uint8_t	BumpL		: 1;													// ߰Փ
		uint8_t	DropR		: 1;													// EE
		uint8_t	DropL		: 1;													// E
		uint8_t	b4			: 1;													//
		uint8_t	b5			: 1;													//
		uint8_t	b6			: 1;													//
		uint8_t	b7			: 1;													//
	} BIT;
} BIT_BUMPDROP;
typedef union WheelOverCur															// ߓd 1:ߓd 0:Ȃ
{
	uint8_t		Data;
	struct
	{
		uint8_t	SideB		: 1;													// ׼
		uint8_t	b1			: 1;													//
		uint8_t	MainB		: 1;													// Ҳ׼
		uint8_t	WheelR		: 1;													// E
		uint8_t	WheelL		: 1;													// 
		uint8_t	b5			: 1;													//
		uint8_t	b6			: 1;													//
		uint8_t	b7			: 1;													//
	} BIT;
} BIT_WHEELOVERCUR;
typedef union Buttons																// ݂̉ 1: 0:Ȃ
{
	uint8_t		Data;
	struct
	{
		uint8_t	Clean		: 1;													// Clean
		uint8_t	Spot		: 1;													// Spot
		uint8_t	Dock		: 1;													// Dock
		uint8_t	Minitue		: 1;													// Minitue
		uint8_t	Hour		: 1;													// Hour
		uint8_t	Day			: 1;													// Day
		uint8_t	Schedule	: 1;													// Schedule
		uint8_t	Clock		: 1;													// Clock
	} BIT;
} BIT_BUTTONS;
typedef union ChargingSrc															// [dؿ 1: & [d 0:ȊO
{
	uint8_t		Data;
	struct
	{
		uint8_t	Inner		: 1;													// [d[d
		uint8_t	Home		: 1;													// ޯ[d[d
		uint8_t	b2			: 1;													//
		uint8_t	b3			: 1;													//
		uint8_t	b4			: 1;													//
		uint8_t	b5			: 1;													//
		uint8_t	b6			: 1;													//
		uint8_t	b7			: 1;													//
	} BIT;
} BIT_CHARGESRC;
typedef union LightBump																// ײ߰o
{
	uint8_t		Data;
	struct
	{
		uint8_t	LightBumpL	: 1;													// ײ߰
		uint8_t	LightBumpFL	: 1;													// Oײ߰
		uint8_t	LightBumpCL	: 1;													// ײ߰
		uint8_t	LightBumpCR	: 1;													// Eײ߰
		uint8_t	LightBumpFR	: 1;													// EOײ߰
		uint8_t	LightBumpR	: 1;													// Eײ߰
		uint8_t	b6			: 1;													//
		uint8_t	b7			: 1;													//
	} BIT;
} BIT_LIGHTBUMP;
typedef struct
{
	int16_t				EncoderLeft;												// Դݺޗݐϒl
	int16_t				EncoderRight;												// EԴݺޗݐϒl
	int16_t				LightBumpLSig;												// ײ߰Mx
	int16_t				LightBumpFLSig;												// Oײ߰Mx
	int16_t				LightBumpCLSig;												// ײ߰Mx
	int16_t				LightBumpCRSig;												// Eײ߰Mx
	int16_t				LightBumpFRSig;												// EOײ߰Mx
	int16_t				LightBumpRSig;												// Eײ߰Mx
	BIT_LIGHTBUMP		LightBumper;												// ײ߰o
} T_MOVE_CNTL;
typedef struct
{
	int16_t				CliffLeftSig;												// RݻMx
	int16_t				CliffFLeftSig;												// ORݻMx
	int16_t				CliffFRightSig;												// EORݻMx
	int16_t				CliffRightSig;												// ERݻMx
	BOOL				CliffLeft;													// RL
	BOOL				CliffFLeft;													// ORL
	BOOL				CliffFRight;												// EORL
	BOOL				CliffRight;													// ERL
	BIT_BUMPDROP		BumpDrop;													// グAE
} T_MOVE_SAFTY;
typedef struct
{
	int16_t				BattVoltage;												// ޯؓd[mV]
	int16_t				BattCurrent;												// ޯذd[mA]
	int16_t				BattTemperature;											// ޯذx[]
	int16_t				BattCharge;													// ݂ޯذ[d[mAh]
	int16_t				BattCapacity;												// ݂ޯذ[de[mAh]
	uint8_t				BattCharging;												// [d
	BIT_CHARGESRC		BattChargingSrc;											// [dؿ
	BIT_WHEELOVERCUR	WheelOverCur;												// ߓd
} T_ELEC_SAFTY;
typedef struct
{
	RMBMODE				OiMode;														// ݂Ӱ
	BIT_BUTTONS			Buttons;													// ݂̉
	uint8_t				IrLeft;														// ԊOʐM
	uint8_t				IrRight;													// EԊOʐM
} T_RMB_OTHERS;
typedef struct
{
	T_MOVE_CNTL			MoveCntl;													// s䍀ڂ̾ݻ
	T_MOVE_SAFTY		MoveSafty;													// sSڂ̾ݻ
	T_ELEC_SAFTY		ElecSafty;													// dCISڂ̾ݻ
	T_RMB_OTHERS		Others;														// ̑ڂ̾ݻ
} T_RMB_DATA;

//*************************
//         UART
//       Mð
//*************************
typedef enum
{
	enComState_RcvStandby		= 0,												// ҋ@
	enComState_RcvStx,																// STXM
	enComState_Rcv,																	// ްM
	enComState_RmbHeader,															// ͯް҂
	enComState_RmbCount,															// ް҂
	enComState_RmbPacketId,															// ߹ID҂
	enComState_RmbData,																// ްM
	enComState_RmbChecksum															// ё҂
} COM_RCV_STATE;

//*************************
//         UART
//       Mð
//*************************
typedef enum
{
	enComStatus_RcvNon			= 0,												// MްȂ
	enComStatus_RcvAck,																// ACKM
	enComStatus_RcvNack,															// NAKM
	enComStatus_RcvStx,																// STXM
	enComStatus_RcvDat,																// ްM
	enComStatus_RcvEtx,																// ڰюM
	enComStatus_RcvNotStx,															// 擪STXłȂްM
	enComStatus_RcvNotEtx,															// ŌオETXłȂްM
	enComStatus_RcvErr,																// װ
	enComStatus_RcvNotSupported,													// Ήĺ
	enComStatus_RcvRmbCount,														// ް҂
	enComStatus_RcvRmbPacketId,														// ߹ID҂
	enComStatus_RcvRmbData,															// ްM
	enComStatus_RcvRmbChecksum,														// ё҂
	enComStatus_RcvRmbPacketEnd,													// S߹ĎM
	enComStatus_RcvRmbErr															// װ
} COM_RCV_STATUS;

//*************************
//         UART
//     رّM
//*************************
typedef struct
{
	uint8_t			Message;														// Mү
	int16_t			RcvMessageLen;													// Mүޒ
	int16_t			SndMessageLen;													// Mүޒ
} T_MES_TBL;

//*************************
//         UART
//   OMڰ
//*************************
typedef struct
{
	uint16_t		Count;															// M޲Đ
	uint8_t			Data[ C_SIZE_COM_FRAME ];										// Mް
} T_COM_FRAME;

//*************************
//         UART
//   Mޯ̧
//*************************
typedef struct
{
	uint16_t		WriteIdx;														// ݲޯ						*/
	uint16_t		ReadIdx;														// Ǎݲޯ						*/
	uint8_t			Buf[ C_SIZE_COM_BUF ];											// ޯ̧								*/
} T_COM_BUFFER;

void Sys_InitReg( void );

#endif
