#ifndef COMRMB_H
#define COMRMB_H

#include "Utility.h"

//*************************
//     RL-78M
//   Opcode(ڰݺ)
//*************************
typedef enum
{
	/* {ү */
	enOpCode_Start				= 128,					// ĺ
	enOpCode_Reset				= 7,					// ؾĺ
	enOpCode_Stop				= 173,					// įߺ
	enOpCode_Baud				= 129,					// ްڰĺ
	enOpCode_Safe				= 131,					// SafeӰ޺
	enOpCode_Full				= 132,					// FullӰ޺

	/* ذݸ޺ү */
	enOpCode_Clean				= 135,					// ذݺ
	enOpCode_Max				= 136,					// ϯ
	enOpCode_Spot				= 134,					// ߯ĺ
	enOpCode_Dock				= 143,					// ޯ
	enOpCode_PowerOff			= 133,					// ܰ
	enOpCode_Schedule			= 167,					// ޭٺ
	enOpCode_Clock				= 168,					// ĺ

	/* ү */
	enOpCode_Drive				= 137,					// ײ޺
	enOpCode_DriveDirect		= 145,					// ײ޲ڸĺ
	enOpCode_DrivePWM			= 146,					// ײPWM
	enOpCode_Mot				= 138, 					// Ӱ
	enOpCode_MotPWM				= 144,					// PWMӰ
	enOpCode_Led				= 139,					// LED
	enOpCode_LedScheduling		= 162,					// LEDޭݸLED
	enOpCode_LedDigit			= 163,					// LED޼ޯĺ
	enOpCode_LedButton			= 165,					// LEDݺ
	enOpCode_LedAscii			= 164,					// LED
	enOpCode_Song				= 140,					// ݸ޺
	enOpCode_Play				= 141,					// ڲ

	/* ߯ĺү */
	enOpCode_Sensor				= 142,					// ݻ
	enOpCode_Quely				= 149,					// ذؽĺ
	enOpCode_Stream				= 148,					// ذѺ
	enOpCode_PauseResume		= 150,					// Pause/ResumeذѺ
} RMB_OP_CODE;

extern T_RMB_DATA				gRmbData;
extern volatile COM_ERROR		gRmbComError;

void ComRmb_Init( void );
void ComRmb_InitRcvFrame( void );
BOOL ComRmb_CmdStart( void );
BOOL ComRmb_CmdReset( void );
BOOL ComRmb_CmdStop( void );
BOOL ComRmb_CmdSafe( void );
BOOL ComRmb_CmdFull( void );
BOOL ComRmb_CmdDock( void );
BOOL ComRmb_CmdPowerOff( void );
BOOL ComRmb_CmdDrive( int16_t SpeedL_MMPS, int16_t SpeedR_MMPS );
BOOL ComRmb_CmdSensor( void );
COM_RCV_STATUS ComRmb_RcvFrame( void );

#endif


