#include <string.h>
#include <stdlib.h>
#include "ComRmb.h"

#define	_C_CNT_RMB_PACKET_ID	52													// Mүސ
#define _C_CNT_RMB_QUELY		27													// ߹ĸذ
#define _C_CMD_RMB_STREAM		19													// CmdStream(148)ɑ΂鉞

//*************************
//      RL-78ݻv
//    PacketID(߹ID)
//*************************
typedef enum
{
	enPacket_BumpsDrop			= 7,												// Bumps and Wheel Drops
	enPacket_Wall				= 8,												// Wall
	enPacket_CliffLeft			= 9,												// Cliff Left
	enPacket_CliffFLeft			= 10,												// Cliff Front Left
	enPacket_CliffFRight		= 11,												// Cliff Front Right
	enPacket_CliffRight			= 12,												// Cliff Right
	enPacket_VirtualWall		= 13,												// Virtual Wall
	enPacket_WheelOverCur		= 14,												// Wheel Overcurrents
	enPacket_DirtDetect			= 15,												// Dirt Detect
	enPacket_UnusedByte			= 16,												// Unused Byte
	enPacket_InfraredOmni		= 17,												// Infrared Character Omni
	enPacket_InfraredLeft		= 52,												// Infrared Character Left
	enPacket_InfraredRight		= 53,												// Infrared Character Right
	enPacket_Buttons			= 18,												// Buttons
	enPacket_Distance			= 19,												// Distance
	enPacket_Angle				= 20,												// Angle
	enPacket_BattCharging		= 21,												// Charging State
	enPacket_BattVoltage		= 22,												// Battery Voltage
	enPacket_BattCurrent		= 23,												// Battery Current
	enPacket_BattTemperature	= 24,												// Battery Temperature
	enPacket_BattCharge			= 25,												// Battery Charge
	enPacket_BattCapacity		= 26,												// Battery Capacity
	enPacket_WallSig			= 27,												// Wall Signal
	enPacket_CliffLeftSig		= 28,												// Cliff Left Signal
	enPacket_CliffFLeftSig		= 29,												// Cliff Front Left Signal
	enPacket_CliffFRightSig		= 30,												// Cliff Front Right Signal
	enPacket_CliffRightSig		= 31,												// Cliff Right Signal
	enPacket_BattChargingSrc	= 34,												// Charging Sources Available
	enPacket_OiMode				= 35,												// OI Mode
	enPacket_SongNumber			= 36,												// Song Number
	enPacket_SongPlaying		= 37,												// Song Playing
	enPacket_StreamPcks			= 38,												// Number of Stream Packets
	enPacket_ReqVelocity		= 39,												// Requested Velocity
	enPacket_ReqRadius			= 40,												// Requested Radius
	enPacket_ReqRVelocity		= 41,												// Requested Right Velocity
	enPacket_ReqLVelocity		= 42,												// Requested Left Velocity
	enPacket_EncoderLeft		= 43,												// Left Encoder Counts
	enPacket_EncoderRight		= 44,												// Right Encoder Counts
	enPacket_LightBumper		= 45,												// Light Bumper
	enPacket_LightBumpLSig		= 46,												// Light Bump Left Signal
	enPacket_LightBumpFLSig		= 47,												// Light Bump Front Left Signal
	enPacket_LightBumpCLSig		= 48,												// Light Bump Center Left Signal
	enPacket_LightBumpCRSig		= 49,												// Light Bump Center Right Signal
	enPacket_LightBumpFRSig		= 50,												// Light Bump Front Right Signal
	enPacket_LightBumpRSig		= 51,												// Light Bump Right Signal
	enPacket_IrLeft				= 52,												// Infrared Character Left
	enPacket_IrRight			= 53,												// Infrared Character Right
	enPacket_MotCurLeft			= 54,												// Left Motor Current
	enPacket_MotCurRight		= 55,												// Right Motor Current
	enPacket_MotCurMain			= 56,												// Main Brush Motor Current
	enPacket_MotCurSide			= 57,												// Side Brush Motor Current
	enPacket_Stasis				= 58												// Stasis
} RMB_PACKET_ID;

//*************************
//         ϐ
//*************************
static COM_RCV_STATE			_gRcvState      = enComState_RmbHeader;				// OڰюMð
static T_COM_FRAME				_gRcvFrame      = { 0 };							// OMڰ
static uint16_t					_gPacketCount   = 0;								// OM߹Đ

static volatile BOOL			_gSending       = FALSE;							// M׸
static volatile T_COM_BUFFER	_gRcvBuf        = { 0 };							// Mޯ̧
static volatile T_COM_BUFFER	_gSndBuf        = { 0 };							// Mޯ̧

T_RMB_DATA						gRmbData        = { 0 };							// ޾ݻް
volatile COM_ERROR				gRmbComError    = enComErr_Non;						// Mװ

//*************************
//     M`ð
//*************************
// 2޲ĎM [޲][޲] ̏őMĂ
static const T_MES_TBL _gRcvTable[ _C_CNT_RMB_PACKET_ID ] =
{
	// ߹ID					үޒ(߹ID + ް)
	{ enPacket_BumpsDrop,		( 1 + 1 )	},										// Bumps and Wheel Drops
	{ enPacket_Wall,			( 1 + 1 )	},										// Wall(񐄏)
	{ enPacket_CliffLeft,		( 1 + 1 )	},										// Cliff Left
	{ enPacket_CliffFLeft,		( 1 + 1 )	},										// Cliff Front Left
	{ enPacket_CliffFRight,		( 1 + 1 )	},										// Cliff Front Right
	{ enPacket_CliffRight,		( 1 + 1 )	},										// Cliff Right
	{ enPacket_VirtualWall,		( 1 + 1 )	},										// Virtual Wall
	{ enPacket_WheelOverCur,	( 1 + 1 )	},										// Wheel Overcurrents
	{ enPacket_DirtDetect,		( 1 + 1 )	},										// Dirt Detect
	{ enPacket_UnusedByte,		( 1 + 1 )	},										// Unused Byte
	{ enPacket_InfraredOmni,	( 1 + 1 )	},										// Infrared Character Omni
	{ enPacket_InfraredLeft,	( 1 + 1 )	},										// Infrared Character Left
	{ enPacket_InfraredRight,	( 1 + 1 )	},										// Infrared Character Right
	{ enPacket_Buttons,			( 1 + 1 )	},										// Buttons
	{ enPacket_Distance,		( 1 + 2 )	},										// Distance(vްޮ݊mF)
	{ enPacket_Angle,			( 1 + 2 )	},										// Angle(vްޮ݊mF)
	{ enPacket_BattCharging,	( 1 + 1 )	},										// Charging State
	{ enPacket_BattVoltage,		( 1 + 2 )	},										// Battery Voltage
	{ enPacket_BattCurrent,		( 1 + 2 )	},										// Battery Current
	{ enPacket_BattTemperature,	( 1 + 1 )	},										// Battery Temperature
	{ enPacket_BattCharge,		( 1 + 2 )	},										// Battery Charge
	{ enPacket_BattCapacity,	( 1 + 2 )	},										// Battery Capacity
	{ enPacket_WallSig,			( 1 + 2 )	},										// Wall Signal(񐄏)
	{ enPacket_CliffLeftSig,	( 1 + 2 )	},										// Cliff Left Signal
	{ enPacket_CliffFLeftSig,	( 1 + 2 )	},										// Cliff Front Left Signal
	{ enPacket_CliffFRightSig,	( 1 + 2 )	},										// Cliff Front Right Signal
	{ enPacket_CliffRightSig,	( 1 + 2 )	},										// Cliff Right Signal
	{ enPacket_BattChargingSrc,	( 1 + 1 )	},										// Charging Sources Available
	{ enPacket_IrLeft,			( 1 + 1 )	},										// Infrared Character Left
	{ enPacket_IrRight,			( 1 + 1 )	},										// Infrared Character Right
	{ enPacket_OiMode,			( 1 + 1 )	},										// OI Mode
	{ enPacket_SongNumber,		( 1 + 1 )	},										// Song Number
	{ enPacket_SongPlaying,		( 1 + 1 )	},										// Song Playing
	{ enPacket_StreamPcks,		( 1 + 1 )	},										// Number of Stream Packets
	{ enPacket_ReqVelocity,		( 1 + 2 )	},										// Requested Velocity
	{ enPacket_ReqRadius,		( 1 + 2 )	},										// Requested Radius
	{ enPacket_ReqRVelocity,	( 1 + 2 )	},										// Requested Right Velocity
	{ enPacket_ReqLVelocity,	( 1 + 2 )	},										// Requested Left Velocity
	{ enPacket_EncoderLeft,		( 1 + 2 )	},										// Left Encoder Counts
	{ enPacket_EncoderRight,	( 1 + 2 )	},										// Right Encoder Counts
	{ enPacket_LightBumper,		( 1 + 1 )	},										// Light Bumper
	{ enPacket_LightBumpLSig,	( 1 + 2 )	},										// Light Bump Left Signal
	{ enPacket_LightBumpFLSig,	( 1 + 2 )	},										// Light Bump Front Left Signal
	{ enPacket_LightBumpCLSig,	( 1 + 2 )	},										// Light Bump Center Left Signal
	{ enPacket_LightBumpCRSig,	( 1 + 2 )	},										// Light Bump Center Right Signal
	{ enPacket_LightBumpFRSig,	( 1 + 2 )	},										// Light Bump Front Right Signal
	{ enPacket_LightBumpRSig,	( 1 + 2 )	},										// Light Bump Right Signal
	{ enPacket_MotCurLeft,		( 1 + 2 )	},										// Left Motor Current
	{ enPacket_MotCurRight,		( 1 + 2 )	},										// Right Motor Current
	{ enPacket_MotCurMain,		( 1 + 2 )	},										// Main Brush Motor Current
	{ enPacket_MotCurSide,		( 1 + 2 )	},										// Side Brush Motor Current
	{ enPacket_Stasis,			( 1 + 1 )	}										// Stasis
};

//*************************
//     ߹ĸð
//*************************
static const char _gQuely[ _C_CNT_RMB_QUELY ] =
{
	// ؂߹				
	enPacket_EncoderLeft,										// Դݺޗݐϒl
	enPacket_EncoderRight,									// EԴݺޗݐϒl
	enPacket_LightBumpLSig,									// ײ߰Mx
	enPacket_LightBumpFLSig,									// Oײ߰Mx
	enPacket_LightBumpCLSig,									// ײ߰Mx
	enPacket_LightBumpCRSig,									// Eײ߰Mx
	enPacket_LightBumpFRSig,									// EOײ߰Mx
	enPacket_LightBumpRSig,									// Eײ߰Mx

	enPacket_BumpsDrop,										// グAE
	enPacket_CliffLeft,										// RL
	enPacket_CliffFLeft,										// ORL
	enPacket_CliffFRight,										// EORL
	enPacket_CliffRight,										// ERL
	enPacket_CliffLeftSig,									// RݻMx
	enPacket_CliffFLeftSig,									// ORݻMx
	enPacket_CliffFRightSig,									// EORݻMx
	enPacket_CliffRightSig,									// ERݻMx

	enPacket_BattChargingSrc,									// [dؿ
	enPacket_BattVoltage,										// ޯؓd[mV]
	enPacket_BattCurrent,										// ޯذd[mA]
	enPacket_BattTemperature,									// ޯذx[]
	enPacket_BattCharge,										// ݂ޯذ[d[mAh]
	enPacket_BattCapacity,									// ݂ޯذ[de[mAh]

	enPacket_OiMode,											// ݂Ӱ
	enPacket_Buttons,											// ݂̉
	enPacket_IrLeft,											// ԊOʐM
	enPacket_IrRight											// EԊOʐM
};

#pragma interrupt _ComRmb_IntRcv( vect = INTSR0  )
#pragma interrupt _ComRmb_IntSnd( vect = INTST0  )
#pragma interrupt _ComRmb_IntErr( vect = INTSRE0 )

static BOOL _ComRmb_SendCmd( uint8_t Data );
static BOOL _ComRmb_Send( uint8_t* Data, uint16_t Count );
static BOOL _ComRmb_SetByte( uint8_t Data );
static BOOL _ComRmb_SendStart( void );
static BOOL _ComRmb_AnalizePacket( uint8_t PacketId, uint8_t* Data );
static void _ComRmb_Error( COM_ERROR Error );
static void _ComRmb_Start( void );
static void _ComRmb_Stop( void );

//************************************************************************************************
//	@\TvFʐMAAǗϐ̏
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
void ComRmb_Init( void )
{
	_ComRmb_Stop();																	// UART~E݋֎~

	_gRcvState        = enComState_RmbHeader;										// OڰюMð
	_gRcvFrame.Count  = 0;															// OMڰ
	_gPacketCount     = 0;															// OM߹Đ
	_gSending         = FALSE;														// M׸޸ر
	_gRcvBuf.WriteIdx = 0;															// Mޯ̧ ݲޯر
	_gRcvBuf.ReadIdx  = 0;															// Mޯ̧ Ǎݲޯر
	_gSndBuf.WriteIdx = 0;															// Mޯ̧ ݲޯر
	_gSndBuf.ReadIdx  = 0;															// Mޯ̧ Ǎݲޯر
	gRmbComError      = enComErr_Non;												// Mװ

	_ComRmb_Start();																// UARTE݋
}
//************************************************************************************************
//	@\TvFҲ݂Ă ComRmb_RcvFrame ֐̏sBނ̽ذް̎M
//			FƂȂ̴װɑ΂MēƂ
//			F̑Ή͏̎MJnɋN enComErr_RcvIndexOver װւ̑ΉƂĒǉ
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
void ComRmb_InitRcvFrame( void )
{
	_gRcvState       = enComState_RmbHeader;										// OڰюMð
	_gRcvFrame.Count = 0;															// OMڰ
}
//************************************************************************************************
//	@\TvFM֐Q
//		Fe֐Q
//	߂l	FTRUE()AFALSE(װ)
//	l	F
//************************************************************************************************
//*************************
//       ĺ
//*************************
BOOL ComRmb_CmdStart( void )
{
	return _ComRmb_SendCmd( enOpCode_Start );
}
//*************************
//       ؾĺ
//*************************
BOOL ComRmb_CmdReset( void )
{
	return _ComRmb_SendCmd( enOpCode_Reset );
}
//*************************
//      įߺ
//*************************
BOOL ComRmb_CmdStop( void )
{
	return _ComRmb_SendCmd( enOpCode_Stop );
}
//*************************
//     SafeӰ޺
//*************************
BOOL ComRmb_CmdSafe( void )
{
	return _ComRmb_SendCmd( enOpCode_Safe );
}
//*************************
//     FullӰ޺
//*************************
BOOL ComRmb_CmdFull( void )
{
	return _ComRmb_SendCmd( enOpCode_Full );
}
//*************************
//       Dock
//*************************
BOOL ComRmb_CmdDock( void )
{
	return _ComRmb_SendCmd( enOpCode_Dock );
}
//*************************
//   ܰ(d)
//*************************
BOOL ComRmb_CmdPowerOff( void )
{
	return _ComRmb_SendCmd( enOpCode_PowerOff );
}
//*************************
//     
//*************************
// SpeedL_MMPSFԑx[mm/s]
// SpeedR_MMPSFEԑx[mm/s]
BOOL ComRmb_CmdDrive( int16_t SpeedL_MMPS, int16_t SpeedR_MMPS )
{
	uint8_t spdL[ 2 ];																// M޲ė x
	uint8_t spdR[ 2 ];																// M޲ė x
	uint8_t frame[ 5 ];																// Mް

	Utility_GetUint16ToBigByte( SpeedL_MMPS, spdL );								// ޯ޴ިݔz擾
	Utility_GetUint16ToBigByte( SpeedR_MMPS, spdR );

	frame[ 0 ] = enOpCode_DriveDirect;
	frame[ 1 ] = spdR[ 0 ];
	frame[ 2 ] = spdR[ 1 ];
	frame[ 3 ] = spdL[ 0 ];
	frame[ 4 ] = spdL[ 1 ];
	return _ComRmb_Send( frame, 5 );												// M
}
//*************************
//       ݻ
//*************************
// 15msԊuŎI߹ĉ
// \ߌ߂z񂩂w肵߹ėvo
BOOL ComRmb_CmdSensor( void )
{
	uint8_t index;
	uint8_t frame[ _C_CNT_RMB_QUELY + 2 ] = { 0 };							// +߹ėv2޲ĉZ

	/* ---< ޾ >--- */
	frame[ 0 ] = enOpCode_Stream;
	/* ---< w߹Ēo >--- */
	_gPacketCount = 0;
	for( index = 0; index < _C_CNT_RMB_QUELY; index++ )
	{
		frame[ _gPacketCount + 2 ] = _gQuely[ index ];					// Mpڰޯ̧߹ID
		_gPacketCount++;
	}
	/* ---< ߹ėv >--- */
	frame[ 1 ] = _gPacketCount;

	/* ---< w߹Ă̸ؑM >--- */
	return _ComRmb_Send( frame, _gPacketCount + 2 );
}
//************************************************************************************************
//	@\TvFMޯ̧1޲ľĂđM
//		FData Mް
//	߂l	FTRUE()AFALSE(װ)
//	l	F
//************************************************************************************************
static BOOL _ComRmb_SendCmd( uint8_t Data )
{
	uint8_t data[ 1 ] = { Data };
	return _ComRmb_Send( data, 1 );
}
//************************************************************************************************
//	@\TvFMޯ̧֎w޲ľĂđM
//		FData  Mް
//			FCount ް
//	߂l	FTRUE()AFALSE(װ)
//	l	F
//************************************************************************************************
static BOOL _ComRmb_Send( uint8_t* Data, uint16_t Count )
{
	uint16_t index;

	for( index = 0; index < Count; index++ )										// үށEް
	{
		if( FALSE == _ComRmb_SetByte( Data[ index ] ))
		{
			return FALSE;
		}
	}
	return _ComRmb_SendStart();														// ݲޯXVƑM
}
//************************************************************************************************
//	@\TvFMޯ̧1޲ľĂ
//		FData Ăް
//	߂l	FTRUE()AFALSE(װ)
//	l	F
//************************************************************************************************
static BOOL _ComRmb_SetByte( uint8_t Data )
{
	STMK0  = 1U;																	// MϽ

	/* ---< Mޯ̧־ >--- */
	_gSndBuf.Buf[ _gSndBuf.WriteIdx ] = Data;										// ްi[
	M_RING_INC( _gSndBuf.WriteIdx, C_SIZE_COM_BUF );								// ݲޯXV
	if( _gSndBuf.ReadIdx == _gSndBuf.WriteIdx )										// Ǎݲޯɒǂ
	{
		_ComRmb_Error( enComErr_SndIndexOver );										// ͈͒
		return FALSE;
	}

	STMK0  = 0U;																	// M݋
	return TRUE;
}
//************************************************************************************************
//	@\TvFMJn
//		FȂ
//	߂l	FTRUE()AFALSE(װ)
//	l	FM쒆͎őM̂ŋN̕KvȂ
//************************************************************************************************
static BOOL _ComRmb_SendStart( void )
{
	STMK0  = 1U;																	// MϽ

	/* ---< MްȂ̏ꍇ >--- */
	if( _gSending == FALSE )
	{
		_gSending = TRUE;
		SMR00    |= 0x0001U;														// ]Oޯ̧󂫂ł̊
		TXD0      = _gSndBuf.Buf[ _gSndBuf.ReadIdx ];								// ް
		M_RING_INC( _gSndBuf.ReadIdx, C_SIZE_COM_BUF );								// ǍݲޯXV
	}
	/* ---< Mް̏ꍇ >--- */
	else
	{
		;/* Do Nothing 荞ݏŏݲޯ܂ŏɑM */
	}
	STMK0  = 0U;																	// M݋
	return TRUE;
}
//************************************************************************************************
//	@\TvF̎Mޯ̧Mްo߹ĉ͂
//			F߹ĂAM̂ŁAM\߹Đ _gPacketCount Ɋi[Ă
//			FS߹ĎME͊ enComStatus_RcvRmbPacketEnd ߂
//		FȂ
//	߂l	FM S߹ĎME͊ enComStatus_RcvRmbPacketEnd
//	l	F
//************************************************************************************************
COM_RCV_STATUS ComRmb_RcvFrame( void )
{
	static uint16_t  dataCount;														// 1߹Ăް
	static uint16_t  packetCount;													// M߹Đ
	static uint8_t   checkSum;														// 
	uint8_t          rcvData;														// 1޲ĎMް
	const T_MES_TBL* table;															// M`ð

	/* ---< MްȂ >--- */
	if( _gRcvBuf.ReadIdx == _gRcvBuf.WriteIdx )
	{
		return enComStatus_RcvNon;
	}

	//*************************
	//   Mްǂݍ
	//*************************
	if( _gRcvFrame.Count >= C_SIZE_COM_FRAME )
	{
		_ComRmb_Error( enComErr_RcvIndexOver );										// ͈͒
		return enComStatus_RcvErr;
	}

	rcvData = _gRcvBuf.Buf[ _gRcvBuf.ReadIdx ];										// ް擾
	M_RING_INC( _gRcvBuf.ReadIdx, C_SIZE_COM_BUF );									// ǍޯXV

	//*************************
	//     Mް
	//*************************
	switch( _gRcvState )
	{
		case enComState_RmbHeader:													// ͯް҂
			if( rcvData != _C_CMD_RMB_STREAM )
			{
				return enComStatus_RcvRmbErr;
			}
			packetCount = 0;														// M()߹Đر
			checkSum    = (uint8_t)_C_CMD_RMB_STREAM;								// Ѿ
			_gRcvState  = enComState_RmbCount;										// ް҂
			return enComStatus_RcvRmbCount;
		case enComState_RmbCount:													// ް҂(ͯް,,яް)
			checkSum  += (uint8_t)rcvData;											// эXV
			_gRcvState = enComState_RmbPacketId;									// ߹ID҂
			return enComStatus_RcvRmbPacketId;
		case enComState_RmbPacketId:												// ߹ID҂
			table = Utility_GetTable( rcvData, _gRcvTable, _C_CNT_RMB_PACKET_ID );	// MނɑΉðَ擾
			if( table == NULL )
			{
				return enComStatus_RcvRmbErr;
			}
			_gRcvFrame.Count  = 0;													// OMڰ
			_gRcvFrame.Data[ _gRcvFrame.Count++ ] = rcvData;						// ߹ID
			checkSum  += (uint8_t)rcvData;											// эXV
			dataCount  = table->RcvMessageLen - 1;									// 1߹Ăް(ͯްMςȂ̂-1)
			_gRcvState = enComState_RmbData;										// ްM
			return enComStatus_RcvRmbData;
		case enComState_RmbData:													// ްM
			_gRcvFrame.Data[ _gRcvFrame.Count++ ] = rcvData;						// ް
			checkSum += (uint8_t)rcvData;											// эXV
			dataCount--;
			if( dataCount == 0 )													// 1߹ĎM
			{
				/* ---< 1߹Ẳ͂ް >--- */
				if( !_ComRmb_AnalizePacket( _gRcvFrame.Data[ 0 ], (uint8_t*)( _gRcvFrame.Data + 1 )))
				{
					return enComStatus_RcvRmbErr;
				}
				packetCount++;														// M()߹Đ
				if( packetCount >= _gPacketCount )									// S߹ĎMς̏ꍇAё҂
				{
					_gRcvState = enComState_RmbChecksum;							// ё҂
					return enComStatus_RcvRmbChecksum;
				}
				else
				{
					_gRcvState = enComState_RmbPacketId;							// ߹ID҂
					return enComStatus_RcvRmbPacketId;
				}
			}
			return enComStatus_RcvRmbData;
		case enComState_RmbChecksum:												// ё҂
			checkSum += (uint8_t)rcvData;											// эXV
			if( checkSum != 0 )														// checkSum +  = 0 
			{
				return enComStatus_RcvRmbErr;
			}
			/* ---< ذюM >--- */
			packetCount = 0;														// M()߹Đر
			_gRcvState  = enComState_RmbHeader;										// ͯްM҂

			return enComStatus_RcvRmbPacketEnd;										// S߹ĎM
		default:
			return enComStatus_RcvRmbErr;
	}
}
//************************************************************************************************
//	@\TvF̎Mޯ̧Mްo߹ĉ͂
//		FPacketId ߹ID
//			FData     ߹ް
//	߂l	FTRUE()AFALSE(װ)
//	l	F
//************************************************************************************************
// PacketIdF߹ID
// Data    FMް
static BOOL _ComRmb_AnalizePacket( uint8_t PacketId, uint8_t* Data )
{
	switch( PacketId )
	{
		case enPacket_BumpsDrop:													// グAE
			gRmbData.MoveSafty.BumpDrop.Data = Data[ 0 ];
			break;
		case enPacket_Wall:															// Ή
			return FALSE;
		case enPacket_CliffLeft:													// RL
			gRmbData.MoveSafty.CliffLeft = Data[ 0 ] == 0 ? FALSE : TRUE;
			break;
		case enPacket_CliffFLeft:													// ORL
			gRmbData.MoveSafty.CliffFLeft = Data[ 0 ] == 0 ? FALSE : TRUE;
			break;
		case enPacket_CliffFRight:													// EORL
			gRmbData.MoveSafty.CliffFRight = Data[ 0 ] == 0 ? FALSE : TRUE;
			break;
		case enPacket_CliffRight:													// ERL
			gRmbData.MoveSafty.CliffRight = Data[ 0 ] == 0 ? FALSE : TRUE;
			break;
		case enPacket_WheelOverCur:													// ߓd
			gRmbData.ElecSafty.WheelOverCur.Data = Data[ 0 ];
			break;
		case enPacket_UnusedByte:													// аް
			break;
		case enPacket_Buttons:														// ݂̉
			gRmbData.Others.Buttons.Data = Data[ 0 ];
			break;
		case enPacket_BattCharging:													//  [d
			gRmbData.ElecSafty.BattCharging = Data[ 0 ];
			break;
		case enPacket_BattVoltage:													// ޯؓd
			gRmbData.ElecSafty.BattVoltage = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_BattCurrent:													// ޯذd
			gRmbData.ElecSafty.BattCurrent = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_BattTemperature:												// ޯذx
			gRmbData.ElecSafty.BattTemperature = (int16_t)((uint16_t)Data[ 0 ]);
			break;
		case enPacket_BattCharge:													// ݂ޯذ[d
			gRmbData.ElecSafty.BattCharge = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_BattCapacity:													// ݂̐ޯذ[de
			gRmbData.ElecSafty.BattCapacity = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_WallSig:														// Ή
			return FALSE;
		case enPacket_CliffLeftSig:													// RݻMx
			gRmbData.MoveSafty.CliffLeftSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_CliffFLeftSig:												// ORݻMx
			gRmbData.MoveSafty.CliffFLeftSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_CliffFRightSig:												// EORݻMx
			gRmbData.MoveSafty.CliffFRightSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_CliffRightSig:												// ERݻMx
			gRmbData.MoveSafty.CliffRightSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_BattChargingSrc:												// [dؿ
			gRmbData.ElecSafty.BattChargingSrc.Data = Data[ 0 ];
			break;
		case enPacket_OiMode:														// ݂Ӱ
			gRmbData.Others.OiMode = (RMBMODE)Data[ 0 ];
			break;
		case enPacket_EncoderLeft:													// Դݺޗݐϒl
			gRmbData.MoveCntl.EncoderLeft = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_EncoderRight:													// EԴݺޗݐϒl
			gRmbData.MoveCntl.EncoderRight = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_LightBumper:													// ײ߰o
			gRmbData.MoveCntl.LightBumper.Data = Data[ 0 ];
			break;
		case enPacket_LightBumpLSig:												// ײ߰Mx
			gRmbData.MoveCntl.LightBumpLSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_LightBumpFLSig:												// Oײ߰Mx
			gRmbData.MoveCntl.LightBumpFLSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_LightBumpCLSig:												// ײ߰Mx
			gRmbData.MoveCntl.LightBumpCLSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_LightBumpCRSig:												// Eײ߰Mx
			gRmbData.MoveCntl.LightBumpCRSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_LightBumpFRSig:												// EOײ߰Mx
			gRmbData.MoveCntl.LightBumpFRSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_LightBumpRSig:												// Eײ߰Mx
			gRmbData.MoveCntl.LightBumpRSig = (int16_t)Utility_GetBigByteToUint16( Data );
			break;
		case enPacket_Stasis:														// Ή
			return FALSE;
		case enPacket_IrLeft:														// ԊOʐM
			gRmbData.Others.IrLeft = Data[ 0 ];
			break;
		case enPacket_IrRight:														// EԊOʐM
			gRmbData.Others.IrRight = Data[ 0 ];
			break;
		default:
			return FALSE;
	}
	return TRUE;
}
//************************************************************************************************
//	@\TvFUARTE݋
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
static void _ComRmb_Start( void )
{
	SO0		|= BIT0;																// oHi
	SOE0	|= BIT0;																// o͋
	SS0		|= ( BIT1 | BIT0 );														// MJn
	STIF0	 = 0U; 																	// Mݗv׸޸ر
	SRIF0	 = 0U;																	// Mݗv׸޸ر
	SREIF0	 = 0U;																	// Mװݗv׸޸ر
	STMK0	 = 0U;																	// M݋
	SRMK0	 = 0U;																	// M݋
	SREMK0	 = 0U;																	// Mװ݋
}
//************************************************************************************************
//	@\TvFUART~E݋֎~
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
static void _ComRmb_Stop( void )
{
	STMK0	 = 1U;																	// MϽ
	SRMK0	 = 1U;																	// MϽ
	SREMK0	 = 1U;																	// MװϽ
	ST0		|= ( BIT1 | BIT0 );														// M~
	SOE0	&= ~(BIT0);																// o͋֎~
	STIF0	 = 0U;																	// Mݗv׸޸ر
	SRIF0	 = 0U;																	// Mݗv׸޸ر
	SREIF0	 = 0U;																	// Mװݗv׸޸ر
}
//************************************************************************************************
//	@\TvFװBɴװĂꍇͽٰ
//		FError װү
//	߂l	FȂ
//	l	F
//************************************************************************************************
static void _ComRmb_Error( COM_ERROR Error )
{
	if(( gRmbComError != enComErr_Non ) || ( Error == enComErr_Non ))
	{
		return;
	}
	gRmbComError = Error;
}
//************************************************************************************************
//	@\TvFM
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
static void __near _ComRmb_IntRcv( void )
{
    volatile uint8_t rx_data = RXD0;
	_gRcvBuf.Buf[ _gRcvBuf.WriteIdx ] = rx_data;									// ްi[
	M_RING_INC( _gRcvBuf.WriteIdx, C_SIZE_COM_BUF );								// ޯXV
	if( _gRcvBuf.WriteIdx == _gRcvBuf.ReadIdx )										// Ǎɒǂ
	{
		_ComRmb_Error( enComErr_RcvOverrun );										// Mޯ̧ް
		return;
	}
}
//************************************************************************************************
//	@\TvFM
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
static void __near _ComRmb_IntSnd( void )
{
	if( _gSndBuf.ReadIdx == _gSndBuf.WriteIdx )										// Ǎ݂݂ɒǂꍇ
	{
		/* ---< ]ł̊ >--- */
		if(( SMR00 & 0x0001U ) == 0U )
		{
			_gSending = FALSE;														// ]
		}
		/* ---< ]Oޯ̧󂫂ł̊ >--- */
		else
		{
			SMR00 &= ~(0x0001U);													// ]ݾ
		}
	}
	else
	{
		SMR00 |= 0x0001U;															// ]Oޯ̧󂫂ł̊
		TXD0   = _gSndBuf.Buf[ _gSndBuf.ReadIdx ];									// ް
		M_RING_INC( _gSndBuf.ReadIdx, C_SIZE_COM_BUF );								// ǍݲޯXV
	}
}
//************************************************************************************************
//	@\TvFMװ
//		FȂ
//	߂l	FȂ
//	l	F
//************************************************************************************************
static void __near _ComRmb_IntErr( void )
{
	volatile uint8_t err;
	volatile uint8_t rx = 0;
	
	rx   |= RXD0;																	// аذ
	err   = (uint8_t)( SSR01 & 0x0007U );											// װ擾(ڰݸށAèAް)
	SIR01 = (uint16_t)err;															// װر
}
