﻿using HtmlAgilityPack;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Diagnostics;
using System.Drawing.Text;
using System.IO;
using System.Net;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using System.Security.Policy;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Xml.Linq;
using static System.Net.WebRequestMethods;

// 参考URL
// https://lets-csharp.com/scraping-keiba/

namespace SmallSolution_Race
{
	/*********************************************************************/
	/*                                                                   */
	/*                        --- ﾒｲﾝﾌｫｰﾑｸﾗｽ ---                         */
	/*                                                                   */
	/*********************************************************************/
	public partial class FormRace : Form
	{
		// ﾊﾞｰｼﾞｮﾝ変更
		// AssemblyInfo.cs の AssemblyVersion を変更する
		private RaceInfo        gRaceInfo           = new RaceInfo();						// ﾚｰｽ情報
		private List<HorseInfo> gHorseInfo          = new List<HorseInfo>();				// 馬情報・履歴情報
		private int             gHorseTitleCount    = 0;									// 馬情報ﾀｲﾄﾙの数
		private int             gHistoryTitleCount  = 0;									// 履歴情報ﾀｲﾄﾙの数
		private int             gHistoryCount       = 4;									// 履歴情報取得数
		private const int       gElementChkBoxCount = 34;									// 要素ﾁｪｯｸﾎﾞｯｸｽの数
		private int             gOutputColumn       = 1;									// 出力ﾚｲｱｳﾄ列数
		private string          gAccessPath         = "";									// ﾌｧｲﾙｵｰﾌﾟﾝｾｰﾌﾞでｱｸｾｽしたﾃﾞｨﾚｸﾄﾘ
		private int             gSaveFileIndex      = 1;									// ﾀﾞｲｱﾛｸﾞｲﾝﾃﾞｯｸｽ

		/*************************/
		/*        ｺﾝｽﾄﾗｸﾀ        */
		/*************************/
		public FormRace()
		{
			/*************************/
			/*        初期化         */
			/*************************/
			InitializeComponent();
			/* ---< ﾀｲﾄﾙ + ﾊﾞｰｼﾞｮﾝ >--- */
			this.Text = AppInfo.AplAssemblyInfo.Title + "  [ " + AppInfo.AplAssemblyInfo.FileVersion + " ]";

			/*************************/
			/*     ﾌﾟﾛｸﾞﾚｽﾊﾞｰｾｯﾄ     */
			/*************************/
			AppInfo.AppResource.Progress = stripStatusProgress;
			AppInfo.AppResource.Label    = stripStatusLabel;
			/* ---< ｽﾃｰﾀｽﾗﾍﾞﾙの領域を表示 >--- */
			// 最初のｸﾞﾗﾌ追加でｽﾃｰﾀｽﾗﾍﾞﾙが表示されていないと、StatusSprit の高さが低く
			// ｽﾃｰﾀｽﾗﾍﾞﾙが表示された時にｽﾃｰﾀｽﾗﾍﾞﾙの高さが高くなり、ﾌｫｰﾑ全体がﾘｻｲｽﾞされ
			// 画面が揺れるので、表示をしておく
			AppInfo.AppResource.LabelText = CommonText.ProcessStandby;
			AppInfo.AppResource.SetProgress( 0, 0 );

			/*************************/
			/*        表示ｾｯﾄ        */
			/*************************/
			SetMenuText();																	// ﾒﾆｭｰ表示
			cbxHcount.Text       = gHistoryCount.ToString();								// 過去のﾚｰｽ数

			/* ---< 言語ﾁｪｯｸﾎﾞｯｸｽｾｯﾄ >--- */
			chbLanguage.Checked  = false;
			if( AppInfo.AppSetting.Lanuage == LanguageType.enEnglish )
			{
				chbLanguage.Checked = true;
			}

			/* ---< 要素ﾁｪｯｸﾎﾞｯｸｽｾｯﾄ >--- */
			if( AppInfo.AppSetting.BoolArray == null )										// 未保存なので、現状状態で保存
			{
				AppInfo.AppSetting.BoolArray = GetCheckBox();
				AppInfo.AppSetting.Save();
			}
			else if( AppInfo.AppSetting.BoolArray != null )
			{
				if( AppInfo.AppSetting.BoolArray.Length != gElementChkBoxCount )			// 数が合わないので、現状状態で保存
				{
					AppInfo.AppSetting.BoolArray = GetCheckBox();
					AppInfo.AppSetting.Save();
				}
				else
				{
					SetCheckBox( AppInfo.AppSetting.BoolArray );							// ｱﾌﾟﾘｹｰｼｮﾝｾｯﾃｨﾝｸﾞの状態を反映してｾｯﾄ
				}
			}

			btnDownload.Enabled  = false;
			btnClipboard.Enabled = false;
			btnFile.Enabled      = false;
		}
		/*********************************************************************/
		/*                            ﾒｯｾｰｼﾞ操作                             */
		/*********************************************************************/
		/*************************/
		/*      ﾒｯｾｰｼﾞ受信       */
		/*************************/
		private void RecieveMessage( object sender, EventArgs e )
		{
			AppEventArgs arg = (AppEventArgs)e;

			string showMessage = "";
			string errMessage  = "";
			switch( arg.Type )
			{
				case MessageType.Mes_Progress:												// 計算中
					AppInfo.AppResource.LabelText = CommonText.Process;
					AppInfo.AppResource.SetProgress( arg.MaxCount, arg.CrtCount );
					break;
				case MessageType.Mes_ProgressEnd:											// 計算完了
					AppInfo.AppResource.LabelText = CommonText.ProcessStandby;
					AppInfo.AppResource.SetProgress( 0, 0 );
					break;
				case MessageType.Mes_Warning:												// 警告
					AppInfo.AppResource.LabelText = CommonText.ProcessWarning;
					showMessage = arg.MessageStr;
					break;
				case MessageType.Mes_Error:													// ｴﾗｰ
					AppInfo.AppResource.LabelText = CommonText.ProcessError;
					errMessage = arg.MessageStr;
					break;
			}
			if( showMessage != "" )
			{

			}
			if( errMessage != "" )
			{
				MessageBox.Show( errMessage, CommonText.ProcessError, MessageBoxButtons.OK, MessageBoxIcon.Error );
			}
		}
		/*********************************************************************/
		/*                             ﾌｫｰﾑ操作                              */
		/*********************************************************************/
		/*************************/
		/*     URLｵｰﾌﾟﾝｲﾍﾞﾝﾄ     */
		/*************************/
		private void btnOpenUrlJra_Click( object sender, EventArgs e )
		{
			ProcessStartInfo pi = new ProcessStartInfo()
			{
				FileName        = "https://race.netkeiba.com/top/?rf=navi",
				UseShellExecute = true,
			};

			Process.Start( pi );
		}
		private void btnOpenUrlLocal_Click( object sender, EventArgs e )
		{
			ProcessStartInfo pi = new ProcessStartInfo()
			{
				FileName        = "https://nar.netkeiba.com/top/?rf=navi",
				UseShellExecute = true,
			};

			Process.Start( pi );
		}
		/*************************/
		/*     URL変更ｲﾍﾞﾝﾄ      */
		/*************************/
		private void txbUrl_TextChanged( object sender, EventArgs e )
		{
			if( txbUrl.Text.Contains( "https://race.netkeiba.com" ) || txbUrl.Text.Contains( "https://nar.netkeiba.com" ))
			{
				btnDownload.Enabled = true;
			}
			else
			{
				btnDownload.Enabled = false;
			}
		}
		/*************************/
		/*     言語変更ｲﾍﾞﾝﾄ     */
		/*************************/
		private void chbLanguage_CheckedChanged( object sender, EventArgs e )
		{
			if( chbLanguage.Checked )
			{
				Utility_Restart.ChangeLanguage( LanguageType.enEnglish,  RecieveMessage );
			}
			else
			{
				Utility_Restart.ChangeLanguage( LanguageType.enJapanese, RecieveMessage );
			}
		}
		/*************************/
		/*     要素変更ｲﾍﾞﾝﾄ     */
		/*************************/
		private void chbCheckedChanged( object sender, EventArgs e )
		{
			AppInfo.AppSetting.BoolArray = GetCheckBox();
			AppInfo.AppSetting.Save();
		}
		/*************************/
		/*      表示ﾃｷｽﾄｾｯﾄ      */
		/*************************/
		private void SetMenuText()
		{
			grpRace.Text              = RaceText.Race;										// 今回のﾚｰｽ
			grpHistory.Text           = RaceText.History;									// 過去のﾚｰｽ
			grpOutput.Text            = RaceText.Layout;									// 出力ﾚｲｱｳﾄ
			radCascade.Text           = RaceText.Cascade;									// ｶｽｹｰﾄﾞ
			radTile.Text              = RaceText.Tile;										// ﾀｲﾙ
			lblHcount.Text            = RaceText.Hcount;									// 過去のﾚｰｽ数
			grpLanguage.Text          = CommonText.Language;								// 言語		
			chbLanguage.Text          = CommonText.English;									// 英語

			btnOpenUrlJra.Text        = RaceText.OpenUrlJra;								// JRA競馬ｵｰﾌﾟﾝﾎﾞﾀﾝ
			btnOpenUrlLocal.Text      = RaceText.OpenUrlLocal;								// 地方競馬ｵｰﾌﾟﾝﾎﾞﾀﾝ
			btnDownload.Text          = RaceText.Download;									// URLﾀﾞｳﾝﾛｰﾄﾞﾎﾞﾀﾝ
			btnClipboard.Text         = RaceText.Clipboard;									// ｸﾘｯﾌﾟﾎﾞｰﾄﾞﾎﾞﾀﾝ
			btnFile.Text              = RaceText.File;										// ﾌｧｲﾙﾎﾞﾀﾝ

			chbWakuNum.Text           = RaceText.WakuNum;									// 枠番
			chbHorseNum.Text          = RaceText.HorseNum;									// 馬番
			chbHorse.Text             = RaceText.Horse;										// 馬名
			chbGender.Text            = RaceText.Gender;									// 性別
			chbAge.Text               = RaceText.Age;										// 年齢
			chbWeight.Text            = RaceText.Weight;									// 斤量
			chbJockey.Text            = RaceText.Jockey;									// 騎手
			chbBarn.Text              = RaceText.Barn;										// 厩舎
			chbHorseWeight.Text       = RaceText.HorseWeight;								// 馬体重
			chbHorseWeightDiff.Text   = RaceText.HorseWeightDiff;							// 馬体重差

			chbH_Date.Text            = RaceText.Date;										// 日付
			chbH_Track.Text           = RaceText.Track;										// 開催
			chbH_Weather.Text         = RaceText.Weather;									// 天気
			chbH_RaceNum.Text         = RaceText.RaceNum;									// ﾚｰｽ番号
			chbH_RaceName.Text        = RaceText.RaceName;									// ﾚｰｽ名
			chbH_Starters.Text        = RaceText.Starters;									// 頭数
			chbH_WakuNum.Text         = RaceText.WakuNum;									// 枠番
			chbH_HorseNum.Text        = RaceText.HorseNum;									// 馬番
			chbH_Odds.Text            = RaceText.Odds;										// ｵｯｽﾞ
			chbH_Favorite.Text        = RaceText.Favorite;									// 人気
			chbH_Result.Text          = RaceText.Result;									// 着順
			chbH_Jockey.Text          = RaceText.Jockey;									// 騎手
			chbH_Weight.Text          = RaceText.Weight;									// 斤量
			chbH_TurfDirt.Text        = RaceText.TurfDirt;									// 芝・ﾀﾞｰﾄ
			chbH_Distance.Text        = RaceText.Distance;									// 距離
			chbH_Condition.Text       = RaceText.Condition;									// 馬場状態(重稍など)
			chbH_Finish.Text          = RaceText.Finish;									// ﾀｲﾑ
			chbH_Margin.Text          = RaceText.Margin;									// 着差
			chbH_Position.Text        = RaceText.Position;									// 通過
			chbH_Pace_1.Text          = RaceText.Pace_1;									// ﾍﾟｰｽ_1
			chbH_Pace_2.Text          = RaceText.Pace_2;									// ﾍﾟｰｽ_2
			chbH_Pace_3F.Text         = RaceText.Pace_3F;									// 上り_3F
			chbH_HorseWeight.Text     = RaceText.HorseWeight;								// 馬体重
			chbH_HorseWeightDiff.Text = RaceText.HorseWeightDiff;							// 馬体重差
		}
		/*************************/
		/* 要素ﾁｪｯｸﾎﾞｯｸｽ状態取得 */
		/*************************/
		private bool[] GetCheckBox()
		{
			bool[] result = new bool[ gElementChkBoxCount ]
			{
				chbWakuNum.Checked,          												// 枠番
				chbHorseNum.Checked,          												// 馬番
				chbHorse.Checked,             												// 馬名
				chbGender.Checked,            												// 性別
				chbAge.Checked,               												// 年齢
				chbWeight.Checked,            												// 斤量
				chbJockey.Checked,            												// 騎手
				chbBarn.Checked,              												// 厩舎
				chbHorseWeight.Checked,       												// 馬体重
				chbHorseWeightDiff.Checked,   												// 馬体重差

				chbH_Date.Checked,            												// 日付
				chbH_Track.Checked,           												// 開催
				chbH_Weather.Checked,         												// 天気
				chbH_RaceNum.Checked,         												// ﾚｰｽ番号
				chbH_RaceName.Checked,        												// ﾚｰｽ名
				chbH_Starters.Checked,        												// 頭数
				chbH_WakuNum.Checked,         												// 枠番
				chbH_HorseNum.Checked,        												// 馬番
				chbH_Odds.Checked,            												// ｵｯｽﾞ
				chbH_Favorite.Checked,        												// 人気
				chbH_Result.Checked,          												// 着順
				chbH_Jockey.Checked,          												// 騎手
				chbH_Weight.Checked,          												// 斤量
				chbH_TurfDirt.Checked,        												// 芝・ﾀﾞｰﾄ
				chbH_Distance.Checked,        												// 距離
				chbH_Condition.Checked,       												// 馬場状態(重稍など)
				chbH_Finish.Checked,          												// ﾀｲﾑ
				chbH_Margin.Checked,          												// 着差
				chbH_Position.Checked,        												// 通過
				chbH_Pace_1.Checked,          												// ﾍﾟｰｽ_1
				chbH_Pace_2.Checked,          												// ﾍﾟｰｽ_2
				chbH_Pace_3F.Checked,         												// 上り_3F
				chbH_HorseWeight.Checked,     												// 馬体重
				chbH_HorseWeightDiff.Checked 												// 馬体重差
			};
			return result;
		}
		/*************************/
		/* 要素ﾁｪｯｸﾎﾞｯｸｽ状態ｾｯﾄ  */
		/*************************/
		private void SetCheckBox( bool[] BoolArray )
		{
			chbWakuNum.Checked           = BoolArray[  0 ];									// 枠番
			chbHorseNum.Checked          = BoolArray[  1 ];									// 馬番
			chbHorse.Checked             = BoolArray[  2 ];									// 馬名
			chbGender.Checked            = BoolArray[  3 ];									// 性別
			chbAge.Checked               = BoolArray[  4 ];									// 年齢
			chbWeight.Checked            = BoolArray[  5 ];									// 斤量
			chbJockey.Checked            = BoolArray[  6 ];									// 騎手
			chbBarn.Checked              = BoolArray[  7 ];									// 厩舎
			chbHorseWeight.Checked       = BoolArray[  8 ];									// 馬体重
			chbHorseWeightDiff.Checked   = BoolArray[  9 ];									// 馬体重差

			chbH_Date.Checked            = BoolArray[ 10 ];									// 日付
			chbH_Track.Checked           = BoolArray[ 11 ];									// 開催
			chbH_Weather.Checked         = BoolArray[ 12 ];									// 天気
			chbH_RaceNum.Checked         = BoolArray[ 13 ];									// ﾚｰｽ番号
			chbH_RaceName.Checked        = BoolArray[ 14 ];									// ﾚｰｽ名
			chbH_Starters.Checked        = BoolArray[ 15 ];									// 頭数
			chbH_WakuNum.Checked         = BoolArray[ 16 ];									// 枠番
			chbH_HorseNum.Checked        = BoolArray[ 17 ];									// 馬番
			chbH_Odds.Checked            = BoolArray[ 18 ];									// ｵｯｽﾞ
			chbH_Favorite.Checked        = BoolArray[ 19 ];									// 人気
			chbH_Result.Checked          = BoolArray[ 20 ];									// 着順
			chbH_Jockey.Checked          = BoolArray[ 21 ];									// 騎手
			chbH_Weight.Checked          = BoolArray[ 22 ];									// 斤量
			chbH_TurfDirt.Checked        = BoolArray[ 23 ];									// 芝・ﾀﾞｰﾄ
			chbH_Distance.Checked        = BoolArray[ 24 ];									// 距離
			chbH_Condition.Checked       = BoolArray[ 25 ];									// 馬場状態(重稍など)
			chbH_Finish.Checked          = BoolArray[ 26 ];									// ﾀｲﾑ
			chbH_Margin.Checked          = BoolArray[ 27 ];									// 着差
			chbH_Position.Checked        = BoolArray[ 28 ];									// 通過
			chbH_Pace_1.Checked          = BoolArray[ 29 ];									// ﾍﾟｰｽ_1
			chbH_Pace_2.Checked          = BoolArray[ 30 ];									// ﾍﾟｰｽ_2
			chbH_Pace_3F.Checked         = BoolArray[ 31 ];									// 上り_3F
			chbH_HorseWeight.Checked     = BoolArray[ 32 ];									// 馬体重
			chbH_HorseWeightDiff.Checked = BoolArray[ 33 ];									// 馬体重差
		}
		/*********************************************************************/
		/*                       ｸﾘｯﾌﾟﾎﾞｰﾄﾞ書込み操作                        */
		/*********************************************************************/
		/*************************/
		/*    ｸﾘｯﾌﾟﾎﾞｰﾄﾞｲﾍﾞﾝﾄ    */
		/*************************/
		private void btnClipboard_Click( object sender, EventArgs e )
		{
			WriteDataToClipboard( "\t", RecieveMessage );									// ｴｸｾﾙにﾍﾟｰｽﾄできるようTSV形式とする
		}
		/*************************/
		/*  ｸﾘｯﾌﾟﾎﾞｰﾄﾞへ書込み   */
		/*************************/
		// Delimiter   ：ﾃﾞﾘﾐﾀ(CSV・TSV形式)
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public bool WriteDataToClipboard( string Delimiter, EventHandler MessageEvent )
		{
			try
			{
				/* ---< ｸﾘｯﾌﾟﾎﾞｰﾄﾞｸﾘｱ >--- */
				Clipboard.Clear();

				string data = GetCsvTsvData( Delimiter );

				/* ---< ｸﾘｯﾌﾟﾎﾞｰﾄﾞｾｯﾄ >--- */
				// false設定だと、Clipboard内で恐らくｾｯﾄしたﾃﾞｰﾀと同じほぼｻｲｽﾞのHashtableが生成されてｸﾘｱしても消えない
				Clipboard.SetDataObject( data, true );										// falseだとﾒﾓﾘｰﾘｰｸを起こす(MSのﾊﾞｸﾞ)

				return true;
			}
			catch( Exception e )
			{
				Message.SendMessage_Error(
					MessageType.Mes_Error,
					e.Message,
					e,
					MessageEvent );
				return false;
			}
		}
		/*********************************************************************/
		/*                          ﾌｧｲﾙ書込み操作                           */
		/*********************************************************************/
		/*************************/
		/*       ﾌｧｲﾙｲﾍﾞﾝﾄ       */
		/*************************/
		private void btnFile_Click( object sender, EventArgs e )
		{
			string fileName = SaveFileDialog();
			WriteCsvTsvFile( fileName, ",", RecieveMessage );
		}
		/*************************/
		/*    ﾌｧｲﾙｾｰﾌﾞﾀﾞｲｱﾛｸﾞ    */
		/*************************/
		private string SaveFileDialog()
		{
			// AddExtension(ﾃﾞﾌｫﾙﾄtrue)    ：ﾕｰｻﾞが拡張子を指定しない場合、ﾌｧｲﾙ名名に自動的に拡張子を付ける
			// CheckFileExists(ﾃﾞﾌｫﾙﾄfalse)：現在のﾌｧｲﾙﾌｨﾙﾀｰから有効な最初の拡張子が追加される
			// 以下の場合、拡張子なしならcsvが付加される
			SaveFileDialog sfd = new SaveFileDialog()
			{
				InitialDirectory = gAccessPath,
				Filter           = "テキストファイル(*.csv)|*.csv|(*.*)|*.*",
				FilterIndex      = gSaveFileIndex,											// 1から始まるﾌｨﾙﾀｰｲﾝﾃﾞｯｸｽをｾｯﾄ
				Title            = RaceText.SaveFile
			};
			if( sfd.ShowDialog() == DialogResult.OK )
			{
				/* ---< ﾌｧｲﾙｱｸｾｽ履歴ｾｯﾄ >--- */
				gAccessPath    = Path.GetDirectoryName( sfd.FileName );
				gSaveFileIndex = sfd.FilterIndex;
				return sfd.FileName;
			}
			return null;
		}
		/*************************/
		/*      ﾌｧｲﾙ書込み       */
		/*************************/　
		// FileName    ：ﾌｧｲﾙ名
		// Delimiter   ：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		private bool WriteCsvTsvFile( string FileName, string Delimiter, EventHandler MessageEvent )
		{
			try
			{
				/* ---< 引数ﾁｪｯｸ >--- */
				if(( FileName == null ) || ( FileName == "" ))
				{
					return false;
				}

				string data = GetCsvTsvData( Delimiter );

				StreamWriter sw = new StreamWriter( FileName, false, Encoding.Default );
				sw.Write( data );
				sw.Close();

				return true;
			}
			catch( Exception ex )
			{
				Message.SendMessage_Error(
					MessageType.Mes_Error,
					ex.Message,
					ex,
					MessageEvent );
				return false;
			}
		}
		/*************************/
		/*  ﾃｷｽﾄ形式のﾃﾞｰﾀ取得   */
		/*************************/
		// Delimiter：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		private string GetCsvTsvData( string Delimiter )
		{
			if( Int32.TryParse( cbxHcount.Text, out int result ))							// 履歴情報取得数の取得
			{
				gHistoryCount = result;
			}
			if( radCascade.Checked )														// 出力ﾚｲｱｳﾄ列数の取得
			{
				gOutputColumn = 1;
			}
			if( radTile.Checked )
			{
				gOutputColumn = 3;
			}
			string lf              = "\n";
			string raceTitle       = GetHorseInfoTitle(   Delimiter );
			string historyTitle    = GetHistoryInfoTitle( Delimiter );
			string noRaceData      = GetStr( Delimiter, gHorseTitleCount );					// GetHorseInfoTitle の後に実行の事
			string columnDelimiter = Delimiter;
			string data            = gRaceInfo.RaceNum.GetDataStr()   + "/"
								   + gRaceInfo.RaceName.GetDataStr()  + "/"
								   + gRaceInfo.TurfDirt.GetDataStr()  + "/"
								   + gRaceInfo.Distance.GetDataStr()  + "/"
								   + gRaceInfo.StartTime.GetDataStr() + lf;
			 
			for( int index = 0; index < gOutputColumn; index++ )							// 最上表示のﾀｲﾄﾙを列毎にｾｯﾄ
			{
				data += raceTitle + historyTitle;
				if( index == gOutputColumn - 1 )
				{
					data += lf;
				}
				else
				{
					data += columnDelimiter;
				}
			}

			// infoStr に馬情報と履歴情報の文字列として格納。これを出力ﾚｲｱｳﾄ列数に合わせて全体の文字列を生成する
			//
			//	|￣￣￣￣￣￣￣|￣￣￣￣￣￣￣|↑[0]
			//  |  HorseInfo   | HistoryInfo  |｜[1] gHistoryMaxケ
			//  |______________|______________|↓[2]
			//
			//	|￣￣￣￣￣￣￣|￣￣￣￣￣￣￣|
			//  |  HorseInfo   | HistoryInfo  |
			//  |______________|______________|
			//
			//  ・・・・・・・・・・・・・・・・
			//
			//	|￣￣￣￣￣￣￣|￣￣￣￣￣￣￣|
			//  |  HorseInfo   | HistoryInfo  |
			//  |______________|______________|
			//
			List<List<string>> infoStr = new List<List<string>>();
			for( int index_1 = 0; index_1 < gHorseInfo.Count; index_1++ )
			{
				List<string> info        = new List<string>();
				string       raceData    = GetHorseInfoData(   gHorseInfo[ index_1 ],  Delimiter );
				List<string> historyData = GetHistoryInfoData( gHorseInfo[ index_1 ],  Delimiter );

				info.Add( raceData + historyData[ 0 ] );
				for( int index_2 = 1; index_2 < gHistoryCount; index_2++ )
				{
					info.Add( noRaceData + historyData[ index_2 ] );
				}

				infoStr.Add( info );
			}

			//
			// 列数分の並びになるように文字列を生成する
			//
			//  <--------------------------------- gOutputColumn ------------------------------------------->
			//	|￣￣￣￣￣￣￣|￣￣￣￣￣￣￣||￣￣￣￣￣￣￣|￣￣￣￣￣￣￣||￣￣￣￣￣￣￣|￣￣￣￣￣￣￣|
			//  |  HorseInfo   | HistoryInfo  ||  HorseInfo   | HistoryInfo  ||  HorseInfo   | HistoryInfo  |
			//  |______________|______________||______________|______________||______________|______________|
			//
			//	|￣￣￣￣￣￣￣|￣￣￣￣￣￣￣||￣￣￣￣￣￣￣|￣￣￣￣￣￣￣||￣￣￣￣￣￣￣|￣￣￣￣￣￣￣|
			//  |  HorseInfo   | HistoryInfo  ||  HorseInfo   | HistoryInfo  ||  HorseInfo   | HistoryInfo  |
			//  |______________|______________||______________|______________||______________|______________|
			//
			//  ・・・・・・・・・・・・・・・・
			//
			//	|￣￣￣￣￣￣￣|￣￣￣￣￣￣￣||￣￣￣￣￣￣￣|￣￣￣￣￣￣￣|
			//  |  HorseInfo   | HistoryInfo  ||  HorseInfo   | HistoryInfo  |
			//  |______________|______________||______________|______________|
			//
			List<List<string>> column = new List<List<string>>();
			for( int index = 0; index < infoStr.Count; index++ )
			{
				column.Add( infoStr[ index ] );
				if(( column.Count == gOutputColumn ) || ( index == infoStr.Count - 1 ))
				{
					data += GetColumnData( column, Delimiter );
					column.Clear();
				}
			}
			return data;
		}
		// Data     ：馬毎の馬情報・履歴情報を gOutputColumn で指定された頭数分のﾃﾞｰﾀ
		// Delimiter：ﾃﾞﾘﾐﾀ(CSV・TSV形式)
		private string GetColumnData( List<List<string>> Data, string Delimiter )
		{
			/* ---< 引数ﾁｪｯｸ >--- */
			if(( Data == null ) || ( Data.Count == 0 ))
			{
				return "";
			}

			// 
			// [馬][履歴] Dataは馬毎の履歴ﾃﾞｰﾀの並びになっている
			// [0][0]  [1][0]  [2][0] ↑
			// [0][1]  [1][1]  [2][1] ｜gHistoryMaxケ
			// [0][2]  [1][2]  [2][2] ↓
			// 
			string result = "";
			string lf     = "\n";
			for( int y = 0; y < gHistoryCount; y++ )
			{
				for( int x = 0; x < Data.Count; x++ )
				{
					result += Data[ x ][ y ];
					if( x != Data.Count - 1 )
					{
						result += Delimiter;
					}
				}
				result += lf;
			}
			return result;
		}
		/*********************************************************************/
		/*                          ﾃﾞｰﾀ読込み操作                           */
		/*********************************************************************/
		/*************************/
		/*   URLﾀﾞｳﾝﾛｰﾄﾞｲﾍﾞﾝﾄ    */
		/*************************/
		private void btnDownload_Click( object sender, EventArgs e )
		{
			try
			{
				/*************************/
				/*     URLﾃﾞｰﾀ読込み     */
				/*************************/
				/* ---< ﾚｰｽ情報取得 >--- */
				if( !Scraping.GetRaceInfo( gRaceInfo, txbUrl.Text, RecieveMessage ))
				{
					return;
				}
				/* ---< 馬情報取得 >--- */
				if( !Scraping.GetHorseInfo( gHorseInfo, txbUrl.Text, RecieveMessage ))
				{
					return;
				}
				/* ---< 履歴情報取得 >--- */
				Scraping.GetHistoryInfo( gHorseInfo, RecieveMessage );

				/*************************/
				/*   英語表記への変換    */
				/*************************/
				if( AppInfo.AppSetting.Lanuage == LanguageType.enEnglish )
				{
					ConvertToEnglish();
				}
				btnClipboard.Enabled = true;												// ﾃﾞｰﾀ読込みでﾎﾞﾀﾝを有効とする
				btnFile.Enabled      = true;
			}
			catch( Exception ex )
			{
				string mes = ex.Message;
				if( txbUrl.Text.Contains( "race/result" ))
				{
					 mes = RaceErrorText.UrlIsResult;
				}
				Message.SendMessage_Error(
					MessageType.Mes_Error,
					mes,
					ex,
					RecieveMessage );
			}
		}
		/*************************/
		/*   英語表記への変換    */
		/*************************/
		private void ConvertToEnglish()
		{
			try
			{
				/* ---< 開始した事をﾀﾞﾐｰで表示 >--- */
				Message.SendMessage_Progress( MessageType.Mes_Progress, 10, 1, RecieveMessage );

				/*************************/
				/*     ﾚｰｽ情報の変換     */
				/*        芝/ﾀﾞｰﾄ        */
				/*************************/
				gRaceInfo.TurfDirt.Data  = RaceText.GetTurfDirt( gRaceInfo.TurfDirt.GetDataStr() );

				/*************************/
				/*  馬・履歴情報の変換   */
				/*************************/
				for( int index_1 = 0; index_1 < gHorseInfo.Count; index_1++ )
				{
					/* ---< 進行状態通知 >--- */
					Message.SendMessage_Progress( MessageType.Mes_Progress, gHorseInfo.Count, index_1, RecieveMessage );

					/*************************/
					/*         馬名          */
					/*************************/
					if(( gHorseInfo[ index_1 ].HorseLink == null ) || ( gHorseInfo[ index_1 ].HorseLink.Data == "" ))
					{
						continue;
					}

					string htmlText = Scraping.GetHtmlText( gHorseInfo[ index_1 ].HorseLink.Data );
					if( htmlText == "" )
					{
						continue;
					}

					var htmlDoc = new HtmlAgilityPack.HtmlDocument();
					htmlDoc.LoadHtml( htmlText );
					var nodes = htmlDoc.DocumentNode.SelectNodes( "//p[@class=\"eng_name\"]" );
					if( nodes != null )
					{
						string strData = nodes[ 0 ].InnerText.Replace( "\n", "" );		// 改行無視
						if(( strData != null ) && ( strData != "" ))
						{
							gHorseInfo[ index_1 ].Horse.Data = strData;
						}
					}
					/*************************/
					/*         性別          */
					/*************************/
					gHorseInfo[ index_1 ].Gender.Data = RaceText.GetGender( gHorseInfo[ index_1 ].Age.Data, gHorseInfo[ index_1 ].Gender.Data );

					/*************************/
					/*         天気          */
					/*************************/
					for( int index_2 = 0; index_2 < gHorseInfo[ index_1].History.Count; index_2++ )
					{
						gHorseInfo[ index_1 ].History[ index_2 ].H_Weather.Data = RaceText.GetWeather( gHorseInfo[ index_1 ].History[ index_2 ].H_Weather.Data );
					}
					/*************************/
					/*        芝/ﾀﾞｰﾄ        */
					/*************************/
					for( int index_2 = 0; index_2 < gHorseInfo[ index_1].History.Count; index_2++ )
					{
						gHorseInfo[ index_1 ].History[ index_2 ].H_TurfDirt.Data = RaceText.GetTurfDirt( gHorseInfo[ index_1 ].History[ index_2 ].H_TurfDirt.Data );
					}
					/*************************/
					/*       馬場状態        */
					/*************************/
					for( int index_2 = 0; index_2 < gHorseInfo[ index_1].History.Count; index_2++ )
					{
						gHorseInfo[ index_1 ].History[ index_2 ].H_Condition.Data = RaceText.GetCondition(
							gHorseInfo[ index_1 ].History[ index_2 ].H_TurfDirt.Data,
							gHorseInfo[ index_1 ].History[ index_2 ].H_Condition.Data
						);
					}
				}
			}
			finally
			{
				/* ---< 完了通知 >--- */
				Message.SendMessage_Progress( MessageType.Mes_ProgressEnd, 0, 0, RecieveMessage );
			}
		}
		/*************************/
		/*    馬情報ﾀｲﾄﾙ取得     */
		/*************************/
		// Delimiter：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		private string GetHorseInfoTitle( string Delimiter )
		{
			string result = "";
			result += chbWakuNum.Checked         ? chbWakuNum.Text         + Delimiter : ""; 	// 枠番
			result += chbHorseNum.Checked        ? chbHorseNum.Text        + Delimiter : "";	// 馬番
			result += chbHorse.Checked           ? chbHorse.Text           + Delimiter : "";	// 馬名
			result += chbGender.Checked          ? chbGender.Text          + Delimiter : "";	// 性別
			result += chbAge.Checked             ? chbAge.Text             + Delimiter : "";	// 年齢
			result += chbWeight.Checked          ? chbWeight.Text          + Delimiter : "";	// 斤量
			result += chbJockey.Checked          ? chbJockey.Text          + Delimiter : "";	// 騎手
			result += chbBarn.Checked            ? chbBarn.Text            + Delimiter : "";	// 厩舎
			result += chbHorseWeight.Checked     ? chbHorseWeight.Text     + Delimiter : "";	// 馬体重
			result += chbHorseWeightDiff.Checked ? chbHorseWeightDiff.Text + Delimiter : "";	// 馬体重差

			if( result != "" )
			{
				// 馬情報ﾀｲﾄﾙの数。要素数は、Delimiter が1文字なので以下で計算できる
				string temp      = result;
				gHorseTitleCount = result.Length - temp.Replace( Delimiter,"" ).Length;
				return result;
			}
			gHorseTitleCount = 0;
			return result;
		}
		/*************************/
		/*    馬情報ﾃﾞｰﾀ取得     */
		/*************************/
		// Info     ：馬情報
		// Delimiter：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		private string GetHorseInfoData( HorseInfo Info, string Delimiter )
		{
			/* ---< 引数状態ﾁｪｯｸ >--- */
			if( Info == null )
			{
				// ﾃﾞｰﾀなしは、ﾃﾞﾘﾐﾀを要素数結合したものを戻す
				return GetStr( Delimiter, gHorseTitleCount );
			}

			string result = "";
			result += chbWakuNum.Checked         ? GetStr( Info.WakuNum         ) + Delimiter : ""; 	// 枠番
			result += chbHorseNum.Checked        ? GetStr( Info.HorseNum        ) + Delimiter : "";	// 馬番
			result += chbHorse.Checked           ? GetStr( Info.Horse           ) + Delimiter : "";	// 馬名
			result += chbGender.Checked          ? GetStr( Info.Gender          ) + Delimiter : "";	// 性別
			result += chbAge.Checked             ? GetStr( Info.Age             ) + Delimiter : "";	// 年齢
			result += chbWeight.Checked          ? GetStr( Info.Weight          ) + Delimiter : "";	// 斤量
			result += chbJockey.Checked          ? GetStr( Info.Jockey          ) + Delimiter : "";	// 騎手
			result += chbBarn.Checked            ? GetStr( Info.Barn            ) + Delimiter : "";	// 厩舎
			result += chbHorseWeight.Checked     ? GetStr( Info.HorseWeight     ) + Delimiter : "";	// 馬体重
			result += chbHorseWeightDiff.Checked ? GetStr( Info.HorseWeightDiff ) + Delimiter : "";	// 馬体重差

			if( result == "" )
			{
				// ﾃﾞｰﾀなしは、ﾃﾞﾘﾐﾀを要素数結合したものを戻す
				result = GetStr( Delimiter, gHorseTitleCount );
			}
			return result;
		}
		/*************************/
		/*   履歴情報ﾀｲﾄﾙ取得    */
		/*************************/
		// Delimiter：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		private string GetHistoryInfoTitle( string Delimiter )
		{
			string result = "";
			result += chbH_Date.Checked            ? chbH_Date.Text            + Delimiter : "";	// 日付
			result += chbH_Track.Checked           ? chbH_Track.Text           + Delimiter : "";	// 場所
			result += chbH_Weather.Checked         ? chbH_Weather.Text         + Delimiter : "";	// 天気
			result += chbH_RaceNum.Checked         ? chbH_RaceNum.Text         + Delimiter : "";	// ﾚｰｽ番号
			result += chbH_RaceName.Checked        ? chbH_RaceName.Text        + Delimiter : "";	// ﾚｰｽ名
			result += chbH_Starters.Checked        ? chbH_Starters.Text        + Delimiter : "";	// 頭数
			result += chbH_WakuNum.Checked         ? chbH_WakuNum.Text         + Delimiter : "";	// 枠番
			result += chbH_HorseNum.Checked        ? chbH_HorseNum.Text        + Delimiter : "";	// 馬番
			result += chbH_Odds.Checked            ? chbH_Odds.Text            + Delimiter : "";	// ｵｯｽﾞ
			result += chbH_Favorite.Checked        ? chbH_Favorite.Text        + Delimiter : "";	// 人気
			result += chbH_Result.Checked          ? chbH_Result.Text          + Delimiter : "";	// 着順
			result += chbH_Jockey.Checked          ? chbH_Jockey.Text          + Delimiter : "";	// 騎手
			result += chbH_Weight.Checked          ? chbH_Weight.Text          + Delimiter : "";	// 斤量
			result += chbH_TurfDirt.Checked        ? chbH_TurfDirt.Text        + Delimiter : "";	// 芝・ﾀﾞｰﾄ
			result += chbH_Distance.Checked        ? chbH_Distance.Text        + Delimiter : "";	// 距離
			result += chbH_Condition.Checked       ? chbH_Condition.Text       + Delimiter : "";	// 馬場(重稍など)
			result += chbH_Finish.Checked          ? chbH_Finish.Text          + Delimiter : "";	// ﾀｲﾑ
			result += chbH_Margin.Checked          ? chbH_Margin.Text          + Delimiter : "";	// 着差
			result += chbH_Position.Checked        ? chbH_Position.Text        + Delimiter : "";	// 通過
			result += chbH_Pace_1.Checked          ? chbH_Pace_1.Text          + Delimiter : "";	// ﾍﾟｰｽ_1
			result += chbH_Pace_2.Checked          ? chbH_Pace_2.Text          + Delimiter : "";	// ﾍﾟｰｽ_2
			result += chbH_Pace_3F.Checked         ? chbH_Pace_3F.Text         + Delimiter : "";	// 上り_3F
			result += chbH_HorseWeight.Checked     ? chbH_HorseWeight.Text     + Delimiter : "";	// 馬体重
			result += chbH_HorseWeightDiff.Checked ? chbH_HorseWeightDiff.Text + Delimiter : "";	// 馬体重差

			if( result != "" )
			{
				// 履歴情報ﾀｲﾄﾙの数。要素数は、Delimiter が1文字なので以下で計算できる
				string temp        = result;
				gHistoryTitleCount = result.Length - temp.Replace( Delimiter,"" ).Length;
				return result;
			}
			gHistoryTitleCount = 0;
			return result;
		}
		/*************************/
		/*   履歴情報ﾃﾞｰﾀ取得    */
		/*************************/
		// gHistoryMax 個の履歴を取得する。これ以下はﾃﾞﾘﾐﾀを要素数結合したものを入れて戻す
		// Info     ：馬情報
		// Delimiter：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		private List<string> GetHistoryInfoData( HorseInfo Info, string Delimiter )
		{
			List<string> result = new List<string>();

			/* ---< 引数状態ﾁｪｯｸ >--- */
			if( Info == null )
			{
				// ﾃﾞｰﾀなしは、ﾃﾞﾘﾐﾀを要素数結合したものを戻す
				for( int index = 0; index < gHistoryCount; index++ )
				{
					result.Add( GetStr( Delimiter, gHistoryTitleCount ));
				}
				return result;
			}

			if( Info.History.Count >= gHistoryCount )
			{
				for( int index = 0; index < gHistoryCount; index++ )
				{
					// ""で戻る事はない。最低でもﾃﾞﾘﾐﾀを要素数結合したものが戻る
					result.Add( GetHistoryInfoData( Info.History[ index ], Delimiter ));
				}
			}
			else
			{
				for( int index = 0; index < Info.History.Count; index++ )
				{
					// ""で戻る事はない。最低でもﾃﾞﾘﾐﾀを要素数結合したものが戻る
					result.Add( GetHistoryInfoData( Info.History[ index ], Delimiter ));
				}
				for( int index = 0; index < gHistoryCount - Info.History.Count; index++ )
				{
					result.Add( GetStr( Delimiter, gHistoryTitleCount ));
				}
			}
			return result;
		}
		// Info     ：履歴情報
		// Delimiter：ﾀﾌﾞでTSV or ｶﾝﾏでCSV形式
		private string GetHistoryInfoData( HistoryInfo Info, string Delimiter )
		{
			/* ---< 引数状態ﾁｪｯｸ >--- */
			if( Info == null )
			{
				// ﾃﾞｰﾀなしは、ﾃﾞﾘﾐﾀを要素数結合したものを戻す
				return GetStr( Delimiter, gHistoryTitleCount );
			}

			string result = "";
			result += chbH_Date.Checked            ? GetStr( Info.H_Date            ) + Delimiter : "";	// 日付
			result += chbH_Track.Checked           ? GetStr( Info.H_Track           ) + Delimiter : "";	// 場所
			result += chbH_Weather.Checked         ? GetStr( Info.H_Weather         ) + Delimiter : "";	// 天気
			result += chbH_RaceNum.Checked         ? GetStr( Info.H_RaceNum         ) + Delimiter : "";	// ﾚｰｽ番号
			result += chbH_RaceName.Checked        ? GetStr( Info.H_RaceName        ) + Delimiter : "";	// ﾚｰｽ名
			result += chbH_Starters.Checked        ? GetStr( Info.H_Starters        ) + Delimiter : "";	// 頭数
			result += chbH_WakuNum.Checked         ? GetStr( Info.H_WakuNum         ) + Delimiter : "";	// 枠番
			result += chbH_HorseNum.Checked        ? GetStr( Info.H_HorseNum        ) + Delimiter : "";	// 馬番
			result += chbH_Odds.Checked            ? GetStr( Info.H_Odds            ) + Delimiter : "";	// ｵｯｽﾞ
			result += chbH_Favorite.Checked        ? GetStr( Info.H_Favorite        ) + Delimiter : "";	// 人気
			result += chbH_Result.Checked          ? GetStr( Info.H_Result          ) + Delimiter : "";	// 着順
			result += chbH_Jockey.Checked          ? GetStr( Info.H_Jockey          ) + Delimiter : "";	// 騎手
			result += chbH_Weight.Checked          ? GetStr( Info.H_Weight          ) + Delimiter : "";	// 斤量
			result += chbH_TurfDirt.Checked        ? GetStr( Info.H_TurfDirt        ) + Delimiter : "";	// 芝・ﾀﾞｰﾄ
			result += chbH_Distance.Checked        ? GetStr( Info.H_Distance        ) + Delimiter : "";	// 距離
			result += chbH_Condition.Checked       ? GetStr( Info.H_Condition       ) + Delimiter : "";	// 馬場(重稍など)
			result += chbH_Finish.Checked          ? GetStr( Info.H_Finish          ) + Delimiter : "";	// ﾀｲﾑ
			result += chbH_Margin.Checked          ? GetStr( Info.H_Margin          ) + Delimiter : "";	// 着差
			result += chbH_Position.Checked        ? GetStr( Info.H_Position        ) + Delimiter : "";	// 通過
			result += chbH_Pace_1.Checked          ? GetStr( Info.H_Pace_1          ) + Delimiter : "";	// ﾍﾟｰｽ_1
			result += chbH_Pace_2.Checked          ? GetStr( Info.H_Pace_2          ) + Delimiter : "";	// ﾍﾟｰｽ_2
			result += chbH_Pace_3F.Checked         ? GetStr( Info.H_Pace_3F         ) + Delimiter : "";	// 上り_3F
			result += chbH_HorseWeight.Checked     ? GetStr( Info.H_HorseWeight     ) + Delimiter : "";	// 馬体重
			result += chbH_HorseWeightDiff.Checked ? GetStr( Info.H_HorseWeightDiff ) + Delimiter : "";	// 馬体重差

			if( result == "" )
			{
				// ﾃﾞｰﾀなしは、ﾃﾞﾘﾐﾀを要素数結合したものを戻す
				result = GetStr( Delimiter, gHistoryTitleCount );
			}
			return result;
		}
		private string GetStr<T>( InfoData<T> Info )
		{
			return Info.GetDataStr();
		}
		private string GetStr( string Data, int Count )
		{
			string result = "";
			for( int index = 0; index < Count; index++ )
			{
				result += Data;
			}
			return result;
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                       --- ｽｸﾚｲﾋﾟﾝｸﾞｸﾗｽ ---                        */
	/*                          URLからﾃﾞｰﾀ取得                          */
	/*                                                                   */
	/*********************************************************************/
	public static class Scraping
	{
		/*************************/
		/*   Htmlの文字列取得    */
		/*************************/
		public static string GetHtmlText( string Url )
		{
			try
			{
				string     str      = "";
				WebRequest rq       = WebRequest.Create( Url );
				Encoding   encoding = Encoding.GetEncoding( "EUC-JP" );
 
				using( WebResponse res = rq.GetResponse() )
				{
					using( Stream stream = res.GetResponseStream() )
					{
						using( StreamReader sr = new StreamReader( stream, encoding ))
						{
							str = sr.ReadToEnd();
						}
					}
				}
 
				return str;
			}
			catch
			{
				return "";
			}
		}
		/*************************/
		/*      ﾚｰｽ情報取得      */
		/*************************/
		// Info        ：馬情報へのｾｯﾄ
		// Url         ：情報取得URL
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public static bool GetRaceInfo( RaceInfo Info, string Url, EventHandler MessageEvent )
		{
			try
			{
				/* ---< 引数ﾁｪｯｸ >--- */
				if(( Info == null ) || ( Url == null ) || ( Url == "" ))
				{
					return false;
				}

				string htmlText = GetHtmlText( Url );
				if( htmlText == "" )
				{
					return false;
				}
				var htmlDoc = new HtmlAgilityPack.HtmlDocument();
				htmlDoc.LoadHtml( htmlText );

				// ﾚｰｽ情報全体の取得
				var nodes = htmlDoc.DocumentNode.SelectNodes( "//div[starts-with(@class, \"RaceList_NameBox\")]" );
				if( nodes == null )
				{
					return false;
				}

				// ﾚｰｽ番号取得
				htmlDoc.LoadHtml( nodes[ 0 ].InnerHtml );
				HtmlNodeCollection node = htmlDoc.DocumentNode.SelectNodes( "//span[starts-with(@class, \"RaceNum\")]" );
				if( node != null )
				{
					Info.RaceNum.Data = GetInnerStr( node[ 0 ] );
				}
				else
				{
					node = htmlDoc.DocumentNode.SelectNodes( "//div[starts-with(@class, \"Race_Num\")]" );
					if( node != null )
					{
						Info.RaceNum.Data = GetInnerStr( node[ 0 ] );
					}
				}

				// ﾚｰｽ名取得
				node = htmlDoc.DocumentNode.SelectNodes( "//div[starts-with(@class, \"RaceName\")]" );
				if( node != null )
				{
					Info.RaceName.Data = GetInnerStr( node[ 0 ] );
				}

				// ﾚｰｽﾃﾞｰﾀ取得
				node = htmlDoc.DocumentNode.SelectNodes( "//div[starts-with(@class, \"RaceData01\")]" );
				if( node != null )
				{
					string   tempStr = GetInnerStr( node[ 0 ] ).Replace( "発走", "" );			// Split後にﾘﾌﾟﾚｰｽできなかったのでここで削除
					string[] words   = tempStr.Split( '/' );

					Info.StartTime.Data = words[ 0 ];											// 発走時間

					if( words[ 1 ].Contains( "芝" ))											// 芝・ﾀﾞｰﾄ
					{
						Info.TurfDirt.Data = "芝";
					}
					if( words[ 1 ].Contains( "ダ" ))
					{
						Info.TurfDirt.Data = "ダ";
					}

					tempStr = Regex.Replace( words[ 1 ], @"[^0-9]", "" );						// 数値切り出し
					if( Int32.TryParse( tempStr, out int result ))
					{
						Info.Distance.Data = result;
					}
				}
				return true;
			}
			finally
			{
			}
		}
		/*************************/
		/*      馬情報取得       */
		/*************************/
		// Info        ：馬情報へのｾｯﾄ
		// Url         ：情報取得URL
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public static bool GetHorseInfo( List<HorseInfo> Info, string Url, EventHandler MessageEvent )
		{
			try
			{
				/* ---< 引数ﾁｪｯｸ >--- */
				if(( Info == null ) || ( Url == null ) || ( Url == "" ))
				{
					return false;
				}

				/* ---< 開始した事をﾀﾞﾐｰで表示 >--- */
				Message.SendMessage_Progress( MessageType.Mes_Progress, 10, 1, MessageEvent );

				string htmlText = GetHtmlText( Url );
				if( htmlText == "" )
				{
					return false;
				}
				var htmlDoc = new HtmlAgilityPack.HtmlDocument();
				htmlDoc.LoadHtml( htmlText );
				var nodes = htmlDoc.DocumentNode.SelectNodes( "//tr[@class=\"HorseList\"]" );
				if( nodes == null )
				{
					return false;
				}

				// 馬情報ｸﾘｱ
				Info.Clear();
				for( int index = 0; index < nodes.Count; index++ )
				{
					/* ---< 進行状態通知 >--- */
					Message.SendMessage_Progress( MessageType.Mes_Progress, nodes.Count, index, MessageEvent );

					// 各馬毎の馬情報取得
					GetHorseInfo( nodes[ index ], out HorseInfo info );
					// 各馬毎の馬情報ｾｯﾄ
					Info.Add( info );
				}
				return true;
			}
			finally
			{
				/* ---< 完了通知 >--- */
				Message.SendMessage_Progress( MessageType.Mes_ProgressEnd, 0, 0, MessageEvent );
			}
		}
		// Node：馬情報が入ったURL内ﾉｰﾄﾞ
		// Info：取得した馬情報
		private static void GetHorseInfo( HtmlNode Node, out HorseInfo Info )
		{
			Info = new HorseInfo();

			var htmlDoc = new HtmlAgilityPack.HtmlDocument();
			htmlDoc.LoadHtml( Node.InnerHtml );
			string strData;

			// 枠番取得
			var nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Waku\")]" );
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得
				if( Int32.TryParse( strData, out int result ))
				{
					Info.WakuNum.Data = result;
				}
			}
			// 馬番取得
			nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Umaban\")]" );
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得
				if( Int32.TryParse( strData, out int result ))
				{
					Info.HorseNum.Data = result;
				}
			}
			// 馬名取得
			nodes = htmlDoc.DocumentNode.SelectNodes( "//span[starts-with(@class, \"HorseName\")]" );
			if( nodes != null )
			{
				strData = nodes[ 0 ].InnerText.ToString().Replace( "\n", "" );				// ﾉｰﾄﾞ内の文字列取得(改行無視)
				Info.Horse.Data = strData;
				foreach( HtmlNode child in nodes[ 0 ].ChildNodes )
				{
					strData = child.GetAttributeValue( "href", null );
					if(( strData != null ) && ( strData != "" ))
					{
						Info.HorseLink.Data = strData;
						break;
					}
				}
			}
			// 馬齢性別取得
			// 地方競馬の場合
			nodes = htmlDoc.DocumentNode.SelectNodes( "//span[starts-with(@class, \"Age\")]" );
			if( nodes == null )
			{
				// 中央競馬の場合
				nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Barei\")]" );
			}
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得
				if( strData.Contains( "牡" ))
				{
					Info.Gender.Data = "牡";
				}
				if( strData.Contains( "牝" ))
				{
					Info.Gender.Data = "牝";
				}
				if( strData.Contains( "セ" ))
				{
					Info.Gender.Data = "セ";
				}
				if( Info.Gender.Data != "" )
				{
					if( Int32.TryParse( strData.Replace( Info.Gender.Data, "" ), out int result ))
					{
						Info.Age.Data = result;
					}
				}
			}
			// 斤量取得
			nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Txt_C\")]" );
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得
				if( Double.TryParse( strData, out double result ))
				{
					Info.Weight.Data = result;
				}
			}
			// 騎手取得
			// 地方競馬の場合
			nodes = htmlDoc.DocumentNode.SelectNodes( "//span[starts-with(@class, \"Jockey\")]" );
			if( nodes == null )
			{
				// 中央競馬の場合
				nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Jockey\")]" );
			}
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得
				Info.Jockey.Data = strData;
				foreach( HtmlNode child in nodes[ 0 ].ChildNodes )
				{
					strData = child.GetAttributeValue( "href", null );
					if(( strData != null ) && ( strData != "" ))
					{
						Info.JockeyLink.Data = strData;
						break;
					}
				}
			}
			// 厩舎取得
			nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Trainer\")]" );
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得
				Info.Barn.Data = strData;
			}
			// 馬体重取得
			nodes = htmlDoc.DocumentNode.SelectNodes( "//td[starts-with(@class, \"Weight\")]" );
			if( nodes != null )
			{
				strData = GetInnerStr( nodes[ 0 ] );										// ﾉｰﾄﾞ内の文字列取得

				GetUmaWeight( strData, out double weight, out double weightDiff );
				Info.HorseWeight.Data     = weight;
				Info.HorseWeightDiff.Data = weightDiff;
			}
		}
		/*************************/
		/*     履歴情報取得      */
		/*************************/
		// db_main_race を SelectNodes しても null がかえってしまう
		// 2爪の db_main_delta をとれば何とか取得できた
		//	<div class="db_main_race">
		//		<div class="db_main_delta">					2つ目の db_main_delta
		//			・・・・・
		//			<table cellpadding・・・>				ﾚｰｽ履歴ﾃｰﾌﾞﾙ先頭
		//				<thead>・・・</thead>				ﾚｰｽ履歴ﾃｰﾌﾞﾙのﾀｲﾄﾙ
		//				<tbody>								ﾚｰｽ履歴ﾃｰﾌﾞﾙの履歴情報先頭
		//					<tr class>・・・</tr>			ﾚｰｽ履歴ﾃｰﾌﾞﾙの履歴情報本体・・・・ここを取得
		//					<tr class>・・・</tr>
		//					<tr class>・・・</tr>
		//					<tr class>・・・</tr>
		//					<tr class>・・・</tr>
		//				</tbody>
		//			</table>
		//		</div>
		//	</div>
		//
		// Info        ：馬情報へのｾｯﾄ
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public static void GetHistoryInfo( List<HorseInfo> Info, EventHandler MessageEvent )
		{
			try
			{
				/* ---< 引数ﾁｪｯｸ >--- */
				if(( Info == null ) || ( Info.Count == 0 ))
				{
					return;
				}

				/* ---< 開始した事をﾀﾞﾐｰで表示 >--- */
				Message.SendMessage_Progress( MessageType.Mes_Progress, 10, 1, MessageEvent );

				for( int index = 0; index < Info.Count; index++ )
				{
					/* ---< 進行状態通知 >--- */
					Message.SendMessage_Progress( MessageType.Mes_Progress, Info.Count, index, MessageEvent );

					if(( Info[ index ].HorseLink == null ) || ( Info[ index ].HorseLink.Data == "" ))
					{
						continue;
					}

					Info[ index ].History.Clear();											// 履歴ｸﾘｱ
					string htmlText = GetHtmlText( Info[ index ].HorseLink.Data );			// ﾘﾝｸ無しはｽﾙｰ
					if( htmlText == "" )
					{
						continue;
					}

					var htmlDoc = new HtmlAgilityPack.HtmlDocument();
					htmlDoc.LoadHtml( htmlText );
					var nodes = htmlDoc.DocumentNode.SelectNodes( "//div[@class=\"db_main_deta\"]" );

					for( int index_1 = 0; index_1 < nodes[ 1 ].ChildNodes.Count; index_1++ )
					{
						var node_1 = nodes[ 1 ].ChildNodes[ index_1 ];
						if( node_1.Name != "table" )										// ﾚｰｽ履歴ﾃｰﾌﾞﾙ先頭
						{
							continue;
						}

						List<HtmlNode> race = new List<HtmlNode>();
						for( int index_2 = 0; index_2 < node_1.ChildNodes.Count; index_2++ )
						{
							var node_2 = node_1.ChildNodes[ index_2 ];
							if( node_2.Name != "tbody" )									// ﾚｰｽ履歴ﾃｰﾌﾞﾙの履歴情報先頭
							{
								continue;
							}

							for( int index_3 = 0; index_3 < node_2.ChildNodes.Count; index_3++ )
							{
								var node_3 = node_2.ChildNodes[ index_3 ];
								if( node_3.Name != "tr" )									// ﾚｰｽ履歴ﾃｰﾌﾞﾙの履歴情報本体
								{
									continue;
								}
								race.Add( node_3 );
							}
							break;
						}
						GetHistoryInfo( Info[ index ], race );
						break;
					}
				}
			}
			finally
			{
				/* ---< 完了通知 >--- */
				Message.SendMessage_Progress( MessageType.Mes_ProgressEnd, 0, 0, MessageEvent );
			}
		}
		// 指定馬の馬情報ｵﾌﾞｼﾞｪｸﾄに全履歴情報をｾｯﾄする
		// Info：指定馬の馬情報
		// Race：指定馬の全履歴情報
		private static void GetHistoryInfo( HorseInfo Info, List<HtmlNode> Race )
		{
			/* ---< 引数ﾁｪｯｸ >--- */
			if(( Info == null ) || ( Race == null ) || ( Race.Count == 0 ))
			{
				return;
			}

			foreach( HtmlNode race in Race )
			{
				GetHistoryInfo( Info, race );
			}
		}
		// 指定馬の馬情報ｵﾌﾞｼﾞｪｸﾄに1つの履歴情報をｾｯﾄする
		// Info：指定馬の馬情報
		// Race：指定馬の1つの履歴情報
		private static void GetHistoryInfo( HorseInfo Info, HtmlNode Race )
		{
			/* ---< 引数ﾁｪｯｸ >--- */
			if(( Info == null ) || ( Race == null ))
			{
				return;
			}
			HistoryInfo data    = new HistoryInfo();
			int         tdCount = 0;

			for( int index = 0; index < Race.ChildNodes.Count; index++ )
			{
				var node = Race.ChildNodes[ index ];
				if( node.Name != "td" )														// ﾚｰｽ履歴ﾃｰﾌﾞﾙの履歴情報本体
				{
					continue;
				}
				string   strData = GetInnerStr( node );										// ﾉｰﾄﾞ内の文字列取得
				string[] words;

				if(( strData == null ) || ( strData == "" ))
				{
					tdCount++;
					continue;
				}

				bool intEnabled = Int32.TryParse(  strData, out int    intData );
				bool dblEnabled = Double.TryParse( strData, out double dblData );

				int      tempInt;
				string   tempStr;
				char[]   removeNum  = new char[] {                '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'  };
				char[]   removeTime = new char[] { ' ', ':', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'  };
				char[]   removePos  = new char[] { ' ', '-',      '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'  };

				// Html内の格納順
				switch( tdCount )
				{
					case 0:																	// 日付
						data.H_Date.Data      = strData;
						break;
					case 1:																	// 開催
						strData = Utility.RemoveChar( strData, removeNum );					// 数値削除
						if( strData != "" )
						{
							data.H_Track.Data = strData;
						}
						break;
					case 2:																	// 天気
						data.H_Weather.Data   = strData;
						break;
					case 3:																	// ﾚｰｽ番号
						if( intEnabled ){ data.H_RaceNum.Data   = intData; }
						break;
					case 4:																	// ﾚｰｽ名
						data.H_RaceName.Data  = strData;
						break;
					case 5:																	// 映像(なし)
						break;
					case 6:																	// 頭数
						if( intEnabled ){ data.H_Starters.Data  = intData; }
						break;
					case 7:																	// 枠番
						if( intEnabled ){ data.H_WakuNum.Data   = intData; }
						break;
					case 8:																	// 馬番
						if( intEnabled ){ data.H_HorseNum.Data  = intData; }
						break;
					case 9:																	// ｵｯｽﾞ
						if( dblEnabled ){ data.H_Odds.Data      = dblData; }
						break;
					case 10:																// 人気
						if( intEnabled ){ data.H_Favorite.Data  = intData; }
						break;
					case 11:																// 着順
						if( intEnabled ){ data.H_Result.Data    = intData; }
						break;
					case 12:																// 騎手
						data.H_Jockey.Data    = strData;

						foreach( HtmlNode child in node.ChildNodes )						// 騎手ﾘﾝｸ
						{
							strData = child.GetAttributeValue( "href", null );
							if(( strData != null ) && ( strData != "" ))
							{
								data.H_JockeyLink.Data = strData;
								break;
							}
						}
						break;
					case 13:																// 斤量
						if( dblEnabled ){ data.H_Weight.Data    = dblData; }
						break;
					case 14:																// 距離
						tempStr = Regex.Replace( strData, @"[^0-9]", "" );					// 数値切り出し
						data.H_TurfDirt.Data = strData.Replace( tempStr, "" );				// 芝・ﾀﾞｰﾄ
						if( Int32.TryParse( tempStr, out tempInt ))							// 距離
						{
							data.H_Distance.Data = tempInt;
						}
						break;
					case 15:																// 馬場(重稍など)
						data.H_Condition.Data = strData;
						break;
					case 16:																// 馬場指数(なし)
						break;
					case 17:																// ﾀｲﾑ
						if( "" == Utility.RemoveChar( strData, removeTime ))				// ﾀｲﾑﾃﾞｰﾀに使用される文字を削除して、なしならﾀｲﾑﾃﾞｰﾀ
						{
							data.H_Finish.Data = strData;
						}
						break;
					case 18:																// 着差
						if( dblEnabled ){ data.H_Margin.Data    = dblData; }
						break;
					case 19:																// ﾀｲﾑ指数(なし)
						break;
					case 20:																// 通過
						if( "" == Utility.RemoveChar( strData, removePos ))					// 通過ﾃﾞｰﾀに使用される文字を削除して、なしなら通過ﾃﾞｰﾀ
						{
							strData = strData.Replace( "-", "_" );							// ｴｸｾﾙで日付に変更される事への対応
							data.H_Position.Data  = strData;								// ('を先頭につけるのは、ｴｸｾﾙの最初の表示で'が表示されてしまう)
						}
						break;
					case 21:																// ﾍﾟｰｽ
						words = strData.Split('-');
						if( words?.Length == 2 )
						{
							if( Double.TryParse( words[ 0 ], out dblData ) )
							{
								data.H_Pace_1.Data = dblData;
							}
							if( Double.TryParse( words[ 1 ], out dblData ) )
							{
								data.H_Pace_2.Data = dblData;
							}
						}
						break;
					case 22:																// 上り_3F
						if( dblEnabled ){ data.H_Pace_3F.Data   = dblData; }
						break;
					case 23:
						if( GetUmaWeight( strData, out double weight, out double weightDiff ))
						{
							data.H_HorseWeight.Data     = weight;
							data.H_HorseWeightDiff.Data = weightDiff;
						}
						break;
					case 24:																// 厩舎ｺﾒﾝﾄ
					case 25:																// 備考
					case 26:																// 勝ち馬(2着馬)
					case 27:																// 賞金
						break;
				}
				tdCount++;
			}
			Info.History.Add( data );
		}
		/*************************/
		/*      馬体重取得       */
		/*************************/
		// Str："450(+2)" の形式を 450 と 2 として取得する
		private static bool GetUmaWeight( string Str, out double Weight, out double WeightDiff )
		{
			Weight     = 0;
			WeightDiff = 0;

			string[] words;
			words = Str.Split('(');
			if( words?.Length != 2 )
			{
				return false;
			}
			words[ 1 ] = words[ 1 ].Replace( ")", "" );

			if( !Double.TryParse( words[ 0 ], out Weight ))
			{
				return false;
			}
			if( !Double.TryParse( words[ 1 ], out WeightDiff ))
			{
				return false;
			}
			return true;
		}
		/*************************/
		/*    ﾉｰﾄﾞ内ﾃｷｽﾄ取得     */
		/*************************/
		private static string GetInnerStr( HtmlNode Node )
		{
			if( Node == null )
			{
				return "";
			}

			string  strData = Node.InnerText.ToString();

			strData = strData.Replace( "\n", "" );											// 改行無視
			strData = strData.Replace( " ",  "" );											// ｽﾍﾟｰｽ無視

			return strData;
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                          --- 情報ｸﾗｽ ---                          */
	/*                                                                   */
	/*********************************************************************/
	/*************************/
	/*      ﾚｰｽ情報ｸﾗｽ       */
	/*************************/
	public class RaceInfo
	{
		public InfoData<string>  RaceNum           = new InfoData<string>( "" );			// ﾚｰｽ番号
		public InfoData<string>  RaceName          = new InfoData<string>( "" );			// ﾚｰｽ名
		public InfoData<string>  StartTime         = new InfoData<string>( "" );			// 発走時間
		public InfoData<string>  TurfDirt          = new InfoData<string>( "" );			// 芝・ﾀﾞｰﾄ
		public InfoData<int>     Distance          = new InfoData<int>( -1 );				// 距離
	}
	/*************************/
	/*       馬情報ｸﾗｽ       */
	/*************************/
	// ｵｯｽﾞと人気はうまく取れないので削除。多分随時変更して表示するので、最初の取得ﾄﾞｷｭﾒﾝﾄに表示ﾃﾞｰﾀが入ってこない為と思われる
	public class HorseInfo
	{
		public InfoData<int>     WakuNum           = new InfoData<int>( -1 );				// 枠番
		public InfoData<int>     HorseNum          = new InfoData<int>( -1 );				// 馬番
		public InfoData<string>  Horse             = new InfoData<string>( "" );			// 馬名
		public InfoData<string>  HorseLink         = new InfoData<string>( "" );			// 馬名ﾘﾝｸ
		public InfoData<string>  Gender            = new InfoData<string>( "" );			// 性別
		public InfoData<int>     Age               = new InfoData<int>( -1 );				// 年齢
		public InfoData<double>  Weight            = new InfoData<double>();				// 斤量
		public InfoData<string>  Jockey            = new InfoData<string>( "" );			// 騎手
		public InfoData<string>  JockeyLink        = new InfoData<string>( "" );			// 騎手ﾘﾝｸ
		public InfoData<string>  Barn              = new InfoData<string>( "" );			// 厩舎
		public InfoData<double>  HorseWeight       = new InfoData<double>();				// 馬体重
		public InfoData<double>  HorseWeightDiff   = new InfoData<double>();				// 馬体重差
		public List<HistoryInfo> History           = new List<HistoryInfo>();				// 履歴情報
	}
	/*************************/
	/*      履歴情報ｸﾗｽ      */
	/*************************/
	public class HistoryInfo
	{
		public InfoData<string>  H_Date            = new InfoData<string>( "" );			// 日付
		public InfoData<string>  H_Track           = new InfoData<string>( "" );			// 場所
		public InfoData<string>  H_Weather         = new InfoData<string>( "" );			// 天気
		public InfoData<int>     H_RaceNum         = new InfoData<int>( -1 );				// ﾚｰｽ番号
		public InfoData<string>  H_RaceName        = new InfoData<string>( "" );			// ﾚｰｽ名
		public InfoData<int>     H_Starters        = new InfoData<int>( -1 );				// 頭数
		public InfoData<int>     H_WakuNum         = new InfoData<int>( -1 );				// 枠番
		public InfoData<int>     H_HorseNum        = new InfoData<int>( -1 );				// 馬番
		public InfoData<double>  H_Odds            = new InfoData<double>();				// ｵｯｽﾞ
		public InfoData<int>     H_Favorite        = new InfoData<int>( -1 );				// 人気
		public InfoData<int>     H_Result          = new InfoData<int>( -1 );				// 着順
		public InfoData<string>  H_Jockey          = new InfoData<string>( "" );			// 騎手
		public InfoData<string>  H_JockeyLink      = new InfoData<string>( "" );			// 騎手ﾘﾝｸ
		public InfoData<double>  H_Weight          = new InfoData<double>();				// 斤量
		public InfoData<string>  H_TurfDirt        = new InfoData<string>();				// 芝・ﾀﾞｰﾄ
		public InfoData<int>     H_Distance        = new InfoData<int>( -1 );				// 距離
		public InfoData<string>  H_Condition       = new InfoData<string>( "" );			// 馬場(重稍など)
		public InfoData<string>  H_Finish          = new InfoData<string>( "" );			// ﾀｲﾑ
		public InfoData<double>  H_Margin          = new InfoData<double>();				// 着差
		public InfoData<string>  H_Position        = new InfoData<string>( "" );			// 通過
		public InfoData<double>  H_Pace_1          = new InfoData<double>();				// ﾍﾟｰｽ_1
		public InfoData<double>  H_Pace_2          = new InfoData<double>();				// ﾍﾟｰｽ_2
		public InfoData<double>  H_Pace_3F         = new InfoData<double>();				// 上り_3F
		public InfoData<double>  H_HorseWeight     = new InfoData<double>();				// 馬体重
		public InfoData<double>  H_HorseWeightDiff = new InfoData<double>();				// 馬体重差
	}
	public class InfoData<T>
	{
		private T                gData             = default(T);							// ﾃﾞｰﾀ
		private bool             gEnabled          = false;									// ﾃﾞｰﾀ有効無効

		/*************************/
		/*        ｺﾝｽﾄﾗｸﾀ        */
		/*************************/
		public InfoData()
		{
		}
		public InfoData( T Dat )
		{
			gData = Dat;
		}
		/*************************/
		/*        ﾌﾟﾛﾊﾟﾃｨ        */
		/*************************/
		public T  Data
		{
			get { return gData;  }
			set
				{
					gEnabled = true;
					gData    = value;
				}
		}
		/*************************/
		/*    ﾃﾞｰﾀ文字列取得     */
		/*************************/
		public string GetDataStr()
		{
			if( gEnabled )
			{
				return gData.ToString();
			}
			return "";
		}
	}
	/*************************/
	/*      ﾚｰｽ文字ｸﾗｽ       */
	/*************************/
	public static class RaceText
	{
		private static readonly string[] gRace            = new string[]
		{
			"今回のﾚｰｽ",
			"This race"
		};
		private static readonly string[] gHistory         = new string[]
		{
			"過去のﾚｰｽ",
			"Past races"
		};
		private static readonly string[] gLayout          = new string[]
		{
			"出力ﾚｲｱｳﾄ",
			"Output layout"
		};
		private static readonly string[] gCascade         = new string[]
		{
			"ｶｽｹｰﾄﾞ",
			"Cascade"
		};
		private static readonly string[] gTile            = new string[]
		{
			"ﾀｲﾙ",
			"Tilet"
		};
		private static readonly string[] gHcount          = new string[]
		{
			"過去のﾚｰｽ数",
			"Races"
		};
		private static readonly string[] gOpenUrlJra      = new string[]
		{
			"JRA競馬",
			"Open JRA"
		};
		private static readonly string[] gOpenUrlLocal    = new string[]
		{
			"地方競馬",
			"Open Local"
		};
		private static readonly string[] gDownload        = new string[]
		{
			"URL ﾀﾞｳﾝﾛｰﾄﾞ",
			"URL Download"
		};
		private static readonly string[] gClipboard       = new string[]
		{
			"ｸﾘｯﾌﾟﾎﾞｰﾄﾞへ",
			"To Clipboard"
		};
		private static readonly string[] gFile            = new string[]
		{
			"Csvﾌｧｲﾙへ",
			"To Csv file"
		};
		private static readonly string[] gSaveFile        = new string[]
		{
			"保存先のファイルを選択してください",
			"Save File"
		};


		private static readonly string[] gTurf            = new string[]
		{
			"芝",
			"Turf"
		};
		private static readonly string[] gDirt            = new string[]
		{
			"ダ",
			"Dirt"
		};
		private static readonly string[] gSunny           = new string[]
		{
			"晴",
			"Sunny"
		};
		private static readonly string[] gCloudy          = new string[]
		{
			"曇",
			"Cloudy"
		};
		private static readonly string[] gLightRain       = new string[]
		{
			"小雨",
			"Light Rain"
		};
		private static readonly string[] gRain            = new string[]
		{
			"雨",
			"Rain"
		};
		private static readonly string[] gSnow            = new string[]
		{
			"雪",
			"Snow"
		};
		private static readonly string[] gFirm            = new string[]
		{
			"良",
			"Firm"
		};
		private static readonly string[] gGood           = new string[]
		{
			"稍",
			"Good"
		};
		private static readonly string[] gYielding       = new string[]
		{
			"重",
			"Yielding"
		};
		private static readonly string[] gSoft           = new string[]
		{
			"不",
			"Soft"
		};
		private static readonly string[] gStandard       = new string[]
		{
			"良",
			"Standard"
		};
		private static readonly string[] gMuddy          = new string[]
		{
			"重",
			"Muddy"
		};
		private static readonly string[] gSloppy         = new string[]
		{
			"不",
			"Sloppy"
		};

		private static readonly string[] gWakuNum         = new string[]
		{
			"枠番",
			"Bracket number"
		};
		private static readonly string[] gHorseNum        = new string[]
		{
			"馬番",
			"Hourse number"
		};
		private static readonly string[] gHorse           = new string[]
		{
			"馬名",
			"Horse"
		};
		private static readonly string[] gGender          = new string[]
		{
			"性別",
			"Gender"
		};
		private static readonly string[] gAge             = new string[]
		{
			"年齢",
			"Age"
		};
		private static readonly string[] gWeight          = new string[]
		{
			"斤量",
			"Weight"
		};
		private static readonly string[] gJockey          = new string[]
		{
			"騎手",
			"Jockey"
		};
		private static readonly string[] gBarn            = new string[]
		{
			"厩舎",
			"Barn"
		};
		private static readonly string[] gHorseWeight     = new string[]
		{
			"馬体重",
			"Horse weight"
		};
		private static readonly string[] gHorseWeightDiff = new string[]
		{
			"馬体重差",
			"Horse weight(Diff)"
		};
		private static readonly string[] gOdds            = new string[]
		{
			"ｵｯｽﾞ",
			"Odds"
		};
		private static readonly string[] gFavorite        = new string[]
		{
			"人気",
			"Favorite"
		};
		private static readonly string[] gDate            = new string[]
		{
			"日付",
			"Date"
		};
		private static readonly string[] gTrack           = new string[]
		{
			"競馬場",
			"Track"
		};
		private static readonly string[] gWeather         = new string[]
		{
			"天気",
			"Weather"
		};
		private static readonly string[] gRaceNum         = new string[]
		{
			"ﾚｰｽ番号",
			"Race number"
		};
		private static readonly string[] gRaceName        = new string[]
		{
			"ﾚｰｽ名",
			"Race name"
		};
		private static readonly string[] gStarters        = new string[]
		{
			"頭数",
			"Starters"
		};
		private static readonly string[] gResult          = new string[]
		{
			"着順",
			"Result"
		};
		private static readonly string[] gTurfDirt        = new string[]
		{
			"芝/ﾀﾞｰﾄ",
			"Turf/Dirt"
		};
		private static readonly string[] gDistance        = new string[]
		{
			"距離",
			"Distance"
		};
		private static readonly string[] gCondition       = new string[]
		{
			"馬場状態",
			"Condition"
		};
		private static readonly string[] gFinish          = new string[]
		{
			"ﾀｲﾑ",
			"Finish"
		};
		private static readonly string[] gMargin          = new string[]
		{
			"着差",
			"Margin"
		};
		private static readonly string[] gPosition        = new string[]
		{
			"位置取り",
			"Position"
		};
		private static readonly string[] gPace_1          = new string[]
		{
			"ﾍﾟｰｽ_1",
			"Pace_1"
		};
		private static readonly string[] gPace_2          = new string[]
		{
			"ﾍﾟｰｽ_2",
			"Pace_2"
		};
		private static readonly string[] gPace_3F         = new string[]
		{
			"上り_3F",
			"Pace_3F"
		};

		/*************************/
		/*        ﾌﾟﾛﾊﾟﾃｨ        */
		/*************************/
		public static string Race        
		{
			get { return gRace[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string History        
		{
			get { return gHistory[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Layout        
		{
			get { return gLayout[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Cascade        
		{
			get { return gCascade[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Tile        
		{
			get { return gTile[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Hcount        
		{
			get { return gHcount[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string OpenUrlJra        
		{
			get { return gOpenUrlJra[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string OpenUrlLocal        
		{
			get { return gOpenUrlLocal[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Download        
		{
			get { return gDownload[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Clipboard        
		{
			get { return gClipboard[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string File        
		{
			get { return gFile[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string SaveFile        
		{
			get { return gSaveFile[ (int)AppInfo.AppSetting.Lanuage ]; }
		}

		public static string Turf        
		{
			get { return gTurf[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Dirt        
		{
			get { return gDirt[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Sunny
		{
			get { return gSunny[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Cloudy
		{
			get { return gCloudy[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string LightRain
		{
			get { return gLightRain[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Rain
		{
			get { return gRain[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Snow
		{
			get { return gSnow[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		private static string Firm
		{
			get { return gFirm[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Good
		{
			get { return gGood[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Yielding
		{
			get { return gYielding[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Soft
		{
			get { return gSoft[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Standard
		{
			get { return gStandard[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Muddy
		{
			get { return gMuddy[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Sloppy
		{
			get { return gSloppy[ (int)AppInfo.AppSetting.Lanuage ]; }
		}

		public static string WakuNum       
		{
			get { return gWakuNum[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string HorseNum       
		{
			get { return gHorseNum[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Horse          
		{
			get { return gHorse[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Gender         
		{
			get { return gGender[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Age            
		{
			get { return gAge[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Weight         
		{
			get { return gWeight[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Jockey         
		{
			get { return gJockey[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Barn           
		{
			get { return gBarn[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string HorseWeight    
		{
			get { return gHorseWeight[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string HorseWeightDiff
		{
			get { return gHorseWeightDiff[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Odds           
		{
			get { return gOdds[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Favorite       
		{
			get { return gFavorite[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Date           
		{
			get { return gDate[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Track          
		{
			get { return gTrack[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Weather        
		{
			get { return gWeather[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string RaceNum        
		{
			get { return gRaceNum[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string RaceName       
		{
			get { return gRaceName[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Starters       
		{
			get { return gStarters[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Result         
		{
			get { return gResult[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string TurfDirt       
		{
			get { return gTurfDirt[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Distance       
		{
			get { return gDistance[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Condition      
		{
			get { return gCondition[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Finish         
		{
			get { return gFinish[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Margin         
		{
			get { return gMargin[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Position       
		{
			get { return gPosition[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Pace_1         
		{
			get { return gPace_1[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Pace_2         
		{
			get { return gPace_2[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Pace_3F        
		{
			get { return gPace_3F[ (int)AppInfo.AppSetting.Lanuage ]; }
		}

		/*************************/
		/*      性別の取得       */
		/*************************/
		// 牡馬の場合は4歳以下がc（colt）、 5歳以上はh（horse）
		// 牝馬の場合は4歳以下がf（filly）、5歳以上がm（mare）
		// セン馬は年齢に関係なくg（gelding）
		public static string GetGender( int _Age, string Japanese )
		{
			if( _Age != 0 )
			{
				if( _Age <= 4 )
				{
					if( Japanese == "牡" ){ return "C"; }
					if( Japanese == "牝" ){ return "F"; }
					if( Japanese == "セ" ){ return "G"; }
				}
				else
				{
					if( Japanese == "牡" ){ return "H"; }
					if( Japanese == "牝" ){ return "M"; }
					if( Japanese == "セ" ){ return "G"; }
				}
			}
			return Japanese;
		}
		/*************************/
		/*      天気の取得       */
		/*************************/
		public static string GetWeather( string Japanese )
		{
			if( Japanese == gSunny[ (int)LanguageType.enJapanese ] )
			{
				return Sunny;
			}
			if( Japanese == gCloudy[ (int)LanguageType.enJapanese ] )
			{
				return Cloudy;
			}
			if( Japanese == gLightRain[ (int)LanguageType.enJapanese ] )
			{
				return LightRain;
			}
			if( Japanese == gRain[ (int)LanguageType.enJapanese ] )
			{
				return Rain;
			}
			if( Japanese == gSnow[ (int)LanguageType.enJapanese ] )
			{
				return Snow;
			}
			return Japanese;
		}
		/*************************/
		/*     芝/ﾀﾞｰﾄの取得     */
		/*************************/
		public static string GetTurfDirt( string Japanese )
		{
			if( Japanese == gTurf[ (int)LanguageType.enJapanese ] )
			{
				return Turf;
			}
			if( Japanese == gDirt[ (int)LanguageType.enJapanese ] )
			{
				return Dirt;
			}
			return Japanese;
		}
		/*************************/
		/*    馬場状態の取得     */
		/*************************/
		// https://nidangyakufunsha.com/dictionary/track_condition.html
		// 芝
		// 日本				良			稍重		重			不良
		// 日本(英語表記)	Firm		Good		Yielding	Soft
		// ﾀﾞｰﾄ/ｵｰﾙｳｪｻﾞｰ
		// 日本				良			稍重		重			不良
		// 日本(英語表記)	Standard	Good		Muddy		Sloppy
		public static string GetCondition( string _TurfDirt, string Japanese )
		{
			if( _TurfDirt == Turf )
			{
				if( Japanese == gFirm[ (int)LanguageType.enJapanese ] )
				{
					return Firm;
				}
				if( Japanese == gGood[ (int)LanguageType.enJapanese ] )
				{
					return Good;
				}
				if( Japanese == gYielding[ (int)LanguageType.enJapanese ] )
				{
					return Yielding;
				}
				if( Japanese == gSoft[ (int)LanguageType.enJapanese ] )
				{
					return Soft;
				}
			}
			if( _TurfDirt == Dirt )
			{
				if( Japanese == gStandard[ (int)LanguageType.enJapanese ] )
				{
					return Standard;
				}
				if( Japanese == gGood[ (int)LanguageType.enJapanese ] )
				{
					return Good;
				}
				if( Japanese == gMuddy[ (int)LanguageType.enJapanese ] )
				{
					return Muddy;
				}
				if( Japanese == gSloppy[ (int)LanguageType.enJapanese ] )
				{
					return Sloppy;
				}
			}
			return Japanese;
		}
	}
	/*************************/
	/*       ﾚｰｽｴﾗｰｸﾗｽ       */
	/*************************/
	public static class RaceErrorText
	{
		private static readonly string[] gUrlIsResult     = new string[]
		{
			"ﾚｰｽ結果は取り込めません",
			"Can't import race results"
		};

		public static string UrlIsResult        
		{
			get { return gUrlIsResult[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
	}
}
