﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;
using System.Data;
using Microsoft.Win32;
using System.Net;
using System.Drawing.Drawing2D;
using System.Configuration;
using System.Security.Principal;

namespace SmallSolution_Race
{
	/*********************************************************************/
	/*                                                                   */
	/*                        --- 共通ﾃﾞｰﾀｸﾗｽ ---                        */
	/*                                                                   */
	/*********************************************************************/
	public enum LanguageType
	{
		enJapanese			= 0,															// 日本語
		enEnglish																			// 英語
	}
	public static class CommonText
	{
		private static readonly string[] gLanguage       = new string[]
		{
			"言語",
			"Language"
		};
		private static readonly string[] gJapanese       = new string[]
		{
			"日本語",
			"Japanese"
		};
		private static readonly string[] gEnglish        = new string[]
		{
			"英語",
			"English"
		};
		private static readonly string[] gProcessStandby = new string[]
		{
			"---",
			"---"
		};
		private static readonly string[] gProcess        = new string[]
		{
			"処理中",
			"Processing"
		};
		private static readonly string[] gProcessWarning = new string[]
		{
			"警告発生",
			"Warning"
		};
		private static readonly string[] gProcessError   = new string[]
		{
			"エラー発生",
			"Error"
		};
		private static readonly string[] gRestartError   = new string[]
		{
			"自動再起動に失敗しました。手動で再起動して下さい",
			"Failed to restart automatically. Reboot manually"
		};

		/*************************/
		/*        ﾌﾟﾛﾊﾟﾃｨ        */
		/*************************/
		public static string Language
		{
			get { return gLanguage[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Japanese
		{
			get { return gJapanese[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string English
		{
			get { return gEnglish[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string ProcessStandby
		{
			get { return gProcessStandby[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string Process
		{
			get { return gProcess[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string ProcessWarning
		{
			get { return gProcessWarning[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string ProcessError
		{
			get { return gProcessError[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
		public static string RestartError
		{
			get { return gRestartError[ (int)AppInfo.AppSetting.Lanuage ]; }
		}
	}
	public static class CommonValue
	{
		public const int    Dmmy               = 9;											// 一旦ﾀﾞﾐｰ置き
	}
	/*********************************************************************/
	/*                                                                   */
	/*                        --- Utilityｸﾗｽ ---                         */
	/*                                                                   */
	/*********************************************************************/
	public static class Utility
	{
		public static string RemoveChar( string Src, char[] RemoveChars )
		{
			foreach( char c in RemoveChars )
			{
				Src = Src.Replace( c.ToString(), "" );
			}
			return Src;
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                    --- ﾒｯｾｰｼﾞ通知とArgsｸﾗｽ ---                    */
	/*                                                                   */
	/*********************************************************************/
	public enum MessageType
	{
		Mes_Non				= 0,															// 無効
		Mes_Progress,																		// 計算中
		Mes_ProgressEnd,																	// 計算完了
		Mes_Warning,																		// 警告
		Mes_Error																			// ｴﾗｰ
	}
	/*************************/
	/*      ﾒｯｾｰｼﾞArgs       */
	/*************************/
	public class AppEventArgs : EventArgs
	{
		public  MessageType Type       = MessageType.Mes_Non;
		public  string      MessageStr = "";
		public  int         CrtCount   = 0;
		public  int         MaxCount   = 0;
		public  Exception   Except     = null;
	}
	/*************************/
	/*      ﾒｯｾｰｼﾞ処理       */
	/*************************/
	public static class Message
	{
		/*************************/
		/*      ﾒｯｾｰｼﾞ通知       */
		/*************************/
		// ﾒｯｾｰｼﾞを通知してargに応答を入れてもらい戻す
		// Type        ：ﾒｯｾｰｼﾞﾀｲﾌﾟ
		// MessageStr  ：ﾒｯｾｰｼﾞ
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public static AppEventArgs SendMessage(
			MessageType		Type,
			string			MessageStr,
			EventHandler	MessageEvent )
		{
			AppEventArgs arg = new AppEventArgs()
			{
				Type       = Type,
				MessageStr = MessageStr
			};
			MessageEvent?.Invoke( null, arg );

			return arg;
		}
		// 処理完了までの最大ｶｳﾝﾄを10分割してﾌﾟﾛｾｽの進行状況を通知する
		// Max=2000なら現在処理ｶｳﾝﾄ20回毎に通知し、計10回の通知を行う
		// Maxが10未満なら、処理ｶｳﾝﾄ1回毎に通知する(Max=10,dev=10)
		// Max：処理完了までの最大ｶｳﾝﾄ
		// Crt：現在の処理ｶｳﾝﾄ
		//
		// Type        ：ﾒｯｾｰｼﾞﾀｲﾌﾟ
		// Max         ：処理最大ｶｳﾝﾄ
		// Crt         ：処理現在ｶｳﾝﾄ
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public static void SendMessage_Progress(
			MessageType		Type,
			int				Max,
			int				Crt,
			EventHandler	MessageEvent )
		{
			/* ---< 引数ﾁｪｯｸ >---*/
			if( MessageEvent == null )
			{
				return;
			}

			AppEventArgs arg = new AppEventArgs();

			if( Max < 10 )
			{
				Max = 10;
			}

			int dev = 10;
			if( Max < dev )
			{
				dev = Max;
			}
			if( Crt % ( Max / dev ) == 0 )
			{
				// 進行中は、ﾌﾟﾛｸﾞﾚｽﾊﾞｰに最低1つはﾊﾞｰを表示する
				// その為、0ならMaxの1/10の値をｾｯﾄする
				if(  Crt / ( Max / dev ) == 0 )
				{
					arg.CrtCount = Max / 10;
				}
				else
				{
					arg.CrtCount = Crt;
				}
				arg.Type     = Type;
				arg.MaxCount = Max;
				MessageEvent?.Invoke( null, arg );
			}
		}
		// Type        ：ﾒｯｾｰｼﾞﾀｲﾌﾟ
		// MessageStr  ：ﾒｯｾｰｼﾞ
		// Except      ：例外内容
		// MessageEvent：ﾌﾟﾛｸﾞﾚｽ通知ﾊﾝﾄﾞﾗ
		public static void SendMessage_Error(
			MessageType		Type,
			string			MessageStr,
			Exception		Except,
			EventHandler	MessageEvent )
		{
			AppEventArgs arg = new AppEventArgs()
			{
				Type       = Type,
				MessageStr = MessageStr,
				Except     = Except
			};
			MessageEvent?.Invoke( null, arg );
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                            ﾕｰﾃｨﾘﾃｨｸﾗｽ                             */
	/*                    再起動ｸﾗｽ Utility_Restartｸﾗｽ                   */
	/*                                                                   */
	/*********************************************************************/
	public static class Utility_Restart
	{
		public static void ChangeLanguage( LanguageType Type, EventHandler MessageEvent )
		{
			if( AppInfo.AppSetting.Lanuage == Type )
			{
				return;
			}

			AppInfo.AppSetting.Lanuage = Type;
			AppInfo.AppSetting.Save();

			/* ---< 再起動 >--- */
			if( !Utility_Restart.RestartProgram())
			{
				/* ---< ﾒｯｾｰｼﾞ通知 >--- */
				Message.SendMessage_Error(
					MessageType.Mes_Error,
					CommonText.RestartError,
					null,
					MessageEvent );
			}
		}
		/*************************/
		/*         ﾘｽﾀｰﾄ         */
		/*************************/
		// ①自分のﾌﾟﾛｾｽIDを渡して2重起動をする
		// ②Program ｸﾗｽに RestartWait を配置して、旧ﾌﾟﾛｸﾞﾗﾑが終了するまで待つ
		public static bool RestartProgram()
		{
			string progName = Path.GetFileNameWithoutExtension(								// program.exe
				Assembly.GetExecutingAssembly().Location ) +
				Path.GetExtension( Assembly.GetExecutingAssembly().Location );
			string crtPath  = Directory.GetCurrentDirectory();
			try
			{
				// 第1引数：起動ﾌﾟﾛｸﾞﾗﾑ名
				// 第2引数：起動ﾌﾟﾛｸﾞﾗﾑへの引数
				Process.Start( crtPath + "\\" + progName, "/upDate " + Process.GetCurrentProcess().Id );
				Application.Exit();
				return true;
			}
			catch
			{
				return false;
			}
		}
		/*************************/
		/*       ﾘｽﾀｰﾄｳｴｲﾄ       */
		/*************************/
		public static void RestartWait()
		{
			// 引数を取得
			if( Environment.CommandLine.IndexOf( "/upDate", StringComparison.CurrentCultureIgnoreCase ) != -1 )
			{
				try
				{
					string[] args = Environment.GetCommandLineArgs();
					/* ---< 旧ﾌﾟﾛｸﾞﾗﾑのﾌﾟﾛｾｽID取得 >--- */
					int pid  = Convert.ToInt32( args[2] );
					/* ---< 旧ﾌﾟﾛｸﾞﾗﾑの終了待ち >--- */
					Process.GetProcessById( pid ).WaitForExit();
				}
				catch
				{
				}
			}
		}
		/*************************/
		/*       ｱｯﾌﾟﾃﾞｰﾄ        */
		/*************************/
		// ①自分のﾌﾟﾛｸﾞﾗﾑ名称を変更
		// ②新しいﾌﾟﾛｸﾞﾗﾑをｺﾋﾟｰ
		// ③新しいﾌﾟﾛｸﾞﾗﾑにﾌﾟﾛｾｽIDを渡して起動
		// ④自分のﾌﾟﾛｸﾞﾗﾑを終了
		// ⑤Program ｸﾗｽに UpDateWait を配置して、旧ﾌﾟﾛｸﾞﾗﾑが終了するまで待つ
		public static void UpDateProgram( string UpDatePath )
		{
			string progName = Path.GetFileNameWithoutExtension(								// program.exe
				Assembly.GetExecutingAssembly().Location ) +
				Path.GetExtension( Assembly.GetExecutingAssembly().Location );
			string tempName = Path.GetFileNameWithoutExtension( progName ) + ".tmp";		// program.tmp
			string crtPath  = Directory.GetCurrentDirectory();
			try
			{
				// 旧ﾌﾟﾛｸﾞﾗﾑ起動中に、自分自身の名前を一旦別のものに変更(program.exe -> program.old)
				// 旧ﾌﾟﾛｸﾞﾗﾑから、新アプリを program.exe という名前でｺﾋﾟｰ
				// 旧ﾌﾟﾛｸﾞﾗﾑから新ﾌﾟﾛｸﾞﾗﾑに引数で自分のpidを渡し終了する
				// 新ﾌﾟﾛｸﾞﾗﾑは、旧ﾌﾟﾛｸﾞﾗﾑを削除する(program.old)
				File.Delete(   crtPath    + "\\" + tempName );
				File.Move(     crtPath    + "\\" + progName, crtPath + "\\" + tempName );
				File.Copy(     UpDatePath + "\\" + progName, crtPath + "\\" + progName, true );
				// 第1引数：起動ﾌﾟﾛｸﾞﾗﾑ名
				// 第2引数：起動ﾌﾟﾛｸﾞﾗﾑへの引数
				Process.Start( crtPath    + "\\" + progName, "/upDate " + Process.GetCurrentProcess().Id );
				Application.Exit();
			}
			catch
			{
				// 旧ﾌﾟﾛｸﾞﾗﾑを元のﾌﾟﾛｸﾞﾗﾑ名に戻す(program.old -> program.exe)
				File.Move( crtPath + "\\" + tempName, crtPath + "\\" + progName );
			}
		}
		/*************************/
		/*     ｱｯﾌﾟﾃﾞｰﾄｳｴｲﾄ      */
		/*************************/
		public static void UpDateWait()
		{
			// 引数を取得
			if( Environment.CommandLine.IndexOf( "/upDate", StringComparison.CurrentCultureIgnoreCase ) != -1 )
			{
				try
				{
					string[] args = Environment.GetCommandLineArgs();
					/* ---< 旧ﾌﾟﾛｸﾞﾗﾑのﾌﾟﾛｾｽID取得 >--- */
					int pid  = Convert.ToInt32( args[2] );
					/* ---< 旧ﾌﾟﾛｸﾞﾗﾑの終了待ち >--- */
					Process.GetProcessById( pid ).WaitForExit();
				}
				catch
				{
				}
			}
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                       --- ｱﾌﾟﾘｹｰｼｮﾝｸﾗｽ ---                        */
	/*                                                                   */
	/*********************************************************************/
	public static class AppInfo
	{
		/* ---< ｱｯｾﾒﾝﾌﾞﾘ情報 >--- */
		private static readonly AssemblyInfo gAplAssemblyInfo = new AssemblyInfo( Assembly.GetExecutingAssembly() );
		/* ---< PC動作環境情報 >--- */
		private static readonly PcInfo       gPcInfo          = new PcInfo();
		/* ---< ｱﾌﾟﾘｹｰｼｮﾝﾘｿｰｽ >--- */
		private static readonly AppResource  gAppResource     = new AppResource();
		/* ---< ｱﾌﾟﾘｹｰｼｮﾝｾｯﾃｨﾝｸﾞ >--- */
		private static readonly AppSetting   gAppSetting      = new AppSetting();

		/*************************/
		/*        ﾌﾟﾛﾊﾟﾃｨ        */
		/*************************/
		public static AssemblyInfo AplAssemblyInfo
		{
			get
			{
				return gAplAssemblyInfo;
			}
		}
		public static PcInfo PcInfo
		{
			get
			{
				return gPcInfo;
			}
		}
		public static AppResource AppResource
		{
			get
			{
				return gAppResource;
			}
		}
		public static AppSetting AppSetting
		{
			get
			{
				return gAppSetting;
			}
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                      --- ｱｯｾﾒﾝﾌﾞﾘ情報ｸﾗｽ ---                      */
	/*                                                                   */
	/*********************************************************************/
	public sealed class AssemblyInfo
	{
		public string FileName      { get; private set; }
		public string Version       { get; private set; }
		public string FileVersion   { get; private set; }
		public string Title         { get; private set; }
		public string Description   { get; private set; }
		public string Configuration { get; private set; }
		public string Company       { get; private set; }
		public string Product       { get; private set; }
		public string Copyright     { get; private set; }
		public string Trademark     { get; private set; }
		public string Culture       { get; private set; }
 
		public AssemblyInfo( Assembly assembly )
		{
			FileName      = assembly.GetName().Name;
			Version       = assembly.GetName().Version.ToString();
			FileVersion   = GetAttributeName< AssemblyFileVersionAttribute   >( assembly, a => a.Version       );
			Title         = GetAttributeName< AssemblyTitleAttribute         >( assembly, a => a.Title         );
			Description   = GetAttributeName< AssemblyDescriptionAttribute   >( assembly, a => a.Description   );
			Configuration = GetAttributeName< AssemblyConfigurationAttribute >( assembly, a => a.Configuration );
			Company       = GetAttributeName< AssemblyCompanyAttribute       >( assembly, a => a.Company       );
			Product       = GetAttributeName< AssemblyProductAttribute       >( assembly, a => a.Product       );
			Copyright     = GetAttributeName< AssemblyCopyrightAttribute     >( assembly, a => a.Copyright     );
			Trademark     = GetAttributeName< AssemblyTrademarkAttribute     >( assembly, a => a.Trademark     );
			Culture       = GetAttributeName< AssemblyCultureAttribute       >( assembly, a => a.Culture       );
		}
		private string GetAttributeName<T>( Assembly assembly, Func<T, string> selector ) where T : Attribute
		{
			var attr = assembly.GetCustomAttributes(typeof(T), true).Cast<T>().FirstOrDefault();
			return (attr == null) ? "" : selector( attr );
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                     --- PC動作環境情報ｸﾗｽ ---                     */
	/*                                                                   */
	/*********************************************************************/
	public class PcInfo
	{
		/*************************/
		/*        ﾌﾟﾛﾊﾟﾃｨ        */
		/*************************/
		// OS_Version        : Microsoft Windows NT 6.2.9200.0
		// OS_Product_Name   : Windows 10 Pro
		// OS_Release        : 1709								Windows 10 のﾊﾞｰｼﾞｮﾝを調べる用のﾃﾞｰﾀ
		// OS_Build          : 16299
		// OS_Bit            : 64 bit							OSのﾋﾞｯﾄ
		// Process_Bit       : 64 bit							ｱﾌﾟﾘのﾌﾟﾛｾｽが 64 bit と 32 bit のどちらで動作しているか
		// DotNet_Ver        : 4.0.30319.42000					.NET Framework のﾊﾞｰｼﾞｮﾝ。4.0 以降はずっと 4.0.xxxxx 形式
		// Reg_DotNet_Ver    : 4.7.02556						.NET Framework のﾊﾞｰｼﾞｮﾝ。4.5 系 → 4.5.xxxxx
		// Reg_DotNet_Release: 461308							一番詳しい .NET Framework のﾊﾞｰｼﾞｮﾝ
		// Host_Name         : DESKTOP
		// Machine_Name      : DESKTOP
		public string OS_Version         { get; } = "OS_Version："         + Environment.OSVersion.VersionString;
		public string OS_Product_Name    { get; } = "OS_Product_Name："    + GetRegistryValue( @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion", "ProductName"   );
		public string OS_Release         { get; } = "OS_Release："         + GetRegistryValue( @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion", "ReleaseId"     );
		public string OS_Build           { get; } = "OS_Build："           + GetRegistryValue( @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion", "CurrentBuild"  );
		public string OS_Bit             { get; } = "OS_Bit："             + ( Environment.Is64BitOperatingSystem ? "64 bit" : "32 bit" ).ToString();
		public string Process_Bit        { get; } = "Process_Bit："        + ( Environment.Is64BitProcess ?         "64 bit" : "32 bit" ).ToString();
		public string DotNet_Ver         { get; } = "DotNet_Ver："         + Environment.Version.ToString();
		public string Reg_DotNet_Ver     { get; } = "Reg_DotNet_Ver："     + GetRegistryValue( @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full", "Version" );
		public string Reg_DotNet_Release { get; } = "Reg_DotNet_Release：" + GetRegistryValue( @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full", "Release" );
		public string Host_Name          { get; } = "Host_Name："          + Dns.GetHostName();
		public string Machine_Name       { get; } = "Machine_Name："       + Environment.MachineName;
		public List<string> MemoryInfo
		{
			get
			{
				int count = GetPcMemory(
					out List<string> TotalVisibleMemorySize,
					out List<string> FreePhysicalMemory,
					out List<string> TotalVirtualMemorySize,
					out List<string> FreeVirtualMemory );
					
				List<string> temp = new List<string>();
				for( int index = 0; index < count; index++ )
				{
					temp.Add( TotalVisibleMemorySize[ index ] );
					temp.Add( FreePhysicalMemory[ index ] );
					temp.Add( TotalVirtualMemorySize[ index ] );
					temp.Add( FreeVirtualMemory[ index ] );
				}
				return temp;
			}
		}
		/*************************/
		/*     ﾚｼﾞｽﾄﾘ値取得      */
		/*************************/
		private static string GetRegistryValue( string Keyname, string Valuename )
		{
			return Registry.GetValue( Keyname, Valuename, "" ).ToString();
		}
		/*************************/
		/*  PCのﾒﾓﾘ使用状況取得  */
		/*************************/
		public int GetPcMemory(
			out List<string> TotalVisibleMemorySize,
			out List<string> FreePhysicalMemory,
			out List<string> TotalVirtualMemorySize,
			out List<string> FreeVirtualMemory )
		{
			System.Management.ManagementClass            mc  = new System.Management.ManagementClass( "Win32_OperatingSystem" );
			System.Management.ManagementObjectCollection moc = mc.GetInstances();
 
			TotalVisibleMemorySize = new List<string>();
			FreePhysicalMemory     = new List<string>();
			TotalVirtualMemorySize = new List<string>();
			FreeVirtualMemory      = new List<string>();
			int index = 0;
			foreach( System.Management.ManagementObject mo in moc )
			{
				// 合計物理ﾒﾓﾘ
				TotalVisibleMemorySize.Add( "TotalVisibleMemorySize" + "[" + index.ToString() + "]：" + mo["TotalVisibleMemorySize"].ToString() );
				// 利用可能な物理ﾒﾓﾘ
				FreePhysicalMemory.Add(     "FreePhysicalMemory"     + "[" + index.ToString() + "]：" + mo["FreePhysicalMemory"].ToString()     );
				// 合計仮想ﾒﾓﾘ
				TotalVirtualMemorySize.Add( "TotalVirtualMemorySize" + "[" + index.ToString() + "]：" + mo["TotalVirtualMemorySize"].ToString() );
				// 利用可能な仮想ﾒﾓﾘ
				FreeVirtualMemory.Add(      "FreeVirtualMemory"      + "[" + index.ToString() + "]：" + mo["FreeVirtualMemory"].ToString()      );
				index++;
 
				mo.Dispose();
			}
			moc.Dispose();
			mc.Dispose();
			return index;
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                     --- ｱﾌﾟﾘｹｰｼｮﾝﾘｿｰｽｸﾗｽ ---                      */
	/*                                                                   */
	/*********************************************************************/
	public class AppResource
	{
		private ToolStripProgressBar        gProgress = null;								// ﾌﾟﾛｸﾞﾚｽｽﾃｰﾀｽﾊﾞｰ
		private static ToolStripStatusLabel gLabel    = null;								// ｽﾃｰﾀｽ表示ﾗﾍﾞﾙ

		/*************************/
		/*        ﾌﾟﾛﾊﾟﾃｨ        */
		/*************************/
		/* ---< ﾌﾟﾛｸﾞﾚｽｽﾃｰﾀｽﾊﾞｰ >--- */
		public ToolStripProgressBar Progress
		{
			set { gProgress = value;			}
		}
		/* ---< ｽﾃｰﾀｽ表示ﾗﾍﾞﾙ >--- */
		public ToolStripStatusLabel Label
		{
			set { gLabel = value;				}
		}
		public string LabelText
		{
			get
			{
				return gLabel.Text;
			}
			set
			{
				if( gLabel != null )
				{
					gLabel.Text = value;
					// Refreshがないので、親を見つけてRefresh()
					gLabel.GetCurrentParent()?.Refresh();
				}
			}
		}
		/*************************/
		/*    ﾌﾟﾛｸﾞﾚｽｽﾃｰﾀｽﾊﾞｰ    */
		/*************************/
		public void SetProgress( int Max, int Count )
		{
			/* ---< 表示 >--- */
			if( gProgress != null )
			{
				// ｶｳﾝﾄ0でﾊﾞｰを消す。基本MES_PROGRESS_ENDで実行される
				if( Count == 0 )
				{
					gProgress.Value   = 0;
					gProgress.Visible = false;
					gProgress.Invalidate();
					return;
				}
				gProgress.Visible = true;

				gProgress.Minimum = 0;
				gProgress.Maximum = Max;
				/* ---< Valueは一番最後にｾｯﾄ(範囲越え対応) 1を足してｾｯﾄし、ｾｯﾄし直すのは表示ずれを無くす為 >--- */
				if( Count < gProgress.Maximum )
				{
					gProgress.Value = Count + 1;
					gProgress.Value = Count;
				}
				gProgress.Invalidate();
			}
		}
	}
	/*********************************************************************/
	/*                                                                   */
	/*                     --- ｱﾌﾟﾘｹｰｼｮﾝｾｯﾃｨﾝｸﾞ ---                      */
	/*                                                                   */
	/*********************************************************************/
	public class AppSetting : ApplicationSettingsBase
	{
		[UserScopedSetting()]
		[DefaultSettingValue( "enJapanese" )]
		public LanguageType Lanuage															// 言語
		{
			get
			{
				return (LanguageType)this[ "Lanuage" ];
			}
			set
			{
				this[ "Lanuage" ] = value;
			}
		}
		[UserScopedSetting()]
		public bool[] BoolArray
		{
				get
				{
					return (bool[])this[ "BoolArray" ];
				}
				set
				{
					this[ "BoolArray" ] = value;
				}
		}
	}
}